/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.processor.deleter.tasks;

import java.io.DataInputStream;
import java.nio.file.Path;
import java.util.BitSet;
import java.util.LinkedHashMap;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.storage.RegionFile;
import pregenerator.base.api.TextUtil;
import pregenerator.impl.misc.FilePos;
import pregenerator.impl.processor.PrepareProgress;
import pregenerator.impl.processor.deleter.DeleteProcess;
import pregenerator.impl.processor.deleter.tasks.BaseDeletionTask;
import pregenerator.impl.processor.generator.tasks.ITask;

public class DeletionTimeout
extends BaseDeletionTask {
    long center;
    int radius;
    long timeOut;
    long cachedSize = -1L;

    public DeletionTimeout(String name, int dimensionId, FilePos center, int radius, long timeOut) {
        super(name, dimensionId);
        this.center = center.asLong();
        this.radius = radius;
        this.timeOut = timeOut;
    }

    public DeletionTimeout(NBTTagCompound nbt) {
        super(nbt);
        this.center = nbt.func_74763_f("center");
        this.radius = nbt.func_74762_e("radius");
        this.timeOut = nbt.func_74763_f("time");
        this.cachedSize = nbt.func_74764_b("cache") ? nbt.func_74763_f("cache") : -1L;
    }

    @Override
    public NBTTagCompound write() {
        NBTTagCompound nbt = super.write();
        nbt.func_74772_a("center", this.center);
        nbt.func_74768_a("radius", this.radius);
        nbt.func_74772_a("time", this.timeOut);
        if (this.cachedSize != -1L) {
            nbt.func_74772_a("cache", this.cachedSize);
        }
        return nbt;
    }

    @Override
    public byte getId() {
        return 15;
    }

    @Override
    public ITextComponent getShapeName() {
        return TextUtil.translate("task.chunk_pregen.shape_type.timeout");
    }

    @Override
    public ChunkPos getCenter() {
        return new ChunkPos(FilePos.getX(this.center), FilePos.getZ(this.center));
    }

    @Override
    public int getMaxRadius() {
        return this.radius;
    }

    @Override
    public long getTaskSize() {
        return this.cachedSize == -1L ? (this.cachedSize = this.calculateCacheSize()) : this.cachedSize;
    }

    @Override
    protected void append(ITextComponent builder) {
        ITask.insert("task.chunk_pregen.task_type", TextUtil.translate("task.chunk_pregen.shape_type.timeout"), builder, TextFormatting.DARK_PURPLE);
        ITask.insert("task.chunk_pregen.timeout", this.timeOut, builder, TextFormatting.DARK_PURPLE);
        ITask.insert("task.chunk_pregen.x_coord", FilePos.getX(this.center), builder, TextFormatting.YELLOW);
        ITask.insert("task.chunk_pregen.z_coord", FilePos.getZ(this.center), builder, TextFormatting.YELLOW);
        ITask.insert("task.chunk_pregen.min_radius", this.radius, builder, TextFormatting.BLUE);
    }

    @Override
    protected DeleteProcess createTask(WorldServer world, Path folder, PrepareProgress progress) {
        LinkedHashMap<Long, BitSet> toDelete = new LinkedHashMap<Long, BitSet>();
        long total = 0L;
        progress.setMax((long)this.getRegionFiles().size() * 1024L);
        int xPos = FilePos.getX(this.center);
        int zPos = FilePos.getZ(this.center);
        for (Path subFile : this.getRegionFiles()) {
            if (!progress.isAlive()) break;
            String[] name = subFile.getFileName().toString().split("\\.");
            int minX = (Integer.parseInt(name[1]) << 5) - xPos;
            int minZ = (Integer.parseInt(name[2]) << 5) - zPos;
            if (minX < -this.radius || minX + 32 > this.radius || minZ < -this.radius || minZ + 32 > this.radius) {
                try {
                    RegionFile file = new RegionFile(subFile.toFile());
                    BitSet set = new BitSet(1024);
                    for (int i = 0; i < 1024; ++i) {
                        int x = i % 32 + minX;
                        int z = i / 32 + minZ;
                        if (x <= this.radius && x >= -this.radius && z <= this.radius && z >= -this.radius || !file.func_76709_c(i % 32, i / 32) || !this.canBeDeleted(file, i % 32, i / 32)) continue;
                        set.set(i);
                        ++total;
                    }
                    if (!set.isEmpty()) {
                        toDelete.put(ChunkPos.func_77272_a((int)(minX >> 5), (int)(minZ >> 5)), set);
                    }
                    progress.growValue(1024);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            progress.growValue(1024);
        }
        this.cachedSize = total;
        return new DeleteProcess(folder, toDelete);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean canBeDeleted(RegionFile file, int x, int z) {
        try (DataInputStream stream = file.func_76704_a(x, z);){
            if (stream == null) return false;
            NBTTagCompound nbt = CompressedStreamTools.func_74794_a((DataInputStream)stream);
            boolean bl = nbt != null && nbt.func_74775_l("Level").func_74763_f("InhabitedTime") <= this.timeOut;
            return bl;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private long calculateCacheSize() {
        long total = 0L;
        int xPos = FilePos.getX(this.center);
        int zPos = FilePos.getZ(this.center);
        for (Path subFile : this.getRegionFiles()) {
            String[] name = subFile.getFileName().toString().split("\\.");
            int minX = (Integer.parseInt(name[1]) << 5) - xPos;
            int minZ = (Integer.parseInt(name[2]) << 5) - zPos;
            if (minX >= -this.radius && minX + 32 <= this.radius && minZ >= -this.radius && minZ + 32 <= this.radius) continue;
            try {
                RegionFile file = new RegionFile(subFile.toFile());
                for (int i = 0; i < 1024; ++i) {
                    int x = i % 32 + minX;
                    int z = i / 32 + minZ;
                    if (x <= this.radius && x >= -this.radius && z <= this.radius && z >= -this.radius || !file.func_76709_c(i % 32, i / 32)) continue;
                    ++total;
                }
                file.func_76708_c();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return total;
    }
}

