/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.processor.generator.tasks;

import java.time.Duration;
import java.util.UUID;
import java.util.concurrent.Future;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import pregenerator.ChunkPregenerator;
import pregenerator.base.api.TextUtil;
import pregenerator.impl.misc.Area;
import pregenerator.impl.processor.PrepareProgress;
import pregenerator.impl.processor.generator.ChunkProcess;
import pregenerator.impl.processor.generator.GenerationType;
import pregenerator.impl.processor.generator.tasks.ITask;

public abstract class BaseTask
implements ITask {
    String name;
    int dimensionId;
    GenerationType genType;
    UUID task = UUID.randomUUID();
    long activeTime = 0L;
    boolean cached;

    public BaseTask(NBTTagCompound nbt) {
        this(nbt.func_74779_i("name"), nbt.func_74762_e("dim"), GenerationType.values()[nbt.func_74762_e("genType")]);
        this.activeTime = nbt.func_74763_f("active_time");
        if (nbt.func_186855_b("taskId")) {
            this.task = nbt.func_186857_a("taskId");
        }
    }

    public BaseTask(String name, int dimensionId, GenerationType genType) {
        this.name = name;
        this.dimensionId = dimensionId;
        this.genType = genType;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public UUID getTaskId() {
        return this.task;
    }

    @Override
    public Area getArea() {
        return new Area(this.getCenter(), this.getMaxRadius());
    }

    @Override
    public int getDimension() {
        return this.dimensionId;
    }

    @Override
    public GenerationType getType() {
        return this.genType;
    }

    @Override
    public long getActiveTime() {
        return this.activeTime;
    }

    @Override
    public void addActiveTime(long value) {
        this.activeTime += value;
    }

    @Override
    public ITextComponent getDescription() {
        ITextComponent text = TextUtil.literal(this.name);
        ITask.insert("task.chunk_pregen.name", this.getName(), text, TextFormatting.AQUA);
        ITask.insert("task.chunk_pregen.dimension", TextUtil.dimension(this.getDimension()), text, TextFormatting.GREEN);
        ITask.insert("task.chunk_pregen.genType", this.genType.createText(), text, TextFormatting.AQUA);
        this.append(text);
        ITask.removeLast(text.func_150253_a());
        return TextUtil.translate("task.chunk_pregen.wrap", text);
    }

    protected abstract void append(ITextComponent var1);

    @Override
    public NBTTagCompound write() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74778_a("name", this.name);
        compound.func_74768_a("dim", this.dimensionId);
        compound.func_74774_a("genType", (byte)this.genType.ordinal());
        compound.func_186854_a("taskId", this.task);
        compound.func_74772_a("active_time", this.activeTime);
        return compound;
    }

    @Override
    public Future<ChunkProcess> createTask(PrepareProgress progress) {
        WorldServer world = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(this.dimensionId);
        if (world == null) {
            return null;
        }
        DimensionType dimension = world.field_73011_w.func_186058_p();
        this.cached = dimension.shouldLoadSpawn();
        dimension.setLoadSpawn(true);
        return ChunkPregenerator.SERVICE.submit(() -> this.createTask(world, progress));
    }

    protected abstract ChunkProcess createTask(WorldServer var1, PrepareProgress var2);

    @Override
    public void onTaskStopped(World world, Duration totalTime, long totalChunks) {
        world.field_73011_w.func_186058_p().setLoadSpawn(this.cached);
    }
}

