/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.processor.generator.tasks;

import java.time.Duration;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import pregenerator.base.api.TextUtil;
import pregenerator.impl.misc.FilePos;
import pregenerator.impl.processor.ChunkCalculator;
import pregenerator.impl.processor.PrepareProgress;
import pregenerator.impl.processor.generator.BenchmarkManager;
import pregenerator.impl.processor.generator.ChunkProcess;
import pregenerator.impl.processor.generator.GenerationType;
import pregenerator.impl.processor.generator.tasks.BaseTask;
import pregenerator.impl.processor.generator.tasks.ITask;

public class BenchmarkTask
extends BaseTask {
    boolean small;

    public BenchmarkTask(NBTTagCompound nbt) {
        super(nbt);
        this.small = nbt.func_74767_n("small");
    }

    public BenchmarkTask(String name, int dimensionId, boolean small) {
        super(name, dimensionId, GenerationType.FAST_CHECK_GEN);
        this.small = small;
    }

    @Override
    public byte getId() {
        return 7;
    }

    @Override
    public ITextComponent getShapeName() {
        return TextUtil.translate("task.chunk_pregen.shape_type.benchmark");
    }

    @Override
    public long getTaskSize() {
        return this.small ? 40000L : 250000L;
    }

    @Override
    public ChunkPos getCenter() {
        return new ChunkPos(0, 0);
    }

    @Override
    public int getMaxRadius() {
        return this.small ? 100 : 200;
    }

    @Override
    public void append(ITextComponent builder) {
        ITask.insert("task.chunk_pregen.task_type", TextUtil.translate("task.chunk_pregen.shape_type.benchmark"), builder, TextFormatting.DARK_PURPLE);
        ITask.insert("task.chunk_pregen.radius", this.small ? 100 : 250, builder, TextFormatting.BLUE);
    }

    @Override
    public ChunkProcess createTask(WorldServer world, PrepareProgress progress) {
        progress.setMax(this.getTaskSize());
        ChunkProcess process = new ChunkProcess(world, this);
        process.addTaskList(ChunkCalculator.getSquareShape(0, 0, this.small ? 100 : 250, progress), new FilePos(0, 0), progress);
        return process;
    }

    @Override
    public void onTaskStopped(World world, Duration totalTime, long totalChunks) {
        BenchmarkManager.INSTANCE.addBenchmarkResult(this.getTaskSize(), totalChunks, totalTime.toMillis(), this.small, world);
        super.onTaskStopped(world, totalTime, totalChunks);
    }
}

