/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.processor.generator.tasks;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.WorldServer;
import pregenerator.base.api.TextUtil;
import pregenerator.impl.misc.Area;
import pregenerator.impl.misc.FilePos;
import pregenerator.impl.processor.ChunkCalculator;
import pregenerator.impl.processor.PrepareProgress;
import pregenerator.impl.processor.generator.ChunkProcess;
import pregenerator.impl.processor.generator.GenerationType;
import pregenerator.impl.processor.generator.tasks.BaseTask;
import pregenerator.impl.processor.generator.tasks.ITask;

public class CircleAreaTask
extends BaseTask {
    long min;
    long max;
    long center;

    public CircleAreaTask(String name, int dimensionId, GenerationType genType, FilePos min, FilePos max) {
        super(name, dimensionId, genType);
        this.min = min.asLong();
        this.max = max.asLong();
        this.center = FilePos.asLong(min.x + (max.x - min.x) / 2, min.z + (max.z - min.z) / 2);
    }

    public CircleAreaTask(NBTTagCompound nbt) {
        super(nbt);
        this.min = nbt.func_74763_f("min");
        this.max = nbt.func_74763_f("max");
        this.center = nbt.func_74763_f("center");
    }

    @Override
    public NBTTagCompound write() {
        NBTTagCompound tag = super.write();
        tag.func_74772_a("min", this.min);
        tag.func_74772_a("max", this.max);
        tag.func_74772_a("center", this.center);
        return tag;
    }

    @Override
    public ChunkPos getCenter() {
        return new ChunkPos(FilePos.getX(this.center), FilePos.getZ(this.center));
    }

    @Override
    public int getMaxRadius() {
        return Math.max((FilePos.getX(this.max) - FilePos.getX(this.min)) / 2, (FilePos.getZ(this.max) - FilePos.getZ(this.min)) / 2);
    }

    @Override
    public Area getArea() {
        return new Area(new ChunkPos(FilePos.getX(this.min), FilePos.getZ(this.min)), new ChunkPos(FilePos.getX(this.max), FilePos.getZ(this.max)));
    }

    @Override
    public byte getId() {
        return 6;
    }

    @Override
    public ITextComponent getShapeName() {
        return TextUtil.translate("task.chunk_pregen.shape_type.circle_area");
    }

    @Override
    public long getTaskSize() {
        long x = FilePos.getX(this.max) - FilePos.getX(this.min);
        long z = FilePos.getZ(this.max) - FilePos.getZ(this.min);
        return (long)((double)(x * z) * Math.PI);
    }

    @Override
    public void append(ITextComponent builder) {
        FilePos min = new FilePos(this.min);
        FilePos max = new FilePos(this.max);
        ITask.insert("task.chunk_pregen.task_type", TextUtil.translate("task.chunk_pregen.shape_type.circle_area"), builder, TextFormatting.DARK_PURPLE);
        ITask.insert("task.chunk_pregen.from", new Object[]{min.x, min.z}, builder, TextFormatting.YELLOW);
        ITask.insert("task.chunk_pregen.to", new Object[]{max.x, max.z}, builder, TextFormatting.YELLOW);
    }

    @Override
    public ChunkProcess createTask(WorldServer world, PrepareProgress progress) {
        progress.setMax(this.getTaskSize());
        ChunkProcess process = new ChunkProcess(world, this);
        FilePos min = new FilePos(this.min);
        FilePos max = new FilePos(this.max);
        process.addTaskList(ChunkCalculator.genCircleArea(min.x, min.z, max.x, max.z, progress), new FilePos(this.center), progress);
        return process;
    }
}

