/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.processor.minitasks;

import it.unimi.dsi.fastutil.ints.Int2LongLinkedOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2LongMap;
import it.unimi.dsi.fastutil.ints.Int2LongMaps;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import pregenerator.base.api.TextUtil;
import pregenerator.impl.processor.minitasks.BaseChunkScanTask;

public class AgeScan
extends BaseChunkScanTask<Long> {
    private static final long[] TICKS = new long[]{100L, 1200L, 12000L, 36000L};
    private static final String[] KEYS = new String[]{"mini_task.chunk_pregen.age_scan.first", "mini_task.chunk_pregen.age_scan.second", "mini_task.chunk_pregen.age_scan.third", "mini_task.chunk_pregen.age_scan.fourth", "mini_task.chunk_pregen.age_scan.fith"};
    int lastFive = 0;
    Int2LongMap counted = Int2LongMaps.synchronize((Int2LongMap)new Int2LongLinkedOpenHashMap());

    public AgeScan(int dimension, UUID source) {
        super(dimension, source);
    }

    @Override
    public boolean hasClientOverlay() {
        return true;
    }

    @Override
    public byte getClientDataId() {
        return 3;
    }

    @Override
    public void writeData(PacketBuffer buffer) {
        buffer.writeInt(this.dimension);
        buffer.func_150787_b(this.filesScanned);
        buffer.func_150787_b(this.totalFiles);
        buffer.writeLong((long)this.chunksScanned);
        buffer.writeLong((long)this.totalChunks);
    }

    @Override
    protected void onInit() {
        this.sendMessage(TextUtil.translate("mini_task.chunk_pregen.age_scan.start", this.totalFiles));
    }

    @Override
    protected void onProgressReached(int progress) {
        if (progress - this.lastFive >= 5) {
            this.lastFive = progress;
            this.sendMessage(TextUtil.applyTextStyle(TextUtil.translate("mini_task.chunk_pregen.age_scan.progress", TextUtil.NUMBERS.format(progress)), TextFormatting.AQUA));
        }
    }

    @Override
    protected void test(NBTTagCompound tag, Consumer<Long> output) {
        if (tag == null) {
            return;
        }
        output.accept(tag.func_74775_l("Level").func_74763_f("InhabitedTime"));
    }

    @Override
    protected void onFailure(ChunkPos pos, Consumer<Long> output) {
    }

    @Override
    protected void processResult(List<Long> data) {
        for (Long value : data) {
            this.counted.merge((Object)this.findIndex(value), (Object)1L, Long::sum);
        }
    }

    private int findIndex(long value) {
        for (int i = 0; i < TICKS.length; ++i) {
            if (value >= TICKS[i]) continue;
            return i;
        }
        return TICKS.length;
    }

    private Style format(int index) {
        HoverEvent hover = new HoverEvent(HoverEvent.Action.SHOW_TEXT, TextUtil.translate("mini_task.chunk_pregen.age_scan.suggestion"));
        ClickEvent click = new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, index >= 4 ? "/pregen start delete trim TrimTaskId 0 0 100" : "/pregen start delete timedtrim TrimTaskId 0 0 100 " + TICKS[index]);
        return new Style().func_150209_a(hover).func_150241_a(click).func_150238_a(TextFormatting.AQUA);
    }

    @Override
    protected void onCompletion() {
        this.sendForceMessage(TextUtil.translate("mini_task.chunk_pregen.age_scan.completed"));
        this.sendForceMessage(TextUtil.translate("mini_task.chunk_pregen.age_scan.found"));
        for (int i = 0; i < 5; ++i) {
            this.sendForceMessage(TextUtil.translate("mini_task.chunk_pregen.age_scan.time", TextUtil.translateStyled(KEYS[i], TextFormatting.GOLD), TextUtil.NUMBERS.format(this.counted.get(i))).func_150255_a(this.format(i)));
        }
    }
}

