/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.processor.minitasks;

import io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueue;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongLinkedOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongList;
import it.unimi.dsi.fastutil.longs.LongListIterator;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.longs.LongSets;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import pregenerator.base.api.TextUtil;
import pregenerator.impl.misc.FilePos;
import pregenerator.impl.processor.deleter.tasks.DeletionSpecific;
import pregenerator.impl.processor.minitasks.BaseChunkScanTask;
import pregenerator.impl.storage.PregenTaskStorage;

public class CorruptionScan
extends BaseChunkScanTask<Long> {
    LongSet values = LongSets.synchronize((LongSet)new LongLinkedOpenHashSet());
    int lastFive = 0;

    public CorruptionScan(int dimension, UUID source) {
        super(dimension, source);
    }

    @Override
    public boolean hasClientOverlay() {
        return true;
    }

    @Override
    public byte getClientDataId() {
        return 4;
    }

    @Override
    public void writeData(PacketBuffer buffer) {
        buffer.writeInt(this.dimension);
        buffer.func_150787_b(this.filesScanned);
        buffer.func_150787_b(this.totalFiles);
        buffer.writeLong((long)this.chunksScanned);
        buffer.writeLong((long)this.totalChunks);
        buffer.func_150787_b(this.values.size());
    }

    @Override
    protected void test(NBTTagCompound tag, Consumer<Long> output) {
    }

    @Override
    protected void onFailure(ChunkPos pos, Consumer<Long> output) {
        output.accept(FilePos.asLong(pos.field_77276_a, pos.field_77275_b));
    }

    @Override
    protected void onInit() {
    }

    @Override
    protected void onProgressReached(int progress) {
        if (progress - this.lastFive >= 5) {
            this.lastFive = progress;
            this.sendMessage(TextUtil.applyTextStyle(TextUtil.translate("mini_task.chunk_pregen.age_scan.progress", TextUtil.NUMBERS.format(progress)), TextFormatting.AQUA));
        }
    }

    @Override
    protected void processResult(List<Long> data) {
        this.values.addAll(data);
    }

    @Override
    protected void onCompletion() {
        if (this.values.isEmpty()) {
            this.sendForceMessage(TextUtil.translate("mini_task.chunk_pregen.corrupt_scan.none_found"));
            return;
        }
        this.sendForceMessage(TextUtil.translate("mini_task.chunk_pregen.corrupt_scan.found", this.values.size()));
        Long2ObjectLinkedOpenHashMap regionMapped = new Long2ObjectLinkedOpenHashMap();
        LongIterator iter = this.values.iterator();
        while (iter.hasNext()) {
            long value = iter.nextLong();
            ((LongList)regionMapped.computeIfAbsent((Object)ChunkPos.func_77272_a((int)(FilePos.getX(value) >> 5), (int)(FilePos.getZ(value) >> 5)), T -> new LongArrayList())).add(value);
        }
        for (Long2ObjectMap.Entry entry : regionMapped.long2ObjectEntrySet()) {
            long pos = entry.getLongKey();
            LongList list = (LongList)entry.getValue();
            this.sendForceMessage(TextUtil.translate("mini_task.chunk_pregen.corrupt_scan.region", TextUtil.NUMBERS.format(list.size()), FilePos.getX(pos), FilePos.getZ(pos)));
            LongListIterator iter2 = list.iterator();
            while (iter2.hasNext()) {
                long value = iter2.nextLong();
                this.sendForceMessage(TextUtil.translate("mini_task.chunk_pregen.corrupt_scan.chunk", FilePos.getX(value), FilePos.getZ(value), FilePos.getX(value) & 0xF, FilePos.getZ(value) & 0xF));
            }
            this.sendForceMessage(TextUtil.empty());
        }
        if (PregenTaskStorage.getStorage().storeTask(new DeletionSpecific("corrupt_deletion", this.dimension, (List<Long>)new LongArrayList((LongCollection)this.values)), (MessagePassingQueue.Consumer<ITextComponent>)((MessagePassingQueue.Consumer)this::sendForceMessage))) {
            this.sendForceMessage(TextUtil.translateStyled("mini_task.chunk_pregen.corrupt_scan.task", TextFormatting.GREEN).func_150255_a(this.createStyle()));
        }
    }

    private Style createStyle() {
        return new Style().func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/pregen continue corrupt_deletion")).func_150228_d(Boolean.valueOf(true));
    }
}

