/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.storage;

import io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueue;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.fml.common.FMLCommonHandler;
import pregenerator.base.api.TextUtil;
import pregenerator.impl.processor.IBaseTask;
import pregenerator.impl.processor.generator.tasks.ITask;
import pregenerator.impl.storage.GlobalListeners;
import pregenerator.impl.storage.ProcessListener;

public class PregenTaskStorage
extends WorldSavedData {
    Map<String, IBaseTask> pregenTasks = new Object2ObjectLinkedOpenHashMap();
    Map<String, PregenMemory> memories = new Object2ObjectLinkedOpenHashMap();
    Map<ProcessListener, Boolean> listeners = new HashMap<ProcessListener, Boolean>();
    Set<String> commands = new HashSet<String>();

    public PregenTaskStorage(String id) {
        super("PregenTaskList");
    }

    public static PregenTaskStorage getStorage() {
        return PregenTaskStorage.getFromServer(FMLCommonHandler.instance().getMinecraftServerInstance());
    }

    public static PregenTaskStorage getFromServer(MinecraftServer server) {
        return PregenTaskStorage.getFromWorld((World)server.func_71218_a(0));
    }

    private static PregenTaskStorage getFromWorld(World world) {
        PregenTaskStorage storage = (PregenTaskStorage)world.func_72943_a(PregenTaskStorage.class, "PregenTaskList");
        if (storage == null) {
            storage = new PregenTaskStorage("");
            world.func_72823_a("PregenTaskList", (WorldSavedData)storage);
        }
        return storage;
    }

    public void func_76184_a(NBTTagCompound nbt) {
        NBTTagCompound tag;
        int i;
        NBTTagList list = nbt.func_150295_c("tasks", 10);
        int m = list.func_74745_c();
        for (i = 0; i < m; ++i) {
            IBaseTask task = IBaseTask.loadTask(list.func_150305_b(i));
            if (task == null) continue;
            this.pregenTasks.put(task.getName(), task);
        }
        list = nbt.func_150295_c("memories", 10);
        m = list.func_74745_c();
        for (i = 0; i < m; ++i) {
            tag = list.func_150305_b(i);
            this.memories.put(tag.func_74779_i("taskId"), new PregenMemory(nbt));
        }
        list = nbt.func_150295_c("listeners", 10);
        m = list.func_74745_c();
        for (i = 0; i < m; ++i) {
            tag = list.func_150305_b(i);
            this.listeners.put(ProcessListener.create(tag.func_74779_i("id")), tag.func_74767_n("state"));
        }
        list = nbt.func_150295_c("commands", 8);
        m = list.func_74745_c();
        for (i = 0; i < m; ++i) {
            this.commands.add(list.func_150307_f(i));
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound nbt) {
        NBTTagCompound data;
        NBTTagList tasks = new NBTTagList();
        for (IBaseTask iBaseTask : this.pregenTasks.values()) {
            tasks.func_74742_a((NBTBase)IBaseTask.saveTask(iBaseTask));
        }
        nbt.func_74782_a("tasks", (NBTBase)tasks);
        tasks = new NBTTagList();
        for (Map.Entry entry : this.memories.entrySet()) {
            data = ((PregenMemory)entry.getValue()).write();
            data.func_74778_a("taskId", (String)entry.getKey());
            tasks.func_74742_a((NBTBase)data);
        }
        nbt.func_74782_a("memories", (NBTBase)tasks);
        tasks = new NBTTagList();
        for (Map.Entry entry : this.listeners.entrySet()) {
            data = new NBTTagCompound();
            data.func_74757_a("state", ((Boolean)entry.getValue()).booleanValue());
            data.func_74778_a("id", ((ProcessListener)entry.getKey()).save());
            tasks.func_74742_a((NBTBase)data);
        }
        nbt.func_74782_a("listeners", (NBTBase)tasks);
        tasks = new NBTTagList();
        for (String string : this.commands) {
            tasks.func_74742_a((NBTBase)new NBTTagString(string));
        }
        nbt.func_74782_a("commands", (NBTBase)tasks);
        return nbt;
    }

    public boolean runCommand(String id) {
        if (this.commands.add(id)) {
            this.func_76185_a();
            return true;
        }
        return false;
    }

    public PregenMemory getOrCreateMemory(ITask task) {
        return this.memories.computeIfAbsent(task.getName(), T -> {
            this.func_76185_a();
            return new PregenMemory();
        });
    }

    public boolean storeTask(IBaseTask task, MessagePassingQueue.Consumer<ITextComponent> listener) {
        if (task == null) {
            listener.accept((Object)TextUtil.impossibleScenario());
            return false;
        }
        if (this.pregenTasks.containsKey(task.getName())) {
            listener.accept((Object)TextUtil.applyTextStyle(TextUtil.translate("queue.chunk_pregen.errors.already_exists", task.getName()), TextFormatting.GOLD));
            return false;
        }
        this.pregenTasks.put(task.getName(), task);
        return true;
    }

    public Collection<String> getTaskNames() {
        return Collections.unmodifiableCollection(this.pregenTasks.keySet());
    }

    public Collection<IBaseTask> getAllTasks() {
        return Collections.unmodifiableCollection(this.pregenTasks.values());
    }

    public boolean removeTask(String taskName) {
        if (this.pregenTasks.remove(taskName) != null) {
            this.memories.remove(taskName);
            this.func_76185_a();
            return true;
        }
        return false;
    }

    public void clearAll() {
        this.pregenTasks.clear();
        this.memories.clear();
    }

    public void onTaskFinished(IBaseTask task) {
        this.pregenTasks.remove(task.getName());
        this.memories.remove(task.getName());
        this.func_76185_a();
    }

    public IBaseTask getNextTask() {
        Iterator<IBaseTask> iter = this.pregenTasks.values().iterator();
        return iter.hasNext() ? iter.next() : null;
    }

    public IBaseTask findTask(String name) {
        return this.pregenTasks.get(name);
    }

    public boolean add(UUID id, boolean state) {
        ProcessListener listener = ProcessListener.create(id);
        if (this.listeners.containsKey(listener)) {
            return this.listeners.put(listener, state) != state;
        }
        this.listeners.put(listener, state);
        return true;
    }

    public void remove(UUID id) {
        this.listeners.remove(ProcessListener.create(id));
    }

    public boolean contains(UUID id) {
        return this.listeners.containsKey(ProcessListener.create(id));
    }

    public boolean isAutoListening(UUID id) {
        ProcessListener listener = ProcessListener.create(id);
        return this.listeners.containsKey(listener) && this.listeners.get(listener) != false;
    }

    public boolean isIgnoring(UUID id) {
        ProcessListener listener = ProcessListener.create(id);
        return this.listeners.containsKey(listener) && this.listeners.get(listener) == false;
    }

    public int getState(UUID id) {
        ProcessListener listener = ProcessListener.create(id);
        return this.listeners.containsKey(listener) ? (this.listeners.get(listener).booleanValue() ? 0 : 1) : 2;
    }

    public void collectListeners(UUID id) {
        GlobalListeners global = GlobalListeners.INSTANCE;
        if (!this.isIgnoring(id)) {
            global.addListener(ProcessListener.create(id));
        }
        this.listeners.forEach((P, S) -> {
            if (S.booleanValue()) {
                global.addListener((ProcessListener)P);
            }
        });
    }

    public class PregenMemory {
        Map<Long, Byte> chunkState = new LinkedHashMap<Long, Byte>();

        public PregenMemory() {
        }

        public PregenMemory(NBTTagCompound nbt) {
            int size = nbt.func_74762_e("size");
            ByteBuffer buffer = ByteBuffer.wrap(nbt.func_74770_j("data"));
            for (int i = 0; i < size; ++i) {
                this.chunkState.put(buffer.getLong(), buffer.get());
            }
        }

        public void setState(long key, byte value) {
            if (value == 0) {
                this.chunkState.remove(key);
            } else {
                this.chunkState.put(key, value);
            }
            PregenTaskStorage.this.func_76185_a();
        }

        public int getState(long key) {
            Byte value = this.chunkState.get(key);
            return value == null ? 0 : value.intValue();
        }

        public NBTTagCompound write() {
            ByteBuffer buffer = ByteBuffer.allocate(this.chunkState.size() * 9);
            for (Map.Entry<Long, Byte> state : this.chunkState.entrySet()) {
                buffer.putLong(state.getKey());
                buffer.put(state.getValue());
            }
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74773_a("data", buffer.array());
            nbt.func_74768_a("size", this.chunkState.size());
            return nbt;
        }
    }
}

