/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.storage;

import java.util.Objects;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import pregenerator.ChunkPregenerator;
import pregenerator.base.api.TextUtil;

public class ProcessListener {
    public static final ProcessListener SERVER = new ProcessListener(null);
    UUID owner;

    public ProcessListener(UUID owner) {
        this.owner = owner;
    }

    public static ProcessListener create(String s) {
        return ProcessListener.create(s.equalsIgnoreCase("server") ? null : UUID.fromString(s));
    }

    public static ProcessListener create(UUID id) {
        return id == null ? SERVER : new ProcessListener(id);
    }

    public UUID getOwner() {
        return this.owner;
    }

    public String save() {
        return this.owner == null ? "server" : this.owner.toString();
    }

    public void sendMessage(ITextComponent text) {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (server == null) {
            return;
        }
        if (this.owner == null) {
            TextUtil.split(text, arg_0 -> ((MinecraftServer)server).func_145747_a(arg_0));
            return;
        }
        EntityPlayerMP player = server.func_184103_al().func_177451_a(this.owner);
        if (player == null) {
            return;
        }
        if (ChunkPregenerator.NETWORKING.isInstalledOnClient(player)) {
            player.func_145747_a(text);
            return;
        }
        TextUtil.split(text, arg_0 -> ((EntityPlayerMP)player).func_145747_a(arg_0));
    }

    public int hashCode() {
        return Objects.hashCode(this.owner);
    }

    public boolean equals(Object obj) {
        if (obj instanceof ProcessListener) {
            return Objects.equals(((ProcessListener)obj).owner, this.owner);
        }
        return false;
    }
}

