/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.structure;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.gen.structure.MapGenStructure;
import net.minecraft.world.gen.structure.MapGenStructureData;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureStart;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import pregenerator.impl.misc.FilePos;
import pregenerator.impl.misc.SaveZone;
import pregenerator.impl.misc.Tuple;
import pregenerator.impl.structure.StructureController;

public class MapGenStructureDataPregen
extends MapGenStructureData {
    StructureController cont;
    MapGenStructure structure;
    Long2ObjectMap<StructureStart> storage;
    Set<Long> toDelete = new LinkedHashSet<Long>();

    public MapGenStructureDataPregen(String name) {
        super(name);
    }

    public MapGenStructureDataPregen(MapGenStructureData structure) {
        super(structure.field_76190_i);
        this.transfer(structure);
    }

    public void setOwner(MapGenStructure base, StructureController control) {
        this.structure = base;
        this.cont = control;
        try {
            this.storage = (Long2ObjectMap)ReflectionHelper.getPrivateValue(MapGenStructure.class, (Object)base, (String[])new String[]{"structureMap", "field_75053_d"});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void transfer(MapGenStructureData data) {
        NBTTagCompound oldCompound = data.func_143041_a();
        NBTTagCompound newCompound = this.func_143041_a();
        for (String key : oldCompound.func_150296_c()) {
            newCompound.func_74782_a(key, oldCompound.func_74781_a(key));
        }
    }

    public void func_143043_a(NBTTagCompound tagCompoundIn, int chunkX, int chunkZ) {
        if (this.isInsideSaveZone(chunkX, chunkZ)) {
            this.deleteStructure(FilePos.asLong(chunkX, chunkZ));
            return;
        }
        super.func_143043_a(tagCompoundIn, chunkX, chunkZ);
    }

    private boolean isInsideSaveZone(int x, int z) {
        return this.cont.isInsideBox(this.field_76190_i, x, z);
    }

    public void markForDeletion(int x, int z) {
        this.toDelete.add(FilePos.asLong(x, z));
    }

    public void deleteStructure(long position) {
        if (this.storage != null) {
            this.storage.remove(position);
        }
        this.func_143041_a().func_82580_o(MapGenStructureDataPregen.func_143042_b((int)FilePos.getX(position), (int)FilePos.getZ(position)));
    }

    public void onSaveZoneCheck() {
        for (StructureStart entry : this.storage.values()) {
            if (!this.isInsideSaveZone(entry.func_143019_e(), entry.func_143018_f())) continue;
            this.markForDeletion(entry.func_143019_e(), entry.func_143018_f());
        }
        this.onDeletion();
    }

    public void onDeletion() {
        this.toDelete.forEach(this::deleteStructure);
        this.toDelete.clear();
    }

    public MapGenStructure getStructure() {
        return this.structure;
    }

    public Collection<StructureStart> getStarts() {
        return this.storage.values();
    }

    public StructureStart getStructure(int x, int z) {
        return (StructureStart)this.storage.get(FilePos.asLong(x, z));
    }

    public Tuple<FilePos, FilePos> deleteStructure(FilePos pos) {
        StructureStart start = (StructureStart)this.storage.remove(pos.asLong());
        if (start == null) {
            return null;
        }
        StructureBoundingBox box = start.func_75071_a();
        int x = (box.field_78897_a >> 4) - 1;
        int z = (box.field_78896_c >> 4) - 1;
        int width = (box.field_78893_d >> 4) + 1 - x;
        int height = (box.field_78892_f >> 4) + 1 - z;
        this.cont.addSaveZone(this.field_76190_i, new SaveZone("Deletion_" + pos.x + "_" + pos.z, x + width / 2, z + height / 2, width, height));
        return new Tuple<FilePos, FilePos>(new FilePos(x, z), new FilePos(x + width, z + height));
    }
}

