/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.structure;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.storage.WorldSavedData;
import pregenerator.impl.misc.SaveZone;

public class SaveZoneData
extends WorldSavedData {
    Map<String, Map<String, SaveZone>> saveZones = new LinkedHashMap<String, Map<String, SaveZone>>();

    public SaveZoneData(String name) {
        super(name);
    }

    public void func_76184_a(NBTTagCompound nbt) {
        this.saveZones.clear();
        NBTTagList list = nbt.func_150295_c("savezones", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound data = list.func_150305_b(i);
            NBTTagList dataList = data.func_150295_c("zones", 10);
            LinkedHashMap<String, SaveZone> zones = new LinkedHashMap<String, SaveZone>();
            for (int x = 0; x < dataList.func_74745_c(); ++x) {
                SaveZone zone = new SaveZone(dataList.func_150305_b(x));
                zones.put(zone.getName(), zone);
            }
            this.saveZones.put(data.func_74779_i("type"), zones);
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound nbt) {
        NBTTagList list = new NBTTagList();
        for (Map.Entry<String, Map<String, SaveZone>> entry : this.saveZones.entrySet()) {
            NBTTagCompound data = new NBTTagCompound();
            data.func_74778_a("type", entry.getKey());
            NBTTagList dataList = new NBTTagList();
            for (SaveZone box : entry.getValue().values()) {
                dataList.func_74742_a((NBTBase)box.write());
            }
            data.func_74782_a("zones", (NBTBase)dataList);
            list.func_74742_a((NBTBase)data);
        }
        nbt.func_74782_a("savezones", (NBTBase)list);
        return nbt;
    }

    public void addSaveZone(String type, SaveZone box) {
        this.saveZones.computeIfAbsent(type, T -> new LinkedHashMap()).put(box.getName(), box);
        this.func_76185_a();
    }

    public boolean contains(String type, String name) {
        if ("All".equalsIgnoreCase(type)) {
            for (Map<String, SaveZone> entry : this.saveZones.values()) {
                if (!entry.containsKey(name)) continue;
                return true;
            }
            return false;
        }
        return this.saveZones.getOrDefault(type, Collections.emptyMap()).containsKey(name);
    }

    public boolean contains(String type, int x, int z) {
        for (SaveZone box : this.saveZones.getOrDefault(type, Collections.emptyMap()).values()) {
            if (!box.isInsideBox(x, z)) continue;
            return true;
        }
        return false;
    }

    public boolean remove(String type, String name) {
        return this.saveZones.getOrDefault(type, Collections.emptyMap()).remove(name) != null;
    }

    public void merge(Map<String, List<SaveZone>> boxes) {
        for (Map.Entry<String, Map<String, SaveZone>> entry : this.saveZones.entrySet()) {
            boxes.computeIfAbsent(entry.getKey(), T -> new ArrayList()).addAll(entry.getValue().values());
        }
    }

    public void clearAll() {
        this.saveZones.clear();
        this.func_76185_a();
    }

    public void clearAll(String type) {
        if (type.equalsIgnoreCase("All")) {
            this.clearAll();
        } else if (this.saveZones.remove(type) != null) {
            this.func_76185_a();
        }
    }
}

