/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.structure;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.structure.MapGenStructure;
import net.minecraft.world.gen.structure.MapGenStructureData;
import net.minecraft.world.gen.structure.StructureStart;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import pregenerator.ChunkPregenerator;
import pregenerator.impl.misc.SaveZone;
import pregenerator.impl.structure.MapGenStructureDataPregen;
import pregenerator.impl.structure.SaveZoneData;
import pregenerator.impl.structure.StructureData;
import pregenerator.impl.structure.StructureManager;

public class StructureController {
    World world;
    Map<String, MapGenStructureDataPregen> pregen = new LinkedHashMap<String, MapGenStructureDataPregen>();
    SaveZoneData data;

    public StructureController(World world) {
        this.world = world;
        this.data = (SaveZoneData)world.getPerWorldStorage().func_75742_a(SaveZoneData.class, "SaveZoneData");
        if (this.data == null) {
            this.data = new SaveZoneData("SaveZoneData");
            world.getPerWorldStorage().func_75745_a("SaveZoneData", (WorldSavedData)this.data);
        }
        this.init();
    }

    public void addSaveZone(String type, SaveZone zone) {
        if (type.equalsIgnoreCase("All")) {
            for (String realType : StructureManager.INSTANCE.getTypes(this.world.field_73011_w.getDimension())) {
                this.data.addSaveZone(realType, zone);
            }
        } else {
            this.data.addSaveZone(type, zone);
        }
        this.onSaveZoneChange();
    }

    private void onSaveZoneChange() {
        this.pregen.values().forEach(MapGenStructureDataPregen::onSaveZoneCheck);
    }

    public void onPopulation() {
        this.pregen.values().forEach(MapGenStructureDataPregen::onDeletion);
    }

    public SaveZoneData getStorage() {
        return this.data;
    }

    public void resetSaveZones() {
        this.data.clearAll();
    }

    public void cleanup() {
        this.pregen.clear();
        this.world = null;
    }

    private void init() {
        if (this.world instanceof WorldServer) {
            WorldServer serverWorld = (WorldServer)this.world;
            for (MapGenStructure entry : this.getStructures(serverWorld.func_72863_F().field_186029_c)) {
                if (entry == null) continue;
                this.applyChanges(entry);
            }
        } else {
            ChunkPregenerator.LOGGER.info("A Client world tried to be read");
        }
    }

    private void applyChanges(MapGenStructure structure) {
        StructureManager.INSTANCE.register(this.world, structure.func_143025_a());
        MapGenStructureData data = (MapGenStructureData)this.world.getPerWorldStorage().func_75742_a(MapGenStructureDataPregen.class, structure.func_143025_a());
        if (data instanceof MapGenStructureDataPregen) {
            ((MapGenStructureDataPregen)data).setOwner(structure, this);
            this.pregen.put(structure.func_143025_a(), (MapGenStructureDataPregen)data);
        } else if (data == null) {
            MapGenStructureDataPregen helper = new MapGenStructureDataPregen(structure.func_143025_a());
            helper.setOwner(structure, this);
            this.world.getPerWorldStorage().func_75745_a(structure.func_143025_a(), (WorldSavedData)helper);
            this.pregen.put(structure.func_143025_a(), helper);
        } else {
            MapGenStructureDataPregen helper = new MapGenStructureDataPregen(data);
            helper.setOwner(structure, this);
            this.world.getPerWorldStorage().func_75745_a(structure.func_143025_a(), (WorldSavedData)helper);
            ReflectionHelper.setPrivateValue(MapGenStructure.class, (Object)structure, (Object)((Object)helper), (String[])new String[]{"structureData", "field_143029_e"});
            this.pregen.put(structure.func_143025_a(), helper);
        }
    }

    private List<MapGenStructure> getStructures(IChunkGenerator generator) {
        ArrayList<MapGenStructure> list = new ArrayList<MapGenStructure>();
        Class<MapGenStructure> structure = MapGenStructure.class;
        try {
            Class<?> clz = generator.getClass();
            Field[] fields = clz.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                Field field = fields[i];
                if (!structure.isAssignableFrom(field.getType())) continue;
                field.setAccessible(true);
                list.add((MapGenStructure)field.get(generator));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public void addStructures(List<StructureData> data, String type) {
        if (type != null) {
            MapGenStructureDataPregen structures = this.pregen.get(type);
            if (structures == null) {
                return;
            }
            for (StructureStart start : structures.getStarts()) {
                data.add(new StructureData(type, start));
            }
            return;
        }
        for (Map.Entry<String, MapGenStructureDataPregen> entry : this.pregen.entrySet()) {
            for (StructureStart start : entry.getValue().getStarts()) {
                data.add(new StructureData(entry.getKey(), start));
            }
        }
    }

    public MapGenStructureDataPregen getStructure(String type) {
        return this.pregen.get(type);
    }

    public List<MapGenStructureDataPregen> getStructures() {
        return new ArrayList<MapGenStructureDataPregen>(this.pregen.values());
    }

    public boolean isInsideBox(String type, int x, int z) {
        return this.data.contains(type, x, z);
    }
}

