/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.structure;

import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.gen.structure.StructureStart;
import pregenerator.base.api.TextUtil;
import pregenerator.impl.misc.Area;
import pregenerator.impl.misc.FilePos;

public class StructureData {
    String type;
    short parts;
    boolean suitable;
    Area area;
    int x;
    int z;

    public StructureData() {
    }

    public StructureData(String id, StructureStart start) {
        this.type = id;
        this.x = start.func_143019_e() * 16;
        this.z = start.func_143018_f() * 16;
        this.suitable = start.func_75069_d();
        this.parts = (short)start.func_186161_c().size();
        this.area = new Area(start.func_75071_a());
    }

    public StructureData(PacketBuffer buffer) {
        this.x = buffer.readInt();
        this.z = buffer.readInt();
        this.parts = buffer.readShort();
        this.suitable = buffer.readBoolean();
        this.area = new Area(buffer);
        this.type = buffer.func_150789_c(Short.MAX_VALUE);
    }

    public int getBytes() {
        return 13 + this.type.length() * 2;
    }

    public void writeToBuffer(PacketBuffer buffer) {
        buffer.writeInt(this.x);
        buffer.writeInt(this.z);
        buffer.writeShort((int)this.parts);
        buffer.writeBoolean(this.suitable);
        this.area.write(buffer);
        buffer.func_180714_a(this.type);
    }

    public String getType() {
        return this.type;
    }

    public short getParts() {
        return this.parts;
    }

    public boolean isSuitable() {
        return this.suitable;
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }

    public FilePos getPos() {
        return new FilePos(this.x, this.z);
    }

    public FilePos getChunkPos() {
        return new FilePos(this.x >> 4, this.z >> 4);
    }

    public Area getArea() {
        return this.area;
    }

    public ITextComponent createStructureMessage(int dim) {
        ITextComponent generates = TextUtil.applyTextStyle(TextUtil.translate(this.suitable ? "commands.chunk_pregen.structure.yes" : "commands.chunk_pregen.structure.no"), this.suitable ? TextFormatting.GREEN : TextFormatting.RED);
        ITextComponent teleport = TextUtil.translate("commands.chunk_pregen.structure.teleport").func_150255_a(this.createStyle("commands.chunk_pregen.structure.teleport.desc", "/tp " + this.x + " ~ " + this.z, TextFormatting.AQUA));
        ITextComponent remove = TextUtil.translate("commands.chunk_pregen.structure.delete").func_150255_a(this.createStyle("commands.chunk_pregen.structure.delete.desc", "/pregen structure delete " + dim + " " + this.type + " " + (this.x >> 4) + " " + (this.z >> 4) + " true", TextFormatting.RED));
        return TextUtil.translate("commands.chunk_pregen.structure.location", this.type, TextUtil.NUMBERS.format(this.x), TextUtil.NUMBERS.format(this.z), generates, teleport, remove);
    }

    private Style createStyle(String desc, String command, TextFormatting color) {
        return new Style().func_150228_d(Boolean.valueOf(true)).func_150238_a(color).func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, command)).func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, TextUtil.translate(desc)));
    }
}

