/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.structure;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureStart;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import pregenerator.impl.misc.FilePos;
import pregenerator.impl.misc.SaveZone;
import pregenerator.impl.structure.MapGenStructureDataPregen;
import pregenerator.impl.structure.StructureController;
import pregenerator.impl.structure.StructureData;

public class StructureManager {
    public static final StructureManager INSTANCE = new StructureManager();
    Map<World, StructureController> controller = new LinkedHashMap<World, StructureController>();
    Map<Integer, Set<String>> types = new HashMap<Integer, Set<String>>();
    List<String> allTypes = null;

    public void init() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void onServerStopped() {
        this.controller.values().forEach(StructureController::cleanup);
        this.controller.clear();
        this.allTypes = null;
    }

    public Set<String> getTypes(int dimension) {
        return this.types.getOrDefault(dimension, Collections.emptySet());
    }

    public Map<String, List<SaveZone>> getBoxes() {
        LinkedHashMap<String, List<SaveZone>> map = new LinkedHashMap<String, List<SaveZone>>();
        for (StructureController entry : this.controller.values()) {
            entry.getStorage().merge(map);
        }
        return map;
    }

    public Map<String, List<SaveZone>> getBoxes(int dimension) {
        StructureController control = this.controller.get(DimensionManager.getWorld((int)dimension));
        LinkedHashMap<String, List<SaveZone>> boxes = new LinkedHashMap<String, List<SaveZone>>();
        if (control != null) {
            control.getStorage().merge(boxes);
        }
        return boxes;
    }

    public List<String> generateAllTypes() {
        if (this.allTypes == null) {
            this.allTypes = new ArrayList<String>();
            this.types.values().forEach(this.allTypes::addAll);
        }
        return this.allTypes;
    }

    public void fetchTypes(int world, Consumer<String> result) {
        this.types.getOrDefault(world, Collections.emptySet()).forEach(result);
    }

    public void fetchDimensions(Consumer<String> result) {
        for (Integer entry : this.types.keySet()) {
            result.accept(entry.toString());
        }
    }

    public List<FilePos> getStructurePositions(int dim, String type) {
        MapGenStructureDataPregen data = this.getStructure(dim, type);
        if (data == null) {
            return Collections.emptyList();
        }
        ArrayList<FilePos> position = new ArrayList<FilePos>();
        for (StructureStart start : data.getStarts()) {
            position.add(new FilePos(start.func_143019_e(), start.func_143018_f()));
        }
        return position;
    }

    public List<StructureData> getStructures(int dim, String type) {
        ArrayList<StructureData> list = new ArrayList<StructureData>();
        StructureController cont = this.controller.get(DimensionManager.getWorld((int)dim));
        if (cont != null) {
            cont.addStructures(list, type);
        }
        return list;
    }

    public boolean validateType(int dim, String type) {
        if (type.equalsIgnoreCase("All")) {
            return true;
        }
        return this.types.getOrDefault(dim, Collections.emptySet()).contains(type);
    }

    public void register(World world, String type) {
        this.types.computeIfAbsent(world.field_73011_w.getDimension(), T -> new LinkedHashSet()).add(type);
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        World world = event.getWorld();
        if (world.field_72995_K) {
            return;
        }
        this.controller.put(world, new StructureController(world));
        this.allTypes = null;
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        StructureController control = this.controller.remove(event.getWorld());
        if (control != null) {
            control.cleanup();
            this.allTypes = null;
        }
    }

    @SubscribeEvent
    public void onPopulation(PopulateChunkEvent.Pre event) {
        StructureController control = this.controller.get(event.getWorld());
        if (control != null) {
            control.onPopulation();
        }
    }

    public void createSaveZone(String type, int dimension, SaveZone zone) {
        StructureController control = this.controller.get(DimensionManager.getWorld((int)dimension));
        if (control != null) {
            control.addSaveZone(type, zone);
        }
    }

    public boolean containsZone(String type, int dimension, String name) {
        StructureController control = this.controller.get(DimensionManager.getWorld((int)dimension));
        return control != null && control.getStorage().contains(type, name);
    }

    public boolean removeZone(String type, int dimension, String name) {
        StructureController control = this.controller.get(DimensionManager.getWorld((int)dimension));
        return control != null && control.getStorage().remove(type, name);
    }

    public void clearAllZones(int dim, String type) {
        StructureController control = this.controller.get(DimensionManager.getWorld((int)dim));
        if (control != null) {
            control.getStorage().clearAll(type);
        }
    }

    public void clearAllZones() {
        this.controller.values().forEach(StructureController::resetSaveZones);
    }

    public MapGenStructureDataPregen getStructure(int dim, String type) {
        StructureController control = this.controller.get(DimensionManager.getWorld((int)dim));
        return control != null ? control.getStructure(type) : null;
    }

    public List<MapGenStructureDataPregen> getStructureHolders(int dim) {
        StructureController control = this.controller.get(DimensionManager.getWorld((int)dim));
        return control != null ? control.getStructures() : Collections.emptyList();
    }
}

