/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.tracking;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.Int2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.RegistryNamespaced;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import pregenerator.impl.misc.FilePos;
import pregenerator.impl.tracking.types.IWorldEntry;
import pregenerator.impl.tracking.types.TileEntry;

public class ChunkEntry {
    public static final RegistryNamespaced<ResourceLocation, Class<? extends TileEntity>> REGISTRY = (RegistryNamespaced)ReflectionHelper.getPrivateValue(TileEntity.class, null, (String[])new String[]{"REGISTRY", "field_190562_f"});
    long pos;
    Int2ObjectMap<List<IWorldEntry>> data;
    int randomTicking;

    public ChunkEntry(long pos, Int2ObjectMap<List<IWorldEntry>> data, int randomTicking) {
        this.pos = pos;
        this.data = data;
        this.randomTicking = randomTicking;
    }

    public int getDistance(BlockPos position) {
        int x = position.func_177958_n() - ((FilePos.getX(this.pos) << 4) + 8);
        int z = position.func_177952_p() - ((FilePos.getZ(this.pos) << 4) + 8);
        return (int)Math.sqrt(x * x + z * z);
    }

    public int getX() {
        return FilePos.getX(this.pos);
    }

    public int getZ() {
        return FilePos.getZ(this.pos);
    }

    public long getPos() {
        return this.pos;
    }

    public <T extends IWorldEntry> List<T> get(int type, Class<T> clz) {
        return Lists.transform((List)((List)this.data.get(type)), clz::cast);
    }

    public int getTypes(int type) {
        return ((List)this.data.get(type)).size();
    }

    public int getTiles() {
        return IWorldEntry.count((List)this.data.get(0));
    }

    public int getTickingTiles() {
        int total = 0;
        for (TileEntry entry : Lists.transform((List)((List)this.data.get(0)), TileEntry.class::cast)) {
            if (!entry.isTicking()) continue;
            total += entry.getCount();
        }
        return total;
    }

    public int getEntities() {
        return IWorldEntry.count((List)this.data.get(1));
    }

    public int getBlocks() {
        return IWorldEntry.count((List)this.data.get(3));
    }

    public int getTickingBlocks() {
        return this.randomTicking;
    }

    public void write(PacketBuffer buffer) {
        buffer.writeLong(this.pos);
        for (int i = 0; i < 4; ++i) {
            List entries = (List)this.data.get(i);
            buffer.func_150787_b(entries.size());
            entries.forEach(T -> T.write(buffer));
        }
        buffer.func_150787_b(this.randomTicking);
    }

    public static ChunkEntry fromNetwork(PacketBuffer buffer) {
        Int2ObjectLinkedOpenHashMap data = new Int2ObjectLinkedOpenHashMap();
        long pos = buffer.readLong();
        for (int i = 0; i < 4; ++i) {
            ObjectArrayList list = new ObjectArrayList();
            Function<PacketBuffer, IWorldEntry> creator = IWorldEntry.byId(i);
            int size = buffer.func_150792_a();
            for (int j = 0; j < size; ++j) {
                list.add(creator.apply(buffer));
            }
            data.put(i, (Object)list);
        }
        return new ChunkEntry(pos, (Int2ObjectMap<List<IWorldEntry>>)data, buffer.func_150792_a());
    }

    public static ChunkEntry fromChunk(Chunk chunk) {
        Int2ObjectLinkedOpenHashMap data = new Int2ObjectLinkedOpenHashMap();
        int randomCount = 0;
        for (int i = 0; i < 4; ++i) {
            data.put(i, IWorldEntry.byChunk(i, chunk));
        }
        for (ExtendedBlockStorage section : chunk.func_76587_i()) {
            if (section == null || section.func_76663_a() || !section.func_76675_b()) continue;
            int value = (Integer)ReflectionHelper.getPrivateValue(ExtendedBlockStorage.class, (Object)section, (String[])new String[]{"tickRefCount", "field_76683_c"});
            randomCount += value;
        }
        return new ChunkEntry(FilePos.asLong(chunk.func_76632_l().field_77276_a, chunk.func_76632_l().field_77275_b), (Int2ObjectMap<List<IWorldEntry>>)data, randomCount);
    }
}

