/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.tracking;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldEventListener;
import net.minecraft.world.NextTickListEntry;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import pregenerator.impl.misc.FilePos;
import pregenerator.impl.tracking.AverageCounter;
import pregenerator.impl.tracking.TimeTracker;
import pregenerator.impl.tracking.WorldListener;

public class WorldTracker {
    public WorldServer world;
    AverageCounter blockUpdates = new AverageCounter(40);
    AverageCounter blockTicks = new AverageCounter(40);
    TimeTracker tracker = new TimeTracker(40);
    public Set<NextTickListEntry> tickUpdates;
    WorldListener listener;

    public WorldTracker(WorldServer world, boolean baseTracking) {
        this.world = world;
        this.listener = new WorldListener(this);
        if (baseTracking) {
            world.func_72954_a((IWorldEventListener)this.listener);
        }
        try {
            this.tickUpdates = (Set)ReflectionHelper.getPrivateValue(WorldServer.class, (Object)world, (String[])new String[]{"field_73064_N", "pendingTickListEntriesHashSet"});
        }
        catch (Exception e) {
            this.tickUpdates = new LinkedHashSet<NextTickListEntry>();
            e.printStackTrace();
        }
    }

    public void setState(boolean tracking) {
        this.world.func_72848_b((IWorldEventListener)this.listener);
        if (tracking) {
            this.world.func_72954_a((IWorldEventListener)this.listener);
        }
    }

    public void onBlockUpdate(BlockPos pos) {
        this.blockUpdates.addOne();
    }

    public void onTickStart() {
        this.tracker.setStart();
        this.blockTicks.addMore(this.tickUpdates.size());
        this.blockTicks.onFinished();
    }

    public void onTickEnd() {
        this.blockUpdates.onFinished();
        this.tracker.onFinished();
    }

    public void writeTrackingData(PacketBuffer buffer) {
        buffer.writeInt(this.world.field_73011_w.getDimension());
        buffer.func_179254_b(this.tracker.getAverage());
        buffer.func_179254_b(this.tracker.getLastValue());
        buffer.func_150787_b(this.world.func_72863_F().func_73152_e());
        buffer.func_150787_b(this.world.field_147482_g.size());
        buffer.func_150787_b(this.world.field_175730_i.size());
        buffer.func_150787_b(this.world.field_72996_f.size());
        buffer.func_150787_b(this.blockUpdates.getLast());
        buffer.func_150787_b(this.blockUpdates.getAverage());
        buffer.func_150787_b(this.blockTicks.getLast());
        buffer.func_150787_b(this.blockTicks.getAverage());
    }

    public int getAverageBlockChanges() {
        return this.blockUpdates.getAverage();
    }

    public int getBlockChanges() {
        return this.blockUpdates.getLast();
    }

    public int getAverageBlockTicks() {
        return this.blockTicks.getAverage();
    }

    public int getBlockTicks() {
        return this.blockTicks.getLast();
    }

    public int getLoadedChunks() {
        return this.world.func_72863_F().func_73152_e();
    }

    public int getLoadedEntities() {
        return this.world.field_72996_f.size();
    }

    public int getLoadedTileEntities() {
        return this.world.field_147482_g.size();
    }

    public int getTickingTileEntities() {
        return this.world.field_175730_i.size();
    }

    public int getDimID() {
        return this.world.field_73011_w.getDimension();
    }

    public long getAverage() {
        return this.tracker.getAverage();
    }

    public long getCurrent() {
        return this.tracker.getLastValue();
    }

    public List<Chunk> getChunks() {
        return new ArrayList<Chunk>(this.getProvider().func_189548_a());
    }

    public Chunk getChunk(long position) {
        return this.getProvider().func_186026_b(FilePos.getX(position), FilePos.getZ(position));
    }

    private ChunkProviderServer getProvider() {
        return this.world.func_72863_F();
    }

    public List<Entity> getEntityList() {
        return new ArrayList<Entity>(this.world.field_72996_f);
    }

    public List<TileEntity> getTileList() {
        return new ArrayList<TileEntity>(this.world.field_147482_g);
    }
}

