/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.tracking.types;

import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import pregenerator.base.api.TextUtil;
import pregenerator.impl.tracking.types.IWorldEntry;

public abstract class BaseWorldEntry
implements IWorldEntry {
    int id;
    int count;

    public BaseWorldEntry(int id, int count) {
        this.id = id;
        this.count = count;
    }

    public BaseWorldEntry(PacketBuffer buf) {
        this.id = buf.func_150792_a();
        this.count = buf.func_150792_a();
    }

    @Override
    public ResourceLocation getKey() {
        return this.getKey(this.id);
    }

    protected abstract ResourceLocation getKey(int var1);

    @Override
    public ITextComponent getName() {
        return TextUtil.literalPascal(this.getKey(this.id).func_110623_a());
    }

    @Override
    public int getCount() {
        return this.count;
    }

    @Override
    public void write(PacketBuffer buffer) {
        buffer.func_150787_b(this.id);
        buffer.func_150787_b(this.count);
    }

    protected static <T extends IForgeRegistryEntry<T>> int getId(IForgeRegistry<T> iregistry, T value) {
        ForgeRegistry registry = (ForgeRegistry)iregistry;
        return registry.getID(value);
    }

    public static class Counter<T> {
        Object2IntLinkedOpenHashMap<T> counter = new Object2IntLinkedOpenHashMap();

        public void add(T key, int amount) {
            this.counter.addTo(key, amount);
        }

        public void add(T key) {
            this.counter.addTo(key, 1);
        }

        public void remove(Predicate<T> remove) {
            this.counter.keySet().removeIf(remove);
        }

        public <E> List<E> map(Mapper<T, E> function) {
            ObjectArrayList result = new ObjectArrayList();
            for (Object2IntMap.Entry entry : this.counter.object2IntEntrySet()) {
                result.add(function.map(entry.getKey(), entry.getIntValue()));
            }
            return result;
        }

        public void merge(Counter<T> other) {
            for (Object2IntMap.Entry entry : other.counter.object2IntEntrySet()) {
                this.counter.addTo(entry.getKey(), entry.getIntValue());
            }
        }

        public static interface Mapper<T, E> {
            public E map(T var1, int var2);
        }
    }
}

