/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.tracking.types;

import java.util.List;
import java.util.function.Function;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import pregenerator.impl.tracking.WorldTracker;
import pregenerator.impl.tracking.types.BiomeEntry;
import pregenerator.impl.tracking.types.BlockEntry;
import pregenerator.impl.tracking.types.EntityTypeEntry;
import pregenerator.impl.tracking.types.TileEntry;

public interface IWorldEntry {
    public ITextComponent getName();

    public ResourceLocation getKey();

    public int getCount();

    public void write(PacketBuffer var1);

    public boolean canDelete(boolean var1);

    public int deleteWorld(WorldTracker var1, EntityPlayer var2);

    public int deleteChunk(WorldTracker var1, long var2);

    public static int count(List<IWorldEntry> list) {
        int result = 0;
        int m = list.size();
        for (int i = 0; i < m; ++i) {
            result += list.get(i).getCount();
        }
        return result;
    }

    public static Function<PacketBuffer, IWorldEntry> byId(int id) {
        switch (id) {
            case 0: {
                return TileEntry::new;
            }
            case 1: {
                return EntityTypeEntry::new;
            }
            case 2: {
                return BiomeEntry::new;
            }
            case 3: {
                return BlockEntry::new;
            }
        }
        throw new IllegalStateException("Unknown Type!");
    }

    public static List<IWorldEntry> byChunk(int id, Chunk chunk) {
        switch (id) {
            case 0: {
                return TileEntry.getChunk(chunk);
            }
            case 1: {
                return EntityTypeEntry.getChunk(chunk);
            }
            case 2: {
                return BiomeEntry.getChunk(chunk);
            }
            case 3: {
                return BlockEntry.getChunk(chunk);
            }
        }
        throw new IllegalStateException("Unsupported Type");
    }

    public static List<IWorldEntry> byLevel(int id, WorldServer level) {
        switch (id) {
            case 0: {
                return TileEntry.getLevel(level);
            }
            case 1: {
                return EntityTypeEntry.getLevel(level);
            }
            case 3: {
                return BlockEntry.getLevel(level);
            }
        }
        throw new IllegalStateException("Unsupported Type");
    }
}

