/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.tracking.types;

import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import pregenerator.base.api.TextUtil;
import pregenerator.impl.tracking.ChunkEntry;
import pregenerator.impl.tracking.ServerTracker;
import pregenerator.impl.tracking.WorldTracker;
import pregenerator.impl.tracking.types.BaseWorldEntry;
import pregenerator.impl.tracking.types.IWorldEntry;

public class TileEntry
extends BaseWorldEntry {
    ResourceLocation id;
    int blockId;
    boolean isTicking;

    public TileEntry(Class<? extends TileEntity> type, int count, Block block, boolean isTicking) {
        this((ResourceLocation)ChunkEntry.REGISTRY.func_177774_c(type), count, TileEntry.getId(ForgeRegistries.BLOCKS, block), isTicking);
    }

    public TileEntry(ResourceLocation id, int count, int blockId, boolean isTicking) {
        super(-1, count);
        this.id = id;
        this.blockId = blockId;
        this.isTicking = isTicking;
    }

    public TileEntry(PacketBuffer buffer) {
        super(buffer);
        this.id = buffer.func_192575_l();
        this.blockId = buffer.func_150792_a();
        this.isTicking = buffer.readBoolean();
    }

    public boolean isTicking() {
        return this.isTicking;
    }

    public Block getType() {
        return (Block)((ForgeRegistry)ForgeRegistries.BLOCKS).getValue(this.blockId);
    }

    @Override
    protected ResourceLocation getKey(int id) {
        return this.id;
    }

    @Override
    public ITextComponent getName() {
        return TextUtil.translate(this.getType().func_149732_F());
    }

    @Override
    public void write(PacketBuffer buffer) {
        super.write(buffer);
        buffer.func_192572_a(this.id);
        buffer.func_150787_b(this.blockId);
        buffer.writeBoolean(this.isTicking);
    }

    @Override
    public boolean canDelete(boolean chunk) {
        return true;
    }

    @Override
    public int deleteWorld(WorldTracker tracker, EntityPlayer player) {
        Class type = (Class)ChunkEntry.REGISTRY.func_82594_a((Object)this.id);
        if (type == null) {
            return 0;
        }
        ObjectArrayList entities = new ObjectArrayList(this.count);
        for (TileEntity tile : tracker.world.field_147482_g) {
            if (tile.getClass() != type) continue;
            entities.add(tile);
        }
        entities.forEach(T -> tracker.world.func_175698_g(T.func_174877_v()));
        return entities.size();
    }

    @Override
    public int deleteChunk(WorldTracker tracker, long position) {
        Chunk chunk = tracker.getChunk(position);
        if (chunk == null) {
            return 0;
        }
        Class type = (Class)ChunkEntry.REGISTRY.func_82594_a((Object)this.id);
        if (type == null) {
            return 0;
        }
        ArrayList entities = new ArrayList(chunk.func_177434_r().values());
        entities.removeIf(T -> T.getClass() != type);
        entities.forEach(T -> tracker.world.func_175698_g(T.func_174877_v()));
        return entities.size();
    }

    public static List<IWorldEntry> getLevel(WorldServer level) {
        Object2ObjectLinkedOpenHashMap typeMap = new Object2ObjectLinkedOpenHashMap();
        ObjectOpenHashSet ticking = new ObjectOpenHashSet();
        BaseWorldEntry.Counter<Class> counter = new BaseWorldEntry.Counter<Class>();
        TileEntry.getBlockEntities(level, (arg_0, arg_1) -> TileEntry.lambda$getLevel$3((Map)typeMap, counter, (Set)ticking, arg_0, arg_1));
        return counter.map((arg_0, arg_1) -> TileEntry.lambda$getLevel$4((Map)typeMap, (Set)ticking, arg_0, arg_1));
    }

    public static List<IWorldEntry> getChunk(Chunk chunk) {
        Object2ObjectLinkedOpenHashMap typeMap = new Object2ObjectLinkedOpenHashMap();
        ObjectOpenHashSet ticking = new ObjectOpenHashSet();
        BaseWorldEntry.Counter<Class> counter = new BaseWorldEntry.Counter<Class>();
        for (TileEntity entity : chunk.func_177434_r().values()) {
            typeMap.putIfAbsent(entity.getClass(), chunk.func_177435_g(entity.func_174877_v()).func_177230_c());
            counter.add(entity.getClass());
            if (!(entity instanceof ITickable)) continue;
            ticking.add(entity.getClass());
        }
        return counter.map((arg_0, arg_1) -> TileEntry.lambda$getChunk$5((Map)typeMap, (Set)ticking, arg_0, arg_1));
    }

    public static void getBlockEntities(WorldServer level, BiConsumer<Chunk, TileEntity> result) {
        for (Chunk chunk : ServerTracker.INSTANCE.getWorld(level.field_73011_w.getDimension()).getChunks()) {
            chunk.func_177434_r().values().forEach(T -> result.accept(chunk, (TileEntity)T));
        }
    }

    private static /* synthetic */ IWorldEntry lambda$getChunk$5(Map typeMap, Set ticking, Class T, int C) {
        return new TileEntry(T, C, (Block)typeMap.get(T), ticking.contains(T));
    }

    private static /* synthetic */ IWorldEntry lambda$getLevel$4(Map typeMap, Set ticking, Class T, int C) {
        return new TileEntry(T, C, (Block)typeMap.get(T), ticking.contains(T));
    }

    private static /* synthetic */ void lambda$getLevel$3(Map typeMap, BaseWorldEntry.Counter counter, Set ticking, Chunk C, TileEntity T) {
        typeMap.putIfAbsent(T.getClass(), C.func_177435_g(T.func_174877_v()).func_177230_c());
        counter.add(T.getClass());
        if (T instanceof ITickable) {
            ticking.add(T.getClass());
        }
    }
}

