/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.mc1120.events.handling;

import crafttweaker.api.entity.IEntity;
import crafttweaker.api.event.ExplosionDetonateEvent;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.api.world.IBlockPos;
import crafttweaker.mc1120.events.handling.MCExplosionEvent;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraftforge.event.world.ExplosionEvent;

public class MCExplosionDetonateEvent
extends MCExplosionEvent
implements ExplosionDetonateEvent {
    private ExplosionEvent.Detonate event;
    private List<IEntity> entities = null;
    private List<IBlockPos> blocks = null;

    public MCExplosionDetonateEvent(ExplosionEvent.Detonate event) {
        super((ExplosionEvent)event);
        this.event = event;
    }

    @Override
    public List<IEntity> getAffectedEntities() {
        if (this.entities == null) {
            this.entities = this.event.getAffectedEntities().stream().map(CraftTweakerMC::getIEntity).collect(Collectors.toList());
        }
        return this.entities;
    }

    @Override
    public List<IBlockPos> getAffectedPositions() {
        if (this.blocks == null) {
            this.blocks = this.event.getAffectedBlocks().stream().map(CraftTweakerMC::getIBlockPos).collect(Collectors.toList());
        }
        return this.blocks;
    }

    @Override
    public void setAffectedEntities(List<IEntity> entities) {
        this.event.getAffectedEntities().clear();
        entities.stream().map(CraftTweakerMC::getEntity).forEach(this.event.getAffectedEntities()::add);
    }

    @Override
    public void setAffectedPositions(List<IBlockPos> positions) {
        this.event.getAffectedBlocks().clear();
        positions.stream().map(CraftTweakerMC::getBlockPos).forEach(this.event.getAffectedBlocks()::add);
    }
}

