/*
 * Decompiled with CFR 0.152.
 */
package chylex.customwindowtitle.forge;

import chylex.customwindowtitle.TitleParser;
import chylex.customwindowtitle.forge.TokenData;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import org.apache.commons.lang3.StringUtils;
import org.lwjgl.opengl.Display;

@Mod(modid="customwindowtitle", useMetadata=true, clientSideOnly=true, acceptedMinecraftVersions="*", acceptableRemoteVersions="*")
public class CustomWindowTitle {
    private static final String defaultTitle = "Minecraft {mcversion}";
    private String configTitle;

    @Mod.EventHandler
    public void onPreInit(FMLPreInitializationEvent e) {
        Path configFile = Paths.get(e.getModConfigurationDirectory().getAbsolutePath(), "customwindowtitle-client.toml");
        try {
            String prefix = "title = ";
            if (!Files.exists(configFile, new LinkOption[0])) {
                Files.write(configFile, Collections.singletonList(prefix + '\"' + defaultTitle + '\"'), StandardCharsets.UTF_8, new OpenOption[0]);
                this.configTitle = defaultTitle;
            } else {
                this.configTitle = Files.readAllLines(configFile, StandardCharsets.UTF_8).stream().filter(line -> line.startsWith(prefix)).map(line -> StringUtils.strip((String)StringUtils.removeStart((String)line, (String)prefix).trim(), (String)"\"")).findFirst().orElse(defaultTitle);
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("CustomWindowTitle configuration error", ex);
        }
        TokenData.register();
        this.updateTitle();
    }

    private void updateTitle() {
        Display.setTitle((String)TitleParser.parse(this.configTitle));
    }
}

