/*
 * Decompiled with CFR 0.152.
 */
package com.mia.props.common.entities;

import com.mia.craftstudio.minecraft.CraftStudioRendererVBO;
import com.mia.craftstudio.minecraft.DirectionHelper;
import com.mia.craftstudio.minecraft.INodeProvider;
import com.mia.craftstudio.minecraft.ImmutableDirectionHolder;
import com.mia.props.common.TileProps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileVariableRendering
extends TileProps
implements INodeProvider {
    private static String RULE_HEADER = "varrend_rule_";
    private List<Rule> rules = new ArrayList<Rule>();
    private Rule defaultRule;
    private Rule baseRule;
    private String statusHash;
    private final int[] rotations = new int[]{2, 1, 0, 3};

    private Map<ImmutableDirectionHolder, TileProps> getSurroundingProps() {
        HashMap<ImmutableDirectionHolder, TileProps> outMap = new HashMap<ImmutableDirectionHolder, TileProps>();
        for (ImmutableDirectionHolder fd : DirectionHelper.directions) {
            int[] offset = fd.getOffset();
            TileEntity te = this.field_145850_b.func_175625_s(new BlockPos(this.func_174877_v().func_177958_n() + offset[0], this.func_174877_v().func_177956_o() + offset[1], this.func_174877_v().func_177952_p() + offset[2]));
            if (!this.sameID(te)) continue;
            String key = "";
            for (EnumFacing enumFacing : fd.getDirections()) {
                key = key + this.correctOrientation(enumFacing).toString().substring(0, 1);
            }
            outMap.put(DirectionHelper.getDirection((String)key), (TileProps)te);
        }
        return outMap;
    }

    public String getParam(String key) {
        return (String)this.getModelData().tileParams.get(key);
    }

    public String getStatusHash() {
        if (this.field_145850_b == null) {
            return null;
        }
        if (this.statusHash == null) {
            Map<ImmutableDirectionHolder, TileProps> props = this.getSurroundingProps();
            this.statusHash = String.format("%d:", this.rotation);
            for (ImmutableDirectionHolder dirs : props.keySet()) {
                this.statusHash = this.statusHash + dirs.hashCode() + ",";
            }
        }
        return this.statusHash;
    }

    private EnumFacing correctOrientation(EnumFacing fdi) {
        EnumFacing fdo = fdi;
        for (int i = 0; i < this.rotations[this.rotation / 4]; ++i) {
            fdo = fdo.func_176732_a(EnumFacing.DOWN.func_176740_k());
        }
        return fdo;
    }

    private void markSurroundingDirty() {
        if (this.field_145850_b == null) {
            return;
        }
        for (TileProps tile : this.getSurroundingProps().values()) {
            if (tile == null) continue;
            tile.markRenderDirty();
        }
    }

    @Override
    public void markRenderDirty() {
        this.statusHash = null;
        super.markRenderDirty();
    }

    @Override
    public void func_145843_s() {
        this.markSurroundingDirty();
        super.func_145843_s();
    }

    @Override
    public void init() {
        super.init();
        if (!this.initialized) {
            Map tileParams = this.getModelData().tileParams;
            for (Map.Entry entry : tileParams.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                if (!key.toLowerCase().startsWith(RULE_HEADER)) continue;
                Rule rule = new Rule(key, value, tileParams);
                if (rule.isDefault()) {
                    this.defaultRule = rule;
                    continue;
                }
                if (rule.isBase()) {
                    this.baseRule = rule;
                    continue;
                }
                this.rules.add(rule);
            }
            if (this.field_145850_b != null) {
                this.markSurroundingDirty();
            }
            this.initialized = true;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public Set<CraftStudioRendererVBO> getNodes(Set<CraftStudioRendererVBO> inNodes) {
        HashSet<CraftStudioRendererVBO> outNodes = new HashSet<CraftStudioRendererVBO>();
        Map<ImmutableDirectionHolder, TileProps> surroundingProps = this.getSurroundingProps();
        if (this.baseRule != null) {
            this.applyPositiveRule(inNodes, outNodes, this.baseRule);
            this.applyNegativeRule(outNodes, this.baseRule);
        }
        boolean ruleMatched = false;
        for (Rule rule : this.rules) {
            if (!rule.checkRule(surroundingProps.keySet())) continue;
            ruleMatched = true;
            this.applyPositiveRule(inNodes, outNodes, rule);
            this.applyNegativeRule(outNodes, rule);
        }
        if (!ruleMatched && this.defaultRule != null) {
            this.applyPositiveRule(inNodes, outNodes, this.defaultRule);
            this.applyNegativeRule(outNodes, this.defaultRule);
        }
        return outNodes;
    }

    private void applyPositiveRule(Set<CraftStudioRendererVBO> inNodes, Set<CraftStudioRendererVBO> outNodes, Rule rule) {
        for (CraftStudioRendererVBO node : inNodes) {
            String name = node.getNode().getFullName();
            for (Pattern p : rule.getPatternsPos()) {
                if (!p.matcher(name).matches()) continue;
                outNodes.add(node);
            }
        }
    }

    private void applyNegativeRule(Set<CraftStudioRendererVBO> outNodes, Rule rule) {
        Iterator<CraftStudioRendererVBO> iterator = outNodes.iterator();
        while (iterator.hasNext()) {
            String name = iterator.next().getNode().getFullName();
            for (Pattern p : rule.getPatternsNeg()) {
                if (!p.matcher(name).matches()) continue;
                iterator.remove();
            }
        }
    }

    private class Rule {
        final String key;
        final String value;
        final int type;
        final List<Pattern> patternsPos = new ArrayList<Pattern>();
        final List<Pattern> patternsNeg = new ArrayList<Pattern>();
        final Set<ImmutableDirectionHolder> directionsEmpty = new HashSet<ImmutableDirectionHolder>();
        final Set<ImmutableDirectionHolder> directionsFilled = new HashSet<ImmutableDirectionHolder>();
        static final int IS_DEFAULT = 1;
        static final int IS_BASE = 2;
        static final int IS_STANDARD = 4;

        private Rule(String key, String value, Map<String, String> params) {
            this.key = key;
            this.value = value;
            this.type = this.parseKey();
            this.parseValue(params);
        }

        private int parseKey() {
            String[] keys;
            for (String k : keys = this.key.toLowerCase().replace(RULE_HEADER, "").split("_")) {
                if (k.equals("default")) {
                    return 1;
                }
                if (k.equals("base")) {
                    return 2;
                }
                if (k.equals("none")) {
                    this.directionsEmpty.addAll(DirectionHelper.getAllDirections());
                    continue;
                }
                if (!k.startsWith("!")) {
                    this.directionsFilled.add(DirectionHelper.getDirection((String)k));
                    continue;
                }
                this.directionsEmpty.add(DirectionHelper.getDirection((String)k.substring(1)));
            }
            return 4;
        }

        private void parseValue(Map<String, String> params) {
            String processedValue = this.value;
            boolean modified = true;
            while (modified) {
                modified = false;
                for (String s : processedValue.split(";")) {
                    if (!s.startsWith("$")) continue;
                    processedValue = processedValue.replace(s, params.get(s.substring(1)));
                    modified = true;
                }
            }
            for (String s : processedValue.split(";")) {
                String pattern = s.replace(".", "\\.").replace("*", ".*").replace("?", ".");
                if (!pattern.startsWith("!")) {
                    this.patternsPos.add(Pattern.compile(pattern));
                    continue;
                }
                this.patternsNeg.add(Pattern.compile(pattern.substring(1)));
            }
        }

        public boolean checkRule(Set<ImmutableDirectionHolder> filledDirections) {
            for (ImmutableDirectionHolder direction : this.directionsFilled) {
                if (filledDirections.contains(direction)) continue;
                return false;
            }
            for (ImmutableDirectionHolder direction : this.directionsEmpty) {
                if (!filledDirections.contains(direction)) continue;
                return false;
            }
            return true;
        }

        public List<Pattern> getPatternsPos() {
            return this.patternsPos;
        }

        public List<Pattern> getPatternsNeg() {
            return this.patternsNeg;
        }

        public String getKey() {
            return this.key;
        }

        public boolean isDefault() {
            return this.type == 1;
        }

        public boolean isBase() {
            return this.type == 2;
        }

        public void prettyPrint() {
            System.out.println("Filled : " + this.directionsFilled);
            System.out.println("Empty  : " + this.directionsEmpty);
            System.out.println("\tAdd    : " + this.patternsPos);
            System.out.println("\tRemove : " + this.patternsNeg);
        }
    }
}

