/*
 * Decompiled with CFR 0.152.
 */
package net.foxmcloud.draconicadditions.items.armor;

import com.brandon3055.brandonscore.utils.ItemNBTHelper;
import com.brandon3055.draconicevolution.DEConfig;
import com.brandon3055.draconicevolution.DEFeatures;
import com.brandon3055.draconicevolution.api.itemconfig.ItemConfigFieldRegistry;
import com.brandon3055.draconicevolution.items.armor.WyvernArmor;
import java.util.List;
import javax.annotation.Nullable;
import net.foxmcloud.draconicadditions.client.model.ModelPotatoArmor;
import net.foxmcloud.draconicadditions.items.armor.ArmorStats;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PotatoArmor
extends WyvernArmor {
    private static ItemArmor.ArmorMaterial potatoMaterial = EnumHelper.addArmorMaterial((String)"potatoArmor", (String)"draconicadditions:potato_armor", (int)-1, (int[])new int[]{1, 1, 2, 1}, (int)0, (SoundEvent)SoundEvents.field_187728_s, (float)0.0f);
    @SideOnly(value=Side.CLIENT)
    public ModelBiped model;

    public PotatoArmor(int renderIndexIn, EntityEquipmentSlot equipmentSlotIn) {
        super(potatoMaterial, renderIndexIn, equipmentSlotIn);
    }

    public PotatoArmor(ItemArmor.ArmorMaterial materialIn, int renderIndexIn, EntityEquipmentSlot equipmentSlotIn) {
        super(materialIn, renderIndexIn, equipmentSlotIn);
    }

    public int getMaxUpgradeLevel(ItemStack stack, String upgrade) {
        return ArmorStats.POTATO_UPGRADE_LEVEL;
    }

    public ItemConfigFieldRegistry getFields(ItemStack stack, ItemConfigFieldRegistry registry) {
        return registry;
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, EntityEquipmentSlot armorSlot, ModelBiped _default) {
        if (DEConfig.disable3DModels) {
            return super.getArmorModel(entityLiving, itemStack, armorSlot, _default);
        }
        if (this.model == null) {
            this.model = this.field_77881_a == EntityEquipmentSlot.HEAD ? new ModelPotatoArmor(0.5f, true, false, false, false) : (this.field_77881_a == EntityEquipmentSlot.CHEST ? new ModelPotatoArmor(1.5f, false, true, false, false) : (this.field_77881_a == EntityEquipmentSlot.LEGS ? new ModelPotatoArmor(1.5f, false, false, true, false) : new ModelPotatoArmor(1.0f, false, false, false, true)));
            this.model.field_78116_c.field_78806_j = this.field_77881_a == EntityEquipmentSlot.HEAD;
            this.model.field_178720_f.field_78806_j = this.field_77881_a == EntityEquipmentSlot.HEAD;
            this.model.field_78115_e.field_78806_j = this.field_77881_a == EntityEquipmentSlot.CHEST || this.field_77881_a == EntityEquipmentSlot.LEGS;
            this.model.field_178724_i.field_78806_j = this.field_77881_a == EntityEquipmentSlot.CHEST;
            this.model.field_178723_h.field_78806_j = this.field_77881_a == EntityEquipmentSlot.CHEST;
            this.model.field_178722_k.field_78806_j = this.field_77881_a == EntityEquipmentSlot.LEGS || this.field_77881_a == EntityEquipmentSlot.FEET;
            boolean bl = this.model.field_178721_j.field_78806_j = this.field_77881_a == EntityEquipmentSlot.LEGS || this.field_77881_a == EntityEquipmentSlot.FEET;
        }
        if (entityLiving == null) {
            return this.model;
        }
        this.model.field_78117_n = entityLiving.func_70093_af();
        this.model.field_78093_q = entityLiving.func_184218_aH();
        this.model.field_78091_s = entityLiving.func_70631_g_();
        this.model.field_178720_f.field_78806_j = this.field_77881_a == EntityEquipmentSlot.HEAD;
        this.model.field_78115_e.field_78806_j = this.field_77881_a == EntityEquipmentSlot.CHEST || this.field_77881_a == EntityEquipmentSlot.LEGS;
        this.model.field_178724_i.field_78806_j = this.field_77881_a == EntityEquipmentSlot.CHEST;
        this.model.field_178723_h.field_78806_j = this.field_77881_a == EntityEquipmentSlot.CHEST;
        this.model.field_178722_k.field_78806_j = this.field_77881_a == EntityEquipmentSlot.LEGS || this.field_77881_a == EntityEquipmentSlot.FEET;
        this.model.field_178721_j.field_78806_j = this.field_77881_a == EntityEquipmentSlot.LEGS || this.field_77881_a == EntityEquipmentSlot.FEET;
        return this.model;
    }

    public float getProtectionPoints(ItemStack stack) {
        float points = (float)ArmorStats.POTATO_BASE_SHIELD_CAPACITY * this.getProtectionShare();
        return points;
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
        PotatoArmor armor;
        if (!stack.func_190926_b() && ArmorStats.POTATO_BREAK_ON_EXHAUST && (armor = (PotatoArmor)stack.func_77973_b()).getEnergyStored(stack) < 1000 && ItemNBTHelper.getFloat((ItemStack)stack, (String)"ProtectionPoints", (float)0.0f) == 0.0f) {
            ItemStack draconiumDust = new ItemStack(DEFeatures.draconiumDust);
            ItemStack diamond = new ItemStack(Items.field_151045_i);
            if (DEConfig.hardMode) {
                draconiumDust.func_190920_e(36 + (int)Math.round(Math.random() * 28.0));
                diamond.func_190920_e(9 + (int)Math.round(Math.random() * 9.0));
            } else {
                draconiumDust.func_190920_e(4 + (int)Math.round(Math.random() * 3.0));
                diamond.func_190920_e(1 + (int)Math.round(Math.random()));
            }
            if (ArmorStats.POTATO_DROP_ON_EXHAUST) {
                player.func_191521_c(draconiumDust);
                player.func_191521_c(diamond);
            }
            player.field_71071_by.func_184437_d(stack);
            player.func_146105_b((ITextComponent)new TextComponentTranslation("msg.da.energizedBreak", new Object[0]), true);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World playerIn, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add(I18n.func_135052_a((String)"item.draconicadditions:potato.lore", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"item.draconicadditions:potato.lore2", (Object[])new Object[0]));
    }

    public float getRecoveryRate(ItemStack stack) {
        return (float)ArmorStats.POTATO_SHIELD_RECOVERY;
    }

    public boolean hasHillStep(ItemStack stack, EntityPlayer player) {
        return false;
    }

    public float getFireResistance(ItemStack stack) {
        return 0.0f;
    }

    public boolean[] hasFlight(ItemStack stack) {
        return new boolean[]{false, false, false};
    }

    public float getFlightSpeedModifier(ItemStack stack, EntityPlayer player) {
        return 0.0f;
    }

    public float getFlightVModifier(ItemStack stack, EntityPlayer player) {
        return 0.0f;
    }

    public int getEnergyPerProtectionPoint() {
        return ArmorStats.POTATO_SHIELD_RECHARGE_COST;
    }

    protected int getCapacity(ItemStack stack) {
        return ArmorStats.POTATO_BASE_CAPACITY;
    }

    protected int getMaxReceive(ItemStack stack) {
        return ArmorStats.POTATO_MAX_RECIEVE;
    }
}

