/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.items.tools;

import com.brandon3055.brandonscore.lib.PairKV;
import com.brandon3055.brandonscore.registry.Feature;
import com.brandon3055.draconicevolution.api.IReaperItem;
import com.brandon3055.draconicevolution.api.itemconfig.DoubleConfigField;
import com.brandon3055.draconicevolution.api.itemconfig.IItemConfigField;
import com.brandon3055.draconicevolution.api.itemconfig.ItemConfigFieldRegistry;
import com.brandon3055.draconicevolution.api.itemconfig.ToolConfigHelper;
import com.brandon3055.draconicevolution.api.itemupgrade.UpgradeHelper;
import com.brandon3055.draconicevolution.client.model.tool.ToolOverrideList;
import com.brandon3055.draconicevolution.client.model.tool.ToolTransforms;
import com.brandon3055.draconicevolution.items.tools.IAOEWeapon;
import com.brandon3055.draconicevolution.items.tools.ToolBase;
import com.brandon3055.draconicevolution.items.tools.ToolStats;
import com.brandon3055.draconicevolution.utils.DETextures;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketBlockChange;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WyvernSword
extends ToolBase
implements IAOEWeapon,
IReaperItem {
    @Override
    public double getBaseAttackSpeedConfig() {
        return ToolStats.WYV_SWORD_ATTACK_SPEED;
    }

    @Override
    public double getBaseAttackDamageConfig() {
        return ToolStats.WYV_SWORD_ATTACK_DAMAGE;
    }

    @Override
    public void loadEnergyStats() {
        this.setEnergyStats(ToolStats.WYVERN_BASE_CAPACITY, 512000, 0);
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        return this.canHarvestBlock(state, stack) ? 25.0f : 1.0f;
    }

    public boolean canHarvestBlock(IBlockState state, ItemStack stack) {
        Material mat = state.func_185904_a();
        return mat.func_76222_j() || mat == Material.field_151569_G || mat == Material.field_151580_n || mat == Material.field_151593_r || mat == Material.field_151584_j || mat == Material.field_151585_k;
    }

    @Override
    public List<String> getValidUpgrades(ItemStack stack) {
        List<String> list = super.getValidUpgrades(stack);
        list.add("attackDmg");
        list.add("attackAOE");
        return list;
    }

    @Override
    public int getMaxUpgradeLevel(ItemStack stack, String upgrade) {
        return 2;
    }

    @Override
    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (this.getDisabledEnchants(stack).containsKey(enchantment)) {
            return false;
        }
        return enchantment.field_77351_y == EnumEnchantmentType.WEAPON || enchantment.field_77351_y == EnumEnchantmentType.ALL;
    }

    @Override
    public int getToolTier(ItemStack stack) {
        return 0;
    }

    public boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, EntityPlayer player) {
        boolean cancel;
        boolean bl = cancel = super.onBlockStartBreak(itemstack, pos, player) || player.field_71075_bZ.field_75098_d;
        if (cancel && player instanceof EntityPlayerMP) {
            ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new SPacketBlockChange(player.field_70170_p, pos));
        }
        return cancel;
    }

    @Override
    public ItemConfigFieldRegistry getFields(ItemStack stack, ItemConfigFieldRegistry registry) {
        registry.register(stack, new DoubleConfigField("attackAOE", this.getMaxWeaponAOE(stack), 0.0, this.getMaxWeaponAOE(stack), "config.field.attackAOE.description", IItemConfigField.EnumControlType.SLIDER));
        this.addEnchantConfig(stack, registry);
        return registry;
    }

    @Override
    public double getWeaponAOE(ItemStack stack) {
        return ToolConfigHelper.getDoubleField("attackAOE", stack);
    }

    @Override
    public double getMaxWeaponAOE(ItemStack stack) {
        int level = UpgradeHelper.getUpgradeLevel(stack, "attackAOE");
        if (level == 0) {
            return 0.0;
        }
        if (level == 1) {
            return 1.0;
        }
        if (level == 2) {
            return 2.0;
        }
        if (level == 3) {
            return 5.0;
        }
        if (level == 4) {
            return 10.0;
        }
        return 0.0;
    }

    @Override
    public void setWeaponAOE(ItemStack stack, double value) {
        ToolConfigHelper.setDoubleField("attackAOE", stack, value);
    }

    @Override
    public int getReaperLevel(ItemStack stack) {
        return 1;
    }

    @Override
    public void registerRenderer(Feature feature) {
        super.registerRenderer(feature);
        ToolOverrideList.putOverride((Item)this, WyvernSword::handleTransforms);
    }

    @SideOnly(value=Side.CLIENT)
    private static IModelState handleTransforms(ItemCameraTransforms.TransformType transformType, IModelState state) {
        return transformType == ItemCameraTransforms.TransformType.FIXED || transformType == ItemCameraTransforms.TransformType.GROUND ? ToolTransforms.WY_SWORD_STATE : state;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public PairKV<TextureAtlasSprite, ResourceLocation> getModels(ItemStack stack) {
        return new PairKV((Object)DETextures.WYVERN_SWORD, (Object)new ResourceLocation("draconicevolution", "models/item/tools/wyvern_sword.obj"));
    }
}

