/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.item.yetawrench;

import buildcraft.api.tools.IToolWrench;
import cofh.api.item.IToolHammer;
import com.enderio.core.api.client.gui.IAdvancedTooltipProvider;
import com.enderio.core.client.handlers.SpecialTooltipHandler;
import com.enderio.core.common.vecmath.Vector4d;
import crazypants.enderio.api.IModObject;
import crazypants.enderio.api.tool.IConduitControl;
import crazypants.enderio.api.tool.ITool;
import crazypants.enderio.base.BlockEio;
import crazypants.enderio.base.EnderIOTab;
import crazypants.enderio.base.conduit.ConduitDisplayMode;
import crazypants.enderio.base.config.config.PersonalConfig;
import crazypants.enderio.base.handler.KeyTracker;
import crazypants.enderio.base.machine.interfaces.IYetaAwareBlock;
import crazypants.enderio.base.paint.IPaintable;
import crazypants.enderio.base.paint.PaintUtil;
import crazypants.enderio.base.paint.YetaUtil;
import crazypants.enderio.base.render.IHaveRenderers;
import crazypants.enderio.base.render.registry.ItemModelRegistry;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Optional.InterfaceList(value={@Optional.Interface(iface="buildcraft.api.tools.IToolWrench", modid="BuildCraftAPI|core"), @Optional.Interface(iface="cofh.api.item.IToolHammer", modid="cofhcore")})
public class ItemYetaWrench
extends Item
implements ITool,
IConduitControl,
IAdvancedTooltipProvider,
IToolWrench,
IToolHammer,
IHaveRenderers {
    public static ItemYetaWrench create(@Nonnull IModObject modObject, @Nullable Block block) {
        return new ItemYetaWrench(modObject);
    }

    protected ItemYetaWrench(@Nonnull IModObject modObject) {
        this.func_77637_a(EnderIOTab.tabEnderIOItems);
        modObject.apply(this);
        this.func_77625_d(1);
    }

    @Nonnull
    public EnumActionResult onItemUseFirst(@Nonnull EntityPlayer player, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull EnumFacing side, float hitX, float hitY, float hitZ, @Nonnull EnumHand hand) {
        BlockEio beio;
        IBlockState paintSource;
        BlockDoor.EnumDoorHalf half;
        IBlockState blockState;
        IBlockState bs = blockState = world.func_180495_p(pos);
        Block block = bs.func_177230_c();
        boolean ret = false;
        PlayerInteractEvent.RightClickBlock e = new PlayerInteractEvent.RightClickBlock(player, hand, pos, side, new Vec3d((double)hitX, (double)hitY, (double)hitZ));
        if (MinecraftForge.EVENT_BUS.post((Event)e) || e.getResult() == Event.Result.DENY || e.getUseBlock() == Event.Result.DENY || e.getUseItem() == Event.Result.DENY) {
            return EnumActionResult.PASS;
        }
        if (block instanceof BlockDoor && (half = (BlockDoor.EnumDoorHalf)bs.func_177229_b((IProperty)BlockDoor.field_176523_O)) == BlockDoor.EnumDoorHalf.UPPER) {
            pos = pos.func_177977_b();
        }
        if (!player.func_70093_af() && block.rotateBlock(world, pos, side)) {
            ret = true;
        } else if (block instanceof IPaintable.IBlockPaintableBlock && !player.func_70093_af() && !YetaUtil.shouldHeldItemHideFacades(player) && (paintSource = ((IPaintable.IBlockPaintableBlock)block).getPaintSource(blockState, (IBlockAccess)world, pos)) != null) {
            IBlockState rotatedPaintSource = PaintUtil.rotate(paintSource);
            if (rotatedPaintSource != paintSource) {
                ((IPaintable.IBlockPaintableBlock)block).setPaintSource(blockState, (IBlockAccess)world, pos, rotatedPaintSource);
            }
            ret = true;
        }
        if (!ret && player.func_70093_af() && block instanceof BlockEio && (beio = (BlockEio)block).shouldWrench(world, pos, player, side)) {
            beio.func_180639_a(world, pos, bs, player, hand, side, hitX, hitY, hitZ);
            ret = true;
        }
        if (ret) {
            player.func_184609_a(hand);
        }
        return ret && !world.field_72995_K ? EnumActionResult.SUCCESS : EnumActionResult.PASS;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull World world, @Nonnull EntityPlayer player, @Nonnull EnumHand hand) {
        ItemStack equipped = player.func_184586_b(hand);
        if (!((Boolean)PersonalConfig.yetaUseSneakRightClick.get()).booleanValue() || !player.func_70093_af()) {
            return new ActionResult(EnumActionResult.PASS, (Object)equipped);
        }
        ConduitDisplayMode curMode = ConduitDisplayMode.getDisplayMode(equipped);
        ConduitDisplayMode newMode = curMode.next();
        ConduitDisplayMode.setDisplayMode(equipped, newMode);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)equipped);
    }

    public boolean onBlockStartBreak(@Nonnull ItemStack itemstack, @Nonnull BlockPos pos, @Nonnull EntityPlayer player) {
        IBlockState bs = player.field_70170_p.func_180495_p(pos);
        Block block = bs.func_177230_c();
        if (player.func_70093_af() && block instanceof IYetaAwareBlock && player.field_71075_bZ.field_75098_d) {
            block.func_180649_a(player.field_70170_p, pos, player);
            return true;
        }
        return false;
    }

    public boolean canDestroyBlockInCreative(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull ItemStack stack, @Nonnull EntityPlayer player) {
        return false;
    }

    public boolean shouldCauseReequipAnimation(@Nonnull ItemStack oldStack, @Nonnull ItemStack newStack, boolean slotChanged) {
        return !ItemStack.func_179545_c((ItemStack)oldStack, (ItemStack)newStack);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }

    public boolean doesSneakBypassUse(@Nonnull ItemStack stack, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EntityPlayer player) {
        return false;
    }

    @Override
    public boolean canUse(@Nonnull EnumHand hand, @Nonnull EntityPlayer player, @Nonnull BlockPos pos) {
        return true;
    }

    @Override
    public void used(@Nonnull EnumHand hand, @Nonnull EntityPlayer player, @Nonnull BlockPos pos) {
    }

    @Override
    public boolean shouldHideFacades(@Nonnull ItemStack stack, @Nonnull EntityPlayer player) {
        ConduitDisplayMode curMode = ConduitDisplayMode.getDisplayMode(stack);
        return curMode != ConduitDisplayMode.NONE && curMode != ConduitDisplayMode.NEUTRAL;
    }

    @Override
    public boolean showOverlay(@Nonnull ItemStack stack, @Nonnull EntityPlayer player) {
        return true;
    }

    public void addBasicEntries(@Nonnull ItemStack itemstack, @Nullable EntityPlayer entityplayer, @Nonnull List<String> list, boolean flag) {
    }

    public void addCommonEntries(@Nonnull ItemStack itemstack, @Nullable EntityPlayer entityplayer, @Nonnull List<String> list, boolean flag) {
    }

    public void addDetailedEntries(@Nonnull ItemStack itemstack, @Nullable EntityPlayer entityplayer, @Nonnull List<String> list, boolean flag) {
        ArrayList tmp = new ArrayList();
        SpecialTooltipHandler.addDetailedTooltipFromResources(tmp, (String)this.func_77658_a());
        String keyName = KeyTracker.yetawrenchmode.getBinding().getDisplayName();
        for (String line : tmp) {
            list.add(String.format(line, keyName));
        }
    }

    @Optional.Method(modid="BuildCraftAPI|core")
    public boolean canWrench(EntityPlayer player, EnumHand hand, ItemStack stack, RayTraceResult res) {
        return true;
    }

    @Optional.Method(modid="BuildCraftAPI|core")
    public void wrenchUsed(EntityPlayer player, EnumHand hand, ItemStack stack, RayTraceResult res) {
        this.used(hand, player, res.func_178782_a());
    }

    @Optional.Method(modid="cofhcore")
    public boolean isUsable(ItemStack item, EntityLivingBase user, BlockPos pos) {
        return true;
    }

    @Optional.Method(modid="cofhcore")
    public boolean isUsable(ItemStack item, EntityLivingBase user, Entity entity) {
        return false;
    }

    @Optional.Method(modid="cofhcore")
    public void toolUsed(ItemStack item, EntityLivingBase user, BlockPos pos) {
        if (user instanceof EntityPlayer) {
            this.used(EnumHand.MAIN_HAND, (EntityPlayer)user, pos);
        }
    }

    @Optional.Method(modid="cofhcore")
    public void toolUsed(ItemStack item, EntityLivingBase user, Entity entity) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerRenderers(@Nonnull IModObject modObject) {
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation(modObject.getRegistryName(), "#inventory"));
        if (((Boolean)PersonalConfig.animatedYeta.get()).booleanValue()) {
            ItemModelRegistry.registerRotating(new ModelResourceLocation(modObject.getRegistryName(), "#inventory"), transformType -> {
                switch (transformType) {
                    case THIRD_PERSON_RIGHT_HAND: {
                        return new Vector4d(1.0, 1.0, 0.0, 1.0);
                    }
                    case THIRD_PERSON_LEFT_HAND: {
                        return new Vector4d(-1.0, 1.0, 0.0, 1.0);
                    }
                }
                return null;
            });
        }
    }
}

