/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.enchanter;

import com.enderio.core.common.util.ItemUtil;
import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.Util;
import crazypants.enderio.base.machine.base.te.AbstractMachineEntity;
import crazypants.enderio.base.machine.modes.IoMode;
import crazypants.enderio.base.recipe.MachineRecipeInput;
import crazypants.enderio.base.recipe.MachineRecipeRegistry;
import crazypants.enderio.base.recipe.enchanter.EnchanterRecipe;
import crazypants.enderio.machines.init.MachineObject;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;

@Storable
public class TileEnchanter
extends AbstractMachineEntity
implements ISidedInventory {
    @Store
    private NNList<ItemStack> inv = new NNList(4, (Object)ItemStack.field_190927_a);

    public boolean func_70300_a(@Nonnull EntityPlayer player) {
        return this.canPlayerAccess(player);
    }

    public int func_70302_i_() {
        return this.inv.size();
    }

    @Nonnull
    public ItemStack func_70301_a(int slot) {
        if (slot < 0 || slot >= this.inv.size()) {
            return ItemStack.field_190927_a;
        }
        return (ItemStack)this.inv.get(slot);
    }

    @Nonnull
    public ItemStack func_70298_a(int slot, int amount) {
        return Util.decrStackSize((IInventory)this, (int)slot, (int)amount);
    }

    public void func_70299_a(int slot, @Nullable ItemStack contents) {
        if (contents == null) {
            this.inv.set(slot, (Object)contents);
        } else {
            this.inv.set(slot, (Object)contents.func_77946_l());
        }
        if (contents != null && contents.func_190916_E() > this.func_70297_j_()) {
            contents.func_190920_e(this.func_70297_j_());
        }
    }

    @Nonnull
    public ItemStack func_70304_b(int index) {
        ItemStack res = this.func_70301_a(index);
        this.func_70299_a(index, res);
        return res;
    }

    public void func_174888_l() {
        for (int i = 0; i < this.inv.size(); ++i) {
            this.inv.set(i, (Object)ItemStack.field_190927_a);
        }
    }

    @Nonnull
    public String func_70005_c_() {
        return MachineObject.block_enchanter.getUnlocalisedName();
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_174889_b(@Nonnull EntityPlayer p) {
    }

    public void func_174886_c(@Nonnull EntityPlayer p) {
    }

    public boolean func_94041_b(int slot, @Nonnull ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        return MachineRecipeRegistry.instance.getRecipeForInput(this.getMachineLevel(), "enchanter", new MachineRecipeInput(slot, stack)) != null;
    }

    public boolean func_191420_l() {
        return this.inv.stream().allMatch(ItemStack::func_190926_b);
    }

    public EnchanterRecipe getCurrentEnchantmentRecipe() {
        if (((ItemStack)this.inv.get(0)).func_190926_b() || ((ItemStack)this.inv.get(1)).func_190926_b() || ((ItemStack)this.inv.get(2)).func_190926_b()) {
            return null;
        }
        return (EnchanterRecipe)MachineRecipeRegistry.instance.getRecipeForInputs(this.getMachineLevel(), "enchanter", this.getInvAsMachineRecipeInput());
    }

    public int getCurrentEnchantmentCost() {
        EnchanterRecipe currentEnchantmentRecipe = this.getCurrentEnchantmentRecipe();
        return currentEnchantmentRecipe != null ? currentEnchantmentRecipe.getXPCost(this.getInvAsMachineRecipeInput()) : 0;
    }

    @Nonnull
    public NNList<MachineRecipeInput> getInvAsMachineRecipeInput() {
        return new NNList((Object[])new MachineRecipeInput[]{new MachineRecipeInput(0, (ItemStack)this.inv.get(0)), new MachineRecipeInput(1, (ItemStack)this.inv.get(1)), new MachineRecipeInput(2, (ItemStack)this.inv.get(2))});
    }

    public void setOutput(@Nonnull ItemStack output) {
        this.inv.set(this.inv.size() - 1, (Object)output);
        this.func_70296_d();
    }

    @Nonnull
    public int[] func_180463_a(@Nonnull EnumFacing side) {
        return new int[0];
    }

    @Nonnull
    public ITextComponent func_145748_c_() {
        return new TextComponentString(this.func_70005_c_());
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public boolean func_180462_a(int index, @Nonnull ItemStack itemStackIn, @Nonnull EnumFacing direction) {
        return false;
    }

    public boolean func_180461_b(int index, @Nonnull ItemStack stack, @Nonnull EnumFacing direction) {
        return false;
    }

    @Override
    @Nonnull
    public String getMachineName() {
        return "enchanter";
    }

    @Override
    public boolean isActive() {
        return false;
    }

    @Override
    protected boolean doPull(EnumFacing dir) {
        return false;
    }

    @Override
    protected boolean doPush(EnumFacing dir) {
        return false;
    }

    @Override
    protected void processTasks(boolean redstoneCheck) {
    }

    @Override
    public void doUpdate() {
        this.disableTicking();
    }

    @Override
    public boolean supportsMode(@Nullable EnumFacing faceHit, @Nullable IoMode mode) {
        return mode == IoMode.NONE;
    }

    @Override
    protected boolean mergeOutput(@Nonnull ItemStack next) {
        ItemUtil.spawnItemInWorldWithRandomMotion((World)this.field_145850_b, (ItemStack)next, (BlockPos)this.field_174879_c);
        return true;
    }
}

