/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.zoo.entity;

import crazypants.enderio.base.events.EnderIOLifecycleEvent;
import crazypants.enderio.base.init.ModObject;
import crazypants.enderio.base.loot.EntityLootHelper;
import crazypants.enderio.zoo.config.ZooConfig;
import crazypants.enderio.zoo.entity.IEnderZooEntity;
import crazypants.enderio.zoo.entity.ai.EntityAIFlyingAttackOnCollide;
import crazypants.enderio.zoo.entity.ai.EntityAIFlyingFindPerch;
import crazypants.enderio.zoo.entity.ai.EntityAIFlyingLand;
import crazypants.enderio.zoo.entity.ai.EntityAIFlyingPanic;
import crazypants.enderio.zoo.entity.ai.EntityAIFlyingShortWander;
import crazypants.enderio.zoo.entity.ai.EntityAINearestAttackableTargetBounded;
import crazypants.enderio.zoo.entity.navigate.FlyingMoveHelper;
import crazypants.enderio.zoo.entity.navigate.FlyingPathNavigate;
import crazypants.enderio.zoo.entity.render.RenderOwl;
import crazypants.enderio.zoo.sound.SoundRegistry;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowParent;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber(modid="enderiozoo")
public class EntityOwl
extends EntityAnimal
implements IEnderZooEntity.Flying {
    @Nonnull
    public static final String NAME = "owl";
    public static final int EGG_BG_COL = 12679497;
    public static final int EGG_FG_COL = 16768454;
    private float wingRotation;
    private float prevWingRotation;
    private float wingRotDelta = 1.0f;
    private float destPos;
    private float prevDestPos;
    private float bodyAngle = 5.0f;
    private float targetBodyAngle = 0.0f;
    private float wingAngle;
    private double groundSpeedRatio = 0.25;
    private float climbRate = 0.25f;
    private float turnRate = 30.0f;
    public int timeUntilNextEgg;

    @SubscribeEvent
    public static void onEntityRegister(@Nonnull RegistryEvent.Register<EntityEntry> event) {
        LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("enderio", NAME));
        IEnderZooEntity.register(event, NAME, EntityOwl.class, 12679497, 16768454, IEnderZooEntity.MobID.OWL);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void onPreInit(EnderIOLifecycleEvent.PreInit event) {
        RenderingRegistry.registerEntityRenderingHandler(EntityOwl.class, (IRenderFactory)RenderOwl.FACTORY);
    }

    public EntityOwl(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.4f, 0.85f);
        this.field_70138_W = 1.0f;
        int pri = 0;
        this.field_70714_bg.func_75776_a(++pri, (EntityAIBase)new EntityAIFlyingPanic((EntityCreature)this, 2.0));
        this.field_70714_bg.func_75776_a(++pri, (EntityAIBase)new EntityAIFlyingAttackOnCollide(this, 2.5, false));
        this.field_70714_bg.func_75776_a(++pri, (EntityAIBase)new EntityAIMate((EntityAnimal)this, 1.0));
        this.field_70714_bg.func_75776_a(++pri, (EntityAIBase)new EntityAITempt((EntityCreature)this, 1.0, Items.field_151070_bp, false));
        this.field_70714_bg.func_75776_a(++pri, (EntityAIBase)new EntityAIFollowParent((EntityAnimal)this, 1.5));
        this.field_70714_bg.func_75776_a(++pri, (EntityAIBase)new EntityAIFlyingLand((EntityCreature)this, 2.0));
        this.field_70714_bg.func_75776_a(++pri, (EntityAIBase)new EntityAIFlyingFindPerch((EntityCreature)this, 2.0, 80));
        this.field_70714_bg.func_75776_a(++pri, (EntityAIBase)new EntityAIFlyingShortWander((EntityCreature)this, 2.0, 150));
        this.field_70714_bg.func_75776_a(++pri, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(++pri, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        EntityAINearestAttackableTargetBounded<EntitySpider> targetSpiders = new EntityAINearestAttackableTargetBounded<EntitySpider>((EntityCreature)this, EntitySpider.class, true, true);
        targetSpiders.setMaxDistanceToTarget(ZooConfig.owlAggressionRange);
        targetSpiders.setMaxVerticalDistanceToTarget(ZooConfig.owlAggressionRangeVertical);
        this.field_70715_bh.func_75776_a(0, targetSpiders);
        this.field_70765_h = new FlyingMoveHelper(this);
        this.timeUntilNextEgg = this.getNextLayingTime();
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(4.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.applyAttributes((EntityLivingBase)this, ZooConfig.owlHealth, ZooConfig.OwlDamage);
    }

    @Nonnull
    protected PathNavigate func_175447_b(@Nonnull World worldIn) {
        return new FlyingPathNavigate((EntityLiving)this, worldIn);
    }

    @Override
    public FlyingPathNavigate getFlyingNavigator() {
        return (FlyingPathNavigate)this.func_70661_as();
    }

    public float func_180484_a(@Nonnull BlockPos pos) {
        IBlockState bs = this.field_70170_p.func_180495_p(pos.func_177977_b());
        return bs.func_185904_a() == Material.field_151584_j ? 10.0f : 0.0f;
    }

    public boolean func_70652_k(@Nonnull Entity entityIn) {
        super.func_70652_k(entityIn);
        float attackDamage = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        if (entityIn instanceof EntitySpider) {
            attackDamage *= ((Float)ZooConfig.owlSpiderDamageMultiplier.get()).floatValue();
        }
        return entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), attackDamage);
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.prevWingRotation = this.wingRotation;
        this.prevDestPos = this.destPos;
        this.destPos = (float)((double)this.destPos + (double)(this.field_70122_E ? -1 : 4) * 0.3);
        this.destPos = MathHelper.func_76131_a((float)this.destPos, (float)0.0f, (float)1.0f);
        if (!this.field_70122_E && this.wingRotDelta < 1.0f) {
            this.wingRotDelta = 1.0f;
        }
        this.wingRotDelta = (float)((double)this.wingRotDelta * 0.9);
        float flapSpeed = 2.0f;
        float yDelta = (float)Math.abs(this.field_70163_u - this.field_70167_r);
        if (yDelta != 0.0f) {
            flapSpeed *= MathHelper.func_76131_a((float)(yDelta / 0.02f), (float)0.75f, (float)1.0f);
        }
        this.wingRotation += this.wingRotDelta * flapSpeed;
        if (!this.field_70170_p.field_72995_K && !this.func_70631_g_() && --this.timeUntilNextEgg <= 0) {
            if (this.isOnLeaves()) {
                this.func_184185_a(SoundEvents.field_187665_Y, 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
                this.func_145779_a(ModObject.item_owl_egg.getItemNN(), 1);
            }
            this.timeUntilNextEgg = this.getNextLayingTime();
        }
        if (this.field_70122_E) {
            this.field_70159_w *= this.groundSpeedRatio;
            this.field_70179_y *= this.groundSpeedRatio;
        }
    }

    private boolean isOnLeaves() {
        IBlockState bs = this.field_70170_p.func_180495_p(this.func_180425_c().func_177977_b());
        return bs.func_185904_a() == Material.field_151584_j;
    }

    private void calculateWingAngle(float partialTicks) {
        float flapComletion = this.prevWingRotation + (this.wingRotation - this.prevWingRotation) * partialTicks;
        float onGroundTimerThing = this.prevDestPos + (this.destPos - this.prevDestPos) * partialTicks;
        this.wingAngle = (MathHelper.func_76126_a((float)flapComletion) + 1.0f) * onGroundTimerThing;
        if (this.field_70122_E) {
            this.wingAngle = (float)Math.toRadians(3.0);
        }
    }

    private void calculateBodyAngle(float partialTicks) {
        if (this.field_70122_E) {
            this.bodyAngle = 7.0f;
            this.targetBodyAngle = 7.0f;
            return;
        }
        Vec3d motionVec = new Vec3d(this.field_70159_w, 0.0, this.field_70179_y);
        double speed = motionVec.func_72433_c();
        speed = Math.min(1.0, speed * 10.0);
        this.targetBodyAngle = 20.0f + (float)speed * 30.0f;
        if (this.targetBodyAngle == this.bodyAngle) {
            return;
        }
        if (this.targetBodyAngle > this.bodyAngle) {
            this.bodyAngle += 2.0f * partialTicks;
            if (this.bodyAngle > this.targetBodyAngle) {
                this.bodyAngle = this.targetBodyAngle;
            }
        } else {
            this.bodyAngle -= 1.0f * partialTicks;
            if (this.bodyAngle < this.targetBodyAngle) {
                this.bodyAngle = this.targetBodyAngle;
            }
        }
    }

    public void calculateAngles(float partialTicks) {
        this.calculateBodyAngle(partialTicks);
        this.calculateWingAngle(partialTicks);
    }

    public float getBodyAngle() {
        return (float)Math.toRadians(this.bodyAngle);
    }

    public float getWingAngle() {
        return this.wingAngle;
    }

    public float func_70047_e() {
        return this.field_70131_O - 0.1f;
    }

    protected void func_184231_a(double y, boolean onGroundIn, @Nonnull IBlockState blockIn, @Nonnull BlockPos pos) {
    }

    public int func_70627_aG() {
        return (Integer)ZooConfig.owlHootInterval.get();
    }

    public void func_70642_aH() {
        if (this.field_70170_p.func_72935_r() || this.func_70638_az() != null) {
            return;
        }
        this.func_184185_a(this.func_184639_G(), this.func_70599_aP() * ((Float)ZooConfig.owlHootVolumeMultiplier.get()).floatValue(), 0.8f * this.func_70647_i());
    }

    @Nonnull
    protected SoundEvent func_184639_G() {
        if (this.field_70170_p.field_73012_v.nextBoolean()) {
            return SoundRegistry.OWL_HOOT2.getSoundEvent();
        }
        return SoundRegistry.OWL_HOOT.getSoundEvent();
    }

    protected SoundEvent func_184601_bQ(@Nonnull DamageSource source) {
        return SoundRegistry.OWL_HURT.getSoundEvent();
    }

    protected SoundEvent func_184615_bR() {
        return SoundRegistry.OWL_HURT.getSoundEvent();
    }

    public EntityOwl createChild(@Nonnull EntityAgeable ageable) {
        return new EntityOwl(this.field_70170_p);
    }

    public boolean func_70877_b(@Nonnull ItemStack stack) {
        return stack.func_77973_b() == Items.field_151070_bp;
    }

    protected void func_180429_a(@Nonnull BlockPos pos, @Nonnull Block blockIn) {
        this.func_184185_a(SoundEvents.field_187538_aa, 0.15f, 1.0f);
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return new ResourceLocation("enderio", NAME);
    }

    protected void func_184610_a(boolean wasRecentlyHit, int lootingModifier, @Nonnull DamageSource source) {
        EntityLootHelper.dropLoot((EntityLiving)this, (ResourceLocation)this.func_184647_J(), (DamageSource)source);
        this.func_82160_b(wasRecentlyHit, lootingModifier);
    }

    @Override
    public float getMaxTurnRate() {
        return this.turnRate;
    }

    @Override
    public float getMaxClimbRate() {
        return this.climbRate;
    }

    @Override
    public EntityCreature asEntityCreature() {
        return this;
    }

    private int getNextLayingTime() {
        int dif = (Integer)ZooConfig.owlTimeBetweenEggsMax.get() - (Integer)ZooConfig.owlTimeBetweenEggsMin.get();
        return (Integer)ZooConfig.owlTimeBetweenEggsMin.get() + this.field_70146_Z.nextInt(dif);
    }

    public void func_70037_a(@Nonnull NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        if (tagCompund.func_74764_b("EggLayTime")) {
            this.timeUntilNextEgg = tagCompund.func_74762_e("EggLayTime");
        }
    }

    public void func_70014_b(@Nonnull NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74768_a("EggLayTime", this.timeUntilNextEgg);
    }

    public boolean func_184652_a(@Nonnull EntityPlayer player) {
        return !this.func_110167_bD();
    }
}

