/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.zoo.entity;

import crazypants.enderio.base.EnderIO;
import crazypants.enderio.zoo.entity.SpawnUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.vecmath.Point3i;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class EntityUtil {
    public static boolean isHardDifficulty(@Nonnull World worldObj) {
        return worldObj.func_175659_aa() == EnumDifficulty.HARD;
    }

    public static float getDifficultyMultiplierForLocation(@Nonnull World world, double x, double y, double z) {
        float occupiedDiffcultyMultiplier = world.func_175649_E(new BlockPos(x, y, z)).func_180170_c();
        return occupiedDiffcultyMultiplier /= 1.5f;
    }

    @Nonnull
    public static String getDisplayNameForEntity(@Nonnull String mobName) {
        return EnderIO.lang.localizeExact("entity." + mobName + ".name");
    }

    @Nonnull
    public static Vec3d getEntityPosition(@Nonnull Entity entity) {
        return new Vec3d(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
    }

    @Nonnull
    public static AxisAlignedBB getBoundsAround(@Nonnull Entity entity, double range) {
        return EntityUtil.getBoundsAround(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, range);
    }

    @Nonnull
    public static AxisAlignedBB getBoundsAround(@Nonnull Vec3d pos, double range) {
        return EntityUtil.getBoundsAround(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, range);
    }

    @Nonnull
    public static AxisAlignedBB getBoundsAround(@Nonnull BlockPos pos, int range) {
        return EntityUtil.getBoundsAround(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), range);
    }

    @Nonnull
    public static AxisAlignedBB getBoundsAround(double x, double y, double z, double range) {
        return new AxisAlignedBB(x - range, y - range, z - range, x + range, y + range, z + range);
    }

    @Nonnull
    public static Point3i getEntityPositionI(@Nonnull Entity entity) {
        return new Point3i((int)entity.field_70165_t, (int)entity.field_70163_u, (int)entity.field_70161_v);
    }

    public static void cancelCurrentTasks(@Nonnull EntityLiving ent) {
        Iterator iterator = ent.field_70714_bg.field_75782_a.iterator();
        ArrayList<EntityAITasks.EntityAITaskEntry> currentTasks = new ArrayList<EntityAITasks.EntityAITaskEntry>();
        while (iterator.hasNext()) {
            EntityAITasks.EntityAITaskEntry entityaitaskentry = (EntityAITasks.EntityAITaskEntry)iterator.next();
            if (entityaitaskentry == null) continue;
            currentTasks.add(entityaitaskentry);
        }
        for (EntityAITasks.EntityAITaskEntry task : currentTasks) {
            ent.field_70714_bg.func_85156_a(task.field_75733_a);
            ent.field_70714_bg.func_75776_a(task.field_75731_b, task.field_75733_a);
        }
        ent.func_70661_as().func_75499_g();
    }

    @Nullable
    public static IAttributeInstance removeModifier(@Nonnull EntityLivingBase ent, @Nonnull IAttribute p, @Nonnull UUID u) {
        IAttributeInstance att = ent.func_110148_a(p);
        AttributeModifier curmod = att.func_111127_a(u);
        if (curmod != null) {
            att.func_111124_b(curmod);
        }
        return att;
    }

    public static double getDistanceSqToNearestPlayer(@Nonnull Entity entity, double maxRange) {
        AxisAlignedBB bounds = EntityUtil.getBoundsAround(entity, maxRange);
        EntityPlayer nearest = (EntityPlayer)entity.func_130014_f_().func_72857_a(EntityPlayer.class, bounds, entity);
        if (nearest == null) {
            return 1.0;
        }
        return nearest.func_70068_e(entity);
    }

    public static boolean isPlayerWithinRange(@Nonnull Entity entity, double range) {
        List res = entity.func_130014_f_().func_72872_a(EntityPlayer.class, EntityUtil.getBoundsAround(entity, range));
        return !res.isEmpty();
    }

    public static boolean isOnGround(@Nonnull EntityCreature entity) {
        List collides = entity.func_130014_f_().func_184144_a((Entity)entity, entity.func_174813_aQ().func_72317_d(0.0, -0.1, 0.0));
        if (collides.isEmpty()) {
            return false;
        }
        BlockPos groundPos = entity.func_180425_c().func_177977_b();
        IBlockState bs = entity.func_130014_f_().func_180495_p(groundPos);
        return !bs.func_185904_a().func_76224_d();
    }

    @Nullable
    public static BlockPos findRandomLandingSurface(@Nonnull EntityCreature entity, int searchRange, int minY, int maxY, int searchAttempts) {
        for (int i = 0; i < searchAttempts; ++i) {
            BlockPos res = EntityUtil.findRandomLandingSurface((EntityLiving)entity, searchRange, minY, maxY);
            if (res == null) continue;
            return res;
        }
        return null;
    }

    @Nullable
    public static BlockPos findRandomClearArea(@Nonnull EntityCreature entity, int searchRange, int minY, int maxY, int searchAttempts) {
        BlockPos ep = entity.func_180425_c();
        Vec3d pos = entity.func_174791_d();
        World worldObj = entity.func_130014_f_();
        for (int i = 0; i < searchAttempts; ++i) {
            int x = ep.func_177958_n() + -searchRange + worldObj.field_73012_v.nextInt(searchRange + 1) * 2;
            int y = minY + worldObj.field_73012_v.nextInt(maxY - minY + 1);
            int z = ep.func_177952_p() + -searchRange + worldObj.field_73012_v.nextInt(searchRange + 1) * 2;
            entity.func_70107_b((double)x + 0.5, (double)y, (double)z + 0.5);
            boolean isSpace = SpawnUtil.isSpaceAvailableForSpawn(worldObj, (EntityLiving)entity, false);
            entity.func_70107_b(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
            if (!isSpace) continue;
            return new BlockPos(x, y, z);
        }
        return null;
    }

    @Nullable
    public static BlockPos findRandomLandingSurface(@Nonnull EntityLiving entity, int searchRange, int minY, int maxY) {
        BlockPos ep = entity.func_180425_c();
        World worldObj = entity.func_130014_f_();
        int x = ep.func_177958_n() + -searchRange + worldObj.field_73012_v.nextInt(searchRange + 1) * 2;
        int z = ep.func_177952_p() + -searchRange + worldObj.field_73012_v.nextInt(searchRange + 1) * 2;
        return EntityUtil.findClearLandingSurface(entity, x, z, minY, maxY);
    }

    @Nullable
    public static BlockPos findClearLandingSurface(@Nonnull EntityLiving ent, int x, int z, int minY, int maxY) {
        double origX = ent.field_70165_t;
        double origY = ent.field_70163_u;
        double origZ = ent.field_70161_v;
        int y = maxY;
        boolean canLand = EntityUtil.canLandAtLocation(ent, x, y, z);
        while (!canLand && --y >= minY) {
            canLand = EntityUtil.canLandAtLocation(ent, x, y, z);
        }
        ent.func_70107_b(origX, origY, origZ);
        if (canLand) {
            return new BlockPos(x, y, z);
        }
        return null;
    }

    private static boolean canLandAtLocation(@Nonnull EntityLiving ent, int x, int y, int z) {
        World world = ent.func_130014_f_();
        ent.func_70107_b((double)x + 0.5, (double)y, (double)z + 0.5);
        if (!SpawnUtil.isSpaceAvailableForSpawn(world, ent, false, false)) {
            return false;
        }
        BlockPos below = new BlockPos(x, y, z).func_177977_b();
        IBlockState bs = world.func_180495_p(below);
        if (!bs.func_185904_a().func_76220_a()) {
            return false;
        }
        AxisAlignedBB collides = bs.func_185890_d((IBlockAccess)world, below);
        return collides != null;
    }
}

