/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.api;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import net.minecraft.util.text.translation.I18n;

public class PanelString {
    private static DecimalFormat formatter;
    public String textLeft;
    public String textCenter;
    public String textRight;
    public int colorLeft;
    public int colorCenter;
    public int colorRight;

    public PanelString() {
    }

    public PanelString(String text) {
        this.textLeft = text;
    }

    public PanelString(String resourceName, double value, boolean showLabels) {
        this(resourceName, PanelString.getFormatter().format(value), showLabels);
    }

    public PanelString(String resourceName, String value, boolean showLabels) {
        this.textLeft = PanelString.getFormatted(resourceName, value, showLabels);
    }

    public PanelString(String resourceName, double value, String eu, boolean showLabels) {
        this(resourceName, String.format("%s %s", PanelString.getFormatter().format(value), eu), showLabels);
    }

    public static PanelString create(String resourceName, int value, String name) {
        return new PanelString(I18n.func_74837_a((String)resourceName, (Object[])new Object[]{value, name}));
    }

    public static DecimalFormat getFormatter() {
        if (formatter == null) {
            DecimalFormat lFormatter = new DecimalFormat("#,###.###");
            DecimalFormatSymbols smb = new DecimalFormatSymbols();
            smb.setGroupingSeparator(' ');
            lFormatter.setDecimalFormatSymbols(smb);
            formatter = lFormatter;
        }
        return formatter;
    }

    private static String getFormatted(String resourceName, String value, boolean showLabels) {
        if (showLabels) {
            return I18n.func_74837_a((String)resourceName, (Object[])new Object[]{value});
        }
        return value;
    }
}

