/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.crossmod;

import com.zuxelus.energycontrol.crossmod.CrossModBase;
import com.zuxelus.energycontrol.utils.FluidInfo;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.MetaTileEntityHolder;
import gregtech.api.metatileentity.SteamMetaTileEntity;
import gregtech.common.metatileentities.steam.boiler.SteamBoiler;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;

public class CrossGregTech
extends CrossModBase {
    @Override
    public NBTTagCompound getEnergyData(TileEntity te) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("euType", "EU");
        return null;
    }

    @Override
    public List<FluidInfo> getAllTanks(TileEntity te) {
        if (te instanceof MetaTileEntityHolder) {
            ArrayList<FluidInfo> result = new ArrayList<FluidInfo>();
            MetaTileEntity base = ((MetaTileEntityHolder)te).getMetaTileEntity();
            try {
                if (base instanceof SteamBoiler) {
                    Field field = SteamBoiler.class.getDeclaredField("waterFluidTank");
                    field.setAccessible(true);
                    result.add(new FluidInfo((IFluidTank)((FluidTank)field.get(base))));
                    field = SteamBoiler.class.getDeclaredField("steamFluidTank");
                    field.setAccessible(true);
                    result.add(new FluidInfo((IFluidTank)((FluidTank)field.get(base))));
                    return result;
                }
                if (base instanceof SteamMetaTileEntity) {
                    Field field = SteamMetaTileEntity.class.getDeclaredField("steamFluidTank");
                    field.setAccessible(true);
                    result.add(new FluidInfo((IFluidTank)((FluidTank)field.get(base))));
                    return result;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public NBTTagCompound getCardData(World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof MetaTileEntityHolder) {
            NBTTagCompound tag = new NBTTagCompound();
            MetaTileEntity base = ((MetaTileEntityHolder)te).getMetaTileEntity();
            try {
                if (base instanceof SteamBoiler) {
                    SteamBoiler boiler = (SteamBoiler)base;
                    Field field = SteamBoiler.class.getDeclaredField("currentTemperature");
                    field.setAccessible(true);
                    int currentTemperature = (Integer)field.get(base);
                    field = SteamBoiler.class.getDeclaredField("baseSteamOutput");
                    field.setAccessible(true);
                    int baseSteamOutput = (Integer)field.get(base);
                    double consumption = 0.0;
                    double output = 0.0;
                    if (currentTemperature >= 100) {
                        int rate = boiler.getMaxTemperate() == 1000 ? 10 : 25;
                        output = (double)(baseSteamOutput * currentTemperature / boiler.getMaxTemperate()) * 1.0 / (double)rate * 20.0;
                        consumption = 1.0 / (double)rate * 20.0;
                    }
                    tag.func_74780_a("consumption", consumption);
                    tag.func_74780_a("outputmb", output);
                    tag.func_74768_a("heat", currentTemperature);
                    field = SteamBoiler.class.getDeclaredField("fuelBurnTimeLeft");
                    field.setAccessible(true);
                    int fuelBurnTimeLeft = (Integer)field.get(base);
                    double rate = boiler.getMaxTemperate() == 1000 ? 6.0 : 12.0;
                    tag.func_74780_a("burnTime", Math.ceil((double)fuelBurnTimeLeft * rate / 20.0));
                    field = SteamBoiler.class.getDeclaredField("waterFluidTank");
                    field.setAccessible(true);
                    FluidInfo.addTank("tank", tag, (FluidTank)field.get(base));
                    field = SteamBoiler.class.getDeclaredField("steamFluidTank");
                    field.setAccessible(true);
                    FluidInfo.addTank("tank2", tag, (FluidTank)field.get(base));
                    return tag;
                }
                if (base instanceof SteamMetaTileEntity) {
                    Field field = SteamMetaTileEntity.class.getDeclaredField("steamFluidTank");
                    field.setAccessible(true);
                    FluidInfo.addTank("tank", tag, (FluidTank)field.get(base));
                    return tag;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }
}

