/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.items.cards;

import com.zuxelus.energycontrol.api.CardState;
import com.zuxelus.energycontrol.api.ICardReader;
import com.zuxelus.energycontrol.api.PanelSetting;
import com.zuxelus.energycontrol.api.PanelString;
import com.zuxelus.energycontrol.crossmod.CrossModLoader;
import com.zuxelus.energycontrol.items.cards.ItemCardBase;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemCardExtremeReactors
extends ItemCardBase {
    private static final DecimalFormat df = new DecimalFormat("0.0");

    public ItemCardExtremeReactors() {
        super(24, "card_big_reactors");
    }

    @Override
    public CardState update(World world, ICardReader reader, int range, BlockPos pos) {
        BlockPos target = reader.getTarget();
        if (target == null) {
            return CardState.NO_TARGET;
        }
        NBTTagCompound tag = CrossModLoader.getCrossMod("bigreactors").getCardData(world, target);
        if (tag == null) {
            return CardState.NO_TARGET;
        }
        reader.reset();
        reader.copyFrom(tag);
        return CardState.OK;
    }

    @Override
    public List<PanelString> getStringData(int settings, ICardReader reader, boolean isServer, boolean showLabels) {
        List<PanelString> result = reader.getTitleList();
        if (reader.hasField("fuelHeat") && (settings & 1) > 0) {
            result.add(new PanelString("msg.ec.InfoPanelCoreHeat", reader.getInt("fuelHeat").intValue(), showLabels));
        }
        if (reader.hasField("heat") && (settings & 1) > 0) {
            result.add(new PanelString("msg.ec.InfoPanelCasingHeat", reader.getInt("heat").intValue(), showLabels));
        }
        if (reader.hasField("cooling") && (settings & 0x40) > 0) {
            result.add(new PanelString("msg.ec.InfoPanelPassiveCooling", reader.getBoolean("cooling").toString(), showLabels));
        }
        if (reader.hasField("energy") && (settings & 2) > 0) {
            result.add(new PanelString("msg.ec.InfoPanelEnergy", reader.getDouble("energy"), "RF", showLabels));
        }
        if (reader.hasField("capacity") && (settings & 2) > 0) {
            result.add(new PanelString("msg.ec.InfoPanelCapacity", reader.getDouble("capacity"), "RF", showLabels));
        }
        if (reader.hasField("output") && (settings & 4) > 0) {
            result.add(new PanelString("msg.ec.InfoPanelOutput", reader.getDouble("output"), "RF/t", showLabels));
        }
        if (reader.hasField("outputmb") && (settings & 4) > 0) {
            result.add(new PanelString("msg.ec.InfoPanelOutput", reader.getDouble("outputmb"), "mB/t", showLabels));
        }
        if (reader.hasField("fuel") && (settings & 8) > 0) {
            result.add(new PanelString("msg.ec.InfoPanelFuel", reader.getInt("fuel").intValue(), "mB", showLabels));
        }
        if (reader.hasField("waste") && (settings & 8) > 0) {
            result.add(new PanelString("msg.ec.InfoPanelWastemb", reader.getInt("waste").intValue(), showLabels));
        }
        if ((settings & 0x40) > 0) {
            if (reader.hasField("fuelCapacity")) {
                result.add(new PanelString("msg.ec.InfoPanelCapacity", reader.getInt("fuelCapacity").intValue(), "mB", showLabels));
            }
            if (reader.hasField("consumption")) {
                result.add(new PanelString("msg.ec.InfoPanelBurnupRatemb", reader.getDouble("consumption"), showLabels));
            }
            if (reader.hasField("rods")) {
                result.add(new PanelString("msg.ec.InfoPanelFuelRods", reader.getDouble("rods"), showLabels));
            }
            if (reader.hasField("speed")) {
                result.add(new PanelString("msg.ec.InfoPanelRotorSpeed", reader.getDouble("speed"), showLabels));
            }
            if (reader.hasField("speedMax")) {
                result.add(new PanelString("msg.ec.InfoPanelMaxSpeed", reader.getDouble("speedMax"), showLabels));
            }
            if (reader.hasField("efficiency")) {
                result.add(new PanelString("msg.ec.InfoPanelRotorEfficiency", reader.getDouble("efficiency"), showLabels));
            }
            if (reader.hasField("blades")) {
                result.add(new PanelString("msg.ec.InfoPanelBlades", reader.getInt("blades").intValue(), showLabels));
            }
            if (reader.hasField("mass")) {
                result.add(new PanelString("msg.ec.InfoPanelRotorMass", reader.getInt("mass").intValue(), showLabels));
            }
            if (reader.hasField("size")) {
                result.add(new PanelString("msg.ec.InfoPanelSize", reader.getString("size"), showLabels));
            }
        }
        if (reader.hasField("active") && (settings & 0x20) > 0) {
            this.addOnOff(result, isServer, reader.getBoolean("active"));
        }
        return result;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<PanelSetting> getSettingsList(ItemStack stack) {
        ArrayList<PanelSetting> result = new ArrayList<PanelSetting>(6);
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelHeat", (Object[])new Object[0]), 1));
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelEnergy", (Object[])new Object[0]), 2));
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelOutput", (Object[])new Object[0]), 4));
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbFuel", (Object[])new Object[0]), 8));
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelTank", (Object[])new Object[0]), 16));
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelOnOff", (Object[])new Object[0]), 32));
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelOther", (Object[])new Object[0]), 64));
        return result;
    }
}

