/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.tileentities;

import com.zuxelus.energycontrol.crossmod.CrossModLoader;
import com.zuxelus.energycontrol.items.ItemUpgrade;
import com.zuxelus.energycontrol.items.cards.ItemCardMain;
import com.zuxelus.energycontrol.items.cards.ItemCardReader;
import com.zuxelus.energycontrol.tileentities.TileEntityThermalMonitor;
import com.zuxelus.zlib.containers.slots.ISlotItemFilter;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityRemoteThermalMonitor
extends TileEntityThermalMonitor
implements ISlotItemFilter {
    public static final int SLOT_CHARGER = 0;
    public static final int SLOT_CARD = 1;
    public static final byte SLOT_UPGRADE_RANGE = 2;
    private static final int LOCATION_RANGE = 8;
    private int heat;

    public TileEntityRemoteThermalMonitor() {
        this.customName = "tile.remote_thermo.name";
        this.heat = 0;
    }

    public int getHeat() {
        return this.heat;
    }

    @Override
    protected void readProperties(NBTTagCompound tag) {
        super.readProperties(tag);
        if (tag.func_74764_b("heat")) {
            this.heat = tag.func_74762_e("heat");
        }
    }

    @Override
    protected NBTTagCompound writeProperties(NBTTagCompound tag) {
        tag = super.writeProperties(tag);
        tag.func_74768_a("heat", this.heat);
        return tag;
    }

    @Override
    protected void checkStatus() {
        BlockPos target;
        int newStatus = -2;
        int newHeat = 0;
        if (!this.func_70301_a(1).func_190926_b() && (target = new ItemCardReader(this.func_70301_a(1)).getTarget()) != null) {
            int upgradeCountRange = 0;
            ItemStack stack = this.func_70301_a(2);
            if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemUpgrade && stack.func_77952_i() == 0) {
                upgradeCountRange = stack.func_190916_E();
            }
            int range = 8 * (int)Math.pow(2.0, upgradeCountRange);
            if (Math.abs(target.func_177958_n() - this.field_174879_c.func_177958_n()) <= range && Math.abs(target.func_177956_o() - this.field_174879_c.func_177956_o()) <= range && Math.abs(target.func_177952_p() - this.field_174879_c.func_177952_p()) <= range) {
                newHeat = CrossModLoader.getHeat(this.field_145850_b, target);
                int n = newHeat == -1 ? -2 : (newStatus = newHeat >= this.getHeatLevel() ? 1 : 0);
                if (newHeat == -1) {
                    newHeat = 0;
                }
            }
        }
        if (newStatus != this.status || newHeat != this.heat) {
            this.status = newStatus;
            this.heat = newHeat;
            this.notifyBlockUpdate();
            this.field_145850_b.func_175685_c(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c(), false);
        }
    }

    @Override
    public int func_70302_i_() {
        return 3;
    }

    @Override
    public boolean func_94041_b(int index, ItemStack stack) {
        return this.isItemValid(index, stack);
    }

    @Override
    public boolean isItemValid(int slotIndex, ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        switch (slotIndex) {
            case 0: {
                return false;
            }
            case 1: {
                return stack.func_77973_b() instanceof ItemCardMain;
            }
            case 2: {
                return stack.func_77973_b() instanceof ItemUpgrade && stack.func_77952_i() == 0;
            }
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }
}

