/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.utils;

import com.zuxelus.energycontrol.tileentities.TileEntitySeedLibrary;
import com.zuxelus.energycontrol.utils.SeedLibrarySort;
import ic2.api.crops.CropCard;
import ic2.api.crops.Crops;
import ic2.api.crops.ICropSeed;
import java.util.Collection;
import java.util.Vector;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class SeedLibraryFilter {
    public TileEntitySeedLibrary te;
    public boolean bulk_mode;
    public int unknown_type = 1;
    public int unknown_ggr = 1;
    public CropCard seed_type;
    public int min_growth;
    public int min_gain;
    public int min_resistance;
    public int max_growth = 31;
    public int max_gain = 31;
    public int max_resistance = 31;
    public int min_total;
    public int max_total = 93;
    public SeedLibrarySort sort = SeedLibrarySort.TOTAL_DESC;
    public static final int CACHE_SIZE = 10;
    public Vector<ItemStack> cache = new Vector(11);
    public boolean cached_nothing;

    public SeedLibraryFilter(TileEntitySeedLibrary owner) {
        this.te = owner;
    }

    public void copyFrom(SeedLibraryFilter source) {
        this.unknown_type = source.unknown_type;
        this.unknown_ggr = source.unknown_ggr;
        this.seed_type = source.seed_type;
        this.min_growth = source.min_growth;
        this.min_gain = source.min_gain;
        this.min_resistance = source.min_resistance;
        this.max_growth = source.max_growth;
        this.max_gain = source.max_gain;
        this.max_resistance = source.max_resistance;
        this.min_total = source.min_total;
        this.max_total = source.max_total;
        this.sort = source.sort;
        this.settingsChanged();
    }

    public ItemStack getSeed(Collection<ItemStack> seeds) {
        if (this.cached_nothing) {
            return null;
        }
        if (this.cache.size() == 0) {
            this.fillCache(seeds);
        }
        if (this.cache.size() == 0) {
            this.cached_nothing = true;
            return null;
        }
        return this.cache.get(0);
    }

    public int getCount(Collection<ItemStack> seeds) {
        int count = 0;
        for (ItemStack seed : seeds) {
            if (!this.isMatch(seed)) continue;
            count += seed.func_190916_E();
        }
        return count;
    }

    public void newSeed(ItemStack seed) {
        if (this.isMatch(seed)) {
            this.addToCache(seed);
            this.updateSeedCount();
        }
    }

    public void lostSeed(ItemStack seed) {
        if (this.isMatch(seed)) {
            this.removeFromCache(seed);
            this.updateSeedCount();
        }
    }

    public void settingsChanged() {
        this.cache.clear();
        this.cached_nothing = false;
        if (this.te != null && !FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            this.updateSeedCount();
            this.te.updateGUIFilter();
        }
    }

    public boolean isMatch(ItemStack stack) {
        CropCard card = Crops.instance.getCropCard(stack);
        ICropSeed seed = (ICropSeed)stack.func_77973_b();
        int scan = seed.getScannedFromStack(stack);
        if (scan == 0) {
            return this.unknown_type > 0 && this.unknown_ggr > 0;
        }
        if (this.unknown_type == 2) {
            return false;
        }
        if (this.seed_type != null && this.seed_type != card) {
            return false;
        }
        if (scan < 4) {
            return this.unknown_ggr > 0;
        }
        if (this.unknown_ggr == 2) {
            return false;
        }
        int growth = seed.getGrowthFromStack(stack);
        int gain = seed.getGainFromStack(stack);
        int resistance = seed.getResistanceFromStack(stack);
        if (growth < this.min_growth || growth > this.max_growth || gain < this.min_gain || gain > this.max_gain || resistance < this.min_resistance || resistance > this.max_resistance) {
            return false;
        }
        int total = growth + gain + resistance;
        return total >= this.min_total && total <= this.max_total;
    }

    public String getCropName() {
        if (this.seed_type == null) {
            return "Any";
        }
        return this.seed_type.getUnlocalizedName();
    }

    public void setCropFromSeed(ItemStack seed) {
        this.seed_type = seed.func_190926_b() ? null : (!(seed.func_77973_b() instanceof ICropSeed) ? null : (((ICropSeed)seed.func_77973_b()).getScannedFromStack(seed) == 0 ? null : Crops.instance.getCropCard(seed)));
        this.settingsChanged();
    }

    protected void fillCache(Collection<ItemStack> seeds) {
        this.cache.clear();
        this.bulk_mode = true;
        for (ItemStack seed : seeds) {
            this.newSeed(seed);
        }
        this.bulk_mode = false;
        this.updateSeedCount();
    }

    protected void updateSeedCount() {
        if (!this.bulk_mode && this.te != null) {
            this.te.updateSeedCount();
        }
    }

    protected void addToCache(ItemStack seed) {
        this.cached_nothing = false;
        int pos = 0;
        for (int i = this.cache.size() - 1; i >= 0; --i) {
            int cmp = this.sort.compare(seed, this.cache.get(i));
            if (cmp > 0) continue;
            pos = i + 1;
            break;
        }
        if (pos >= 10) {
            return;
        }
        this.cache.add(pos, seed);
        while (this.cache.size() > 10) {
            this.cache.remove(this.cache.size() - 1);
        }
    }

    protected void removeFromCache(ItemStack seed) {
        this.cache.remove(seed);
    }

    public void loadFromNBT(NBTTagCompound input) {
        this.unknown_type = input.func_74771_c("unknown_type");
        this.unknown_ggr = input.func_74771_c("unknown_ggr");
        if (input.func_74764_b("owner") && input.func_74764_b("id")) {
            this.seed_type = Crops.instance.getCropCard(input.func_74779_i("owner"), input.func_74779_i("id"));
        }
        this.min_growth = input.func_74762_e("min_growth");
        this.min_gain = input.func_74762_e("min_gain");
        this.min_resistance = input.func_74762_e("min_resistance");
        this.max_growth = input.func_74762_e("max_growth");
        this.max_gain = input.func_74762_e("max_gain");
        this.max_resistance = input.func_74762_e("max_resistance");
        this.min_total = input.func_74762_e("min_total");
        this.max_total = input.func_74762_e("max_total");
        int sort_type = input.func_74762_e("sort_type");
        boolean sort_desc = input.func_74767_n("sort_desc");
        this.sort = SeedLibrarySort.getSort(sort_type, sort_desc);
        this.settingsChanged();
    }

    public void writeToNBT(NBTTagCompound output) {
        output.func_74774_a("unknown_type", (byte)this.unknown_type);
        output.func_74774_a("unknown_ggr", (byte)this.unknown_ggr);
        if (this.seed_type != null) {
            output.func_74778_a("owner", this.seed_type.getOwner());
            output.func_74778_a("id", this.seed_type.getId());
        }
        output.func_74768_a("min_growth", this.min_growth);
        output.func_74768_a("min_gain", this.min_gain);
        output.func_74768_a("min_resistance", this.min_resistance);
        output.func_74768_a("max_growth", this.max_growth);
        output.func_74768_a("max_gain", this.max_gain);
        output.func_74768_a("max_resistance", this.max_resistance);
        output.func_74768_a("min_total", this.min_total);
        output.func_74768_a("max_total", this.max_total);
        output.func_74768_a("sort_type", this.sort.sort_type);
        output.func_74757_a("sort_desc", this.sort.descending);
    }
}

