/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.zlib.gui;

import java.text.DecimalFormat;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiContainerBase
extends GuiContainer {
    private static final int[] oX = new int[]{0, -1, 0, 1};
    private static final int[] oY = new int[]{-1, 0, 1, 0};
    private static final int MASKR = 0xFF0000;
    private static final int MASKG = 65280;
    private static final int MASKB = 255;
    protected static final int GREEN = 0x55FF55;
    protected static final int RED = 0xFF5555;
    protected static final int GREENGLOW = GuiContainerBase.multiplyColorComponents(0x55FF55, 0.16f);
    protected static final int REDGLOW = GuiContainerBase.multiplyColorComponents(0xFF5555, 0.16f);
    protected DecimalFormat fraction = new DecimalFormat("##0.00");
    private final ResourceLocation texture;
    protected String name;

    public GuiContainerBase(Container container, String name, ResourceLocation texture) {
        super(container);
        this.name = I18n.func_135052_a((String)name, (Object[])new Object[0]);
        this.texture = texture;
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(this.texture);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    public void drawCenteredText(String text, int x, int y) {
        this.drawCenteredText(text, x, y, 0x404040);
    }

    public void drawRightAlignedText(String text, int x, int y) {
        this.drawRightAlignedText(text, x, y, 0x404040);
    }

    public void drawLeftAlignedText(String text, int x, int y) {
        this.drawLeftAlignedText(text, x, y, 0x404040);
    }

    public void drawCenteredText(String text, int x, int y, int color) {
        this.field_146289_q.func_78276_b(text, (x - this.field_146289_q.func_78256_a(text)) / 2, y, color);
    }

    public void drawRightAlignedText(String text, int x, int y, int color) {
        this.field_146289_q.func_78276_b(text, x - this.field_146289_q.func_78256_a(text), y, color);
    }

    public void drawLeftAlignedText(String text, int x, int y, int color) {
        this.field_146289_q.func_78276_b(text, x, y, color);
    }

    public void drawRightAlignedGlowingText(String text, int x, int y, int color, int glowColor) {
        this.drawGlowingText(text, x - this.field_146289_q.func_78256_a(text), y, color, glowColor);
    }

    public void drawGlowingText(String text, int x, int y, int color, int glowColor) {
        for (int i = 0; i < 4; ++i) {
            this.field_146289_q.func_78276_b(text, x + oX[i], y + oY[i], glowColor);
        }
        this.field_146289_q.func_78276_b(text, x, y, color);
    }

    public void drawCenteredGlowingText(String text, int x, int y, int color, int glowColor) {
        this.drawGlowingText(text, x - this.field_146289_q.func_78256_a(text) / 2, y, color, glowColor);
    }

    public static int multiplyColorComponents(int color, float brightnessFactor) {
        return (int)(brightnessFactor * (float)(color & 0xFF0000)) & 0xFF0000 | (int)(brightnessFactor * (float)(color & 0xFF00)) & 0xFF00 | (int)(brightnessFactor * (float)(color & 0xFF)) & 0xFF;
    }
}

