/*
 * Decompiled with CFR 0.152.
 */
package engineers.workshop.common.table;

import engineers.workshop.EngineersWorkshop;
import engineers.workshop.client.container.slot.SlotBase;
import engineers.workshop.client.container.slot.SlotFuel;
import engineers.workshop.client.menu.GuiMenu;
import engineers.workshop.client.menu.GuiMenuItem;
import engineers.workshop.client.page.Page;
import engineers.workshop.client.page.PageMain;
import engineers.workshop.client.page.PageTransfer;
import engineers.workshop.client.page.PageUpgrades;
import engineers.workshop.client.page.setting.Setting;
import engineers.workshop.client.page.setting.Side;
import engineers.workshop.client.page.setting.Transfer;
import engineers.workshop.common.items.Upgrade;
import engineers.workshop.common.network.DataPacket;
import engineers.workshop.common.network.IBitCount;
import engineers.workshop.common.network.LengthCount;
import engineers.workshop.common.network.PacketHandler;
import engineers.workshop.common.network.PacketId;
import engineers.workshop.common.network.data.DataType;
import engineers.workshop.common.unit.Unit;
import engineers.workshop.common.unit.UnitCraft;
import engineers.workshop.common.util.Logger;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TileTable
extends TileEntity
implements IInventory,
ISidedInventory,
ITickable {
    private static final int MOVE_DELAY = 20;
    private static final int SLOT_DELAY = 10;
    private static final String NBT_ITEMS = "item";
    private static final String NBT_UNITS = "units";
    private static final String NBT_SETTINGS = "settings";
    private static final String NBT_SIDES = "sides";
    private static final String NBT_INPUT = "input";
    private static final String NBT_OUTPUT = "output";
    private static final String NBT_SLOT = "slot";
    private static final String NBT_POWER = "fuel";
    private static final String NBT_MAX_POWER = "max_power";
    private static final int COMPOUND_ID = 10;
    private static final IBitCount GRID_ID_BITS = new LengthCount(4);
    public int maxFuel = 8000;
    private List<Page> pages;
    private Page selectedPage;
    private List<SlotBase> slots;
    private NonNullList<ItemStack> items;
    private GuiMenu menu;
    private int fuel;
    private SlotFuel fuelSlot;
    private List<EntityPlayer> players = new ArrayList<EntityPlayer>();
    private int fuelTick = 0;
    private int moveTick = 0;
    private boolean lit;
    private boolean lastLit;
    private int slotTick = 0;
    private boolean firstUpdate = true;
    private int tickCount = 0;
    private int[][] sideSlots = new int[6][];

    public TileTable() {
        this.pages = new ArrayList<Page>();
        this.pages.add(new PageMain(this, "main"));
        this.pages.add(new PageTransfer(this, "transfer"));
        this.pages.add(new PageUpgrades(this, "upgrade"));
        this.slots = new ArrayList<SlotBase>();
        int id = 0;
        this.fuelSlot = new SlotFuel(this, null, id++, 226, 226);
        this.addSlot(this.fuelSlot);
        for (Page page : this.pages) {
            id = page.createSlots(id);
        }
        this.items = NonNullList.func_191197_a((int)this.slots.size(), (Object)ItemStack.field_190927_a);
        this.setSelectedPage(this.pages.get(0));
        this.onUpgradeChange();
    }

    public int getFuel() {
        return this.fuel;
    }

    public void setFuel(int fuel) {
        this.fuel = fuel;
    }

    public void setCapacity(int newCap) {
        this.maxFuel = newCap;
    }

    public List<SlotBase> getSlots() {
        return this.slots;
    }

    public List<Page> getPages() {
        return this.pages;
    }

    public Page getSelectedPage() {
        return this.selectedPage;
    }

    public void setSelectedPage(Page selectedPage) {
        this.selectedPage = selectedPage;
    }

    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    public int func_70302_i_() {
        return this.items.size();
    }

    public boolean func_191420_l() {
        for (ItemStack stack : this.items) {
            if (stack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public PageMain getMainPage() {
        return (PageMain)this.pages.get(0);
    }

    public PageTransfer getTransferPage() {
        return (PageTransfer)this.pages.get(1);
    }

    public PageUpgrades getUpgradePage() {
        return (PageUpgrades)this.pages.get(2);
    }

    @Nonnull
    public ItemStack func_70301_a(int id) {
        return (ItemStack)this.items.get(id);
    }

    @Nonnull
    public ItemStack func_70298_a(int id, int count) {
        ItemStack item = this.func_70301_a(id);
        if (!item.func_190926_b()) {
            if (item.func_190916_E() <= count) {
                this.func_70299_a(id, ItemStack.field_190927_a);
                return item;
            }
            return item.func_77979_a(count);
        }
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public ItemStack getStackInSlotOnClosing(int id) {
        if (this.slots.get(id).shouldDropOnClosing()) {
            ItemStack item = this.func_70301_a(id);
            this.func_70299_a(id, ItemStack.field_190927_a);
            return item;
        }
        return ItemStack.field_190927_a;
    }

    public void func_70299_a(int id, @Nonnull ItemStack item) {
        this.items.set(id, (Object)item);
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void addSlot(SlotBase slot) {
        this.slots.add(slot);
    }

    public List<EntityPlayer> getOpenPlayers() {
        return this.players;
    }

    public void addPlayer(EntityPlayer player) {
        Logger.debug("Trying to add player %s", player.func_70005_c_());
        if (!this.players.contains(player)) {
            this.players.add(player);
            this.sendAllDataToPlayer(player);
        } else {
            Logger.error("Trying to add a listening player: " + player.func_70005_c_());
        }
    }

    public void removePlayer(EntityPlayer player) {
        Logger.debug("Trying to remove player %s", player.func_70005_c_());
        if (!this.players.remove(player)) {
            Logger.error("Trying to remove non-listening player: " + player.func_70005_c_());
        }
    }

    private void sendAllDataToPlayer(EntityPlayer player) {
        DataPacket packet = PacketHandler.getPacket(this, PacketId.ALL);
        for (DataType dataType : DataType.values()) {
            if (dataType == null || this == null || packet == null) continue;
            dataType.save(this, packet.createCompound(), -1);
        }
        PacketHandler.sendToPlayer(packet, player);
    }

    private void sendDataToPlayer(DataType type, EntityPlayer player) {
        DataPacket packet = PacketHandler.getPacket(this, PacketId.RENDER_UPDATE);
        type.save(this, packet.createCompound(), -1);
        PacketHandler.sendToPlayer(packet, player);
    }

    public void sendDataToAllPlayers(DataType dataType, List<EntityPlayer> players) {
        this.sendDataToAllPlayers(dataType, 0, players);
    }

    public void sendDataToAllPlayers(DataType dataType, int id, List<EntityPlayer> players) {
        this.sendToAllPlayers(this.getWriterForType(dataType, id), players);
    }

    private void sendDataToAllPlayersExcept(DataType dataType, int id, EntityPlayer ignored, List<EntityPlayer> players) {
        this.sendToAllPlayersExcept(this.getWriterForType(dataType, id), ignored, players);
    }

    private void sendToAllPlayers(DataPacket dw, List<EntityPlayer> players) {
        this.sendToAllPlayersExcept(dw, null, players);
    }

    private void sendToAllPlayersExcept(DataPacket dw, EntityPlayer ignored, List<EntityPlayer> players) {
        new ArrayList().stream().filter(player -> !player.equals((Object)ignored)).forEach(player -> PacketHandler.sendToPlayer(dw, player));
    }

    public void updateServer(DataType dataType) {
        this.updateServer(dataType, 0);
    }

    public void updateServer(DataType dataType, int id) {
        PacketHandler.sendToServer(this.getWriterForType(dataType, id));
    }

    private DataPacket getWriterForType(DataType dataType, int id) {
        DataPacket packet = PacketHandler.getPacket(this, PacketId.TYPE);
        packet.dataType = dataType;
        dataType.save(this, packet.createCompound(), id);
        return packet;
    }

    public void receiveServerPacket(DataPacket dr, PacketId id, EntityPlayer player) {
        switch (id) {
            case TYPE: {
                DataType dataType = dr.dataType;
                int index = dataType.load(this, dr.compound, false);
                if (index != -1 && dataType.shouldBounce(this)) {
                    this.sendDataToAllPlayersExcept(dataType, index, dataType.shouldBounceToAll(this) ? null : player, this.players);
                }
                if (dataType == DataType.SIDE_ENABLED) {
                    this.onSideChange();
                }
                this.func_70296_d();
                break;
            }
            case CLOSE: {
                this.removePlayer(player);
                break;
            }
            case RE_OPEN: {
                this.addPlayer(player);
                break;
            }
            case CLEAR: {
                this.clearGrid(player, dr.compound.func_74762_e("clear"));
                break;
            }
            case ALL: {
                break;
            }
            case UPGRADE_CHANGE: {
                this.onUpgradeChange();
                break;
            }
        }
    }

    public void receiveClientPacket(DataPacket dr, PacketId id) {
        switch (id) {
            case ALL: {
                for (DataType dataType : DataType.values()) {
                    dataType.load(this, dr.compound, true);
                }
                this.onUpgradeChange();
                break;
            }
            case TYPE: {
                DataType dataType = dr.dataType;
                dataType.load(this, dr.compound, false);
                if (dataType != DataType.SIDE_ENABLED) break;
                this.onSideChange();
                break;
            }
            case UPGRADE_CHANGE: {
                this.onUpgradeChange();
                break;
            }
        }
    }

    public void func_73660_a() {
        ++this.tickCount;
        this.pages.forEach(Page::onUpdate);
        if (this.firstUpdate) {
            this.onUpgradeChangeDistribute();
            this.onSideChange();
            this.onUpgradeChange();
            this.firstUpdate = false;
        }
        if (!this.field_145850_b.field_72995_K && ++this.moveTick >= 20) {
            this.moveTick = 0;
            if (this.getUpgradePage().hasGlobalUpgrade(Upgrade.AUTO_TRANSFER)) {
                int transferSize = (int)Math.pow(2.0, this.getUpgradePage().getGlobalUpgradeCount(Upgrade.TRANSFER));
                for (Setting setting : this.getTransferPage().getSettings()) {
                    for (Side side : setting.getSides()) {
                        this.transfer(setting, side, side.getInput(), transferSize);
                        this.transfer(setting, side, side.getOutput(), transferSize);
                    }
                }
            }
        }
        if (!this.field_145850_b.field_72995_K && ++this.slotTick >= 10) {
            this.slotTick = 0;
            this.slots.stream().filter(SlotBase::func_111238_b).forEach(SlotBase::updateServer);
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.tickCount % 20 == 0) {
                int x1 = this.func_174877_v().func_177958_n() - 16;
                int x2 = this.func_174877_v().func_177958_n() + 16;
                int z1 = this.func_174877_v().func_177956_o() - 16;
                int z2 = this.func_174877_v().func_177956_o() + 16;
                AxisAlignedBB aabb = new AxisAlignedBB((double)x1, 0.0, (double)z1, (double)x2, 255.0, (double)z2);
                List updatePlayers = this.field_145850_b.func_72872_a(EntityPlayerMP.class, aabb);
                updatePlayers.removeAll(this.players);
            }
            this.updateFuel();
        }
    }

    private void transfer(Setting setting, Side side, Transfer transfer, int transferSize) {
        EnumFacing direction;
        BlockPos nPos;
        TileEntity te;
        if (transfer.isEnabled() && transfer.isAuto() && (te = this.field_145850_b.func_175625_s(nPos = this.field_174879_c.func_177982_a((direction = side.getDirection()).func_82601_c(), direction.func_96559_d(), direction.func_82599_e()))) instanceof IInventory) {
            int[] slots2;
            IInventory inventory = (IInventory)te;
            List<SlotBase> transferSlots = setting.getSlots();
            if (transferSlots == null) {
                return;
            }
            int[] slots1 = new int[transferSlots.size()];
            for (int i = 0; i < transferSlots.size(); ++i) {
                slots1[i] = transferSlots.get(i).getSlotIndex();
            }
            EnumFacing directionReversed = direction.func_176734_d();
            if (inventory instanceof ISidedInventory) {
                slots2 = ((ISidedInventory)inventory).func_180463_a(directionReversed);
            } else {
                slots2 = new int[inventory.func_70302_i_()];
                for (int i = 0; i < slots2.length; ++i) {
                    slots2[i] = i;
                }
            }
            if (slots2 == null || slots2.length == 0) {
                return;
            }
            if (transfer.isInput()) {
                this.transfer(inventory, this, slots2, slots1, directionReversed, direction, transferSize);
            } else {
                this.transfer(this, inventory, slots1, slots2, direction, directionReversed, transferSize);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transfer(IInventory from, IInventory to, int[] fromSlots, int[] toSlots, EnumFacing fromSide, EnumFacing toSide, int maxTransfer) {
        int oldTransfer = maxTransfer;
        try {
            ISidedInventory fromSided = fromSide.ordinal() != -1 && from instanceof ISidedInventory ? (ISidedInventory)from : null;
            ISidedInventory toSided = toSide.ordinal() != -1 && to instanceof ISidedInventory ? (ISidedInventory)to : null;
            block5: for (int fromSlot : fromSlots) {
                ItemStack toItem;
                ItemStack fromItem = from.func_70301_a(fromSlot);
                if (fromItem.func_190926_b() || fromItem.func_190916_E() <= 0 || fromSided != null && !fromSided.func_180461_b(fromSlot, fromItem, fromSide)) continue;
                if (fromItem.func_77985_e()) {
                    for (int toSlot : toSlots) {
                        toItem = to.func_70301_a(toSlot);
                        if (toItem.func_190926_b() || toItem.func_190916_E() <= 0 || toSided != null && !toSided.func_180462_a(toSlot, fromItem, toSide) || !fromItem.func_77969_a(toItem) || !ItemStack.func_77970_a((ItemStack)toItem, (ItemStack)fromItem)) continue;
                        int maxSize = Math.min(toItem.func_77976_d(), to.func_70297_j_());
                        int maxMove = Math.min(maxSize - toItem.func_190916_E(), Math.min(maxTransfer, fromItem.func_190916_E()));
                        toItem.func_190917_f(maxMove);
                        fromItem.func_190918_g(maxMove);
                        if ((maxTransfer -= maxMove) == 0) {
                            return;
                        }
                        if (fromItem.func_190926_b()) break;
                    }
                }
                if (fromItem.func_190916_E() <= 0) continue;
                for (int toSlot : toSlots) {
                    toItem = to.func_70301_a(toSlot);
                    if (!toItem.func_190926_b() || !to.func_94041_b(toSlot, fromItem) || toSided != null && !toSided.func_180462_a(toSlot, fromItem, toSide)) continue;
                    toItem = fromItem.func_77946_l();
                    toItem.func_190920_e(Math.min(maxTransfer, fromItem.func_190916_E()));
                    to.func_70299_a(toSlot, toItem);
                    fromItem.func_190918_g(toItem.func_190916_E());
                    if ((maxTransfer -= toItem.func_190916_E()) == 0) {
                        return;
                    }
                    if (fromItem.func_190926_b()) continue block5;
                }
            }
        }
        finally {
            if (oldTransfer != maxTransfer) {
                to.func_70296_d();
                from.func_70296_d();
            }
        }
    }

    private void updateFuel() {
        int fuelLevel;
        ItemStack fuel;
        if (this.lastLit != this.lit) {
            this.lastLit = this.lit;
            this.sendDataToAllPlayers(DataType.LIT, this.players);
        }
        if (!(fuel = this.fuelSlot.func_75211_c()).func_190926_b() && this.fuelSlot.func_75214_a(fuel) && (fuelLevel = TileEntityFurnace.func_145952_a((ItemStack)fuel)) > 0 && fuelLevel + this.fuel <= this.maxFuel) {
            this.fuel += fuelLevel;
            if (fuel.func_77973_b().hasContainerItem(fuel)) {
                this.fuelSlot.func_75215_d(fuel.func_77973_b().getContainerItem(fuel).func_77946_l());
            } else {
                this.func_70298_a(this.fuelSlot.getSlotIndex(), 1);
            }
        }
        if (this.fuel > this.maxFuel) {
            this.fuel = this.maxFuel;
        }
    }

    public void onUpgradeChangeDistribute() {
        if (!this.field_145850_b.field_72995_K) {
            this.onUpgradeChange();
            this.field_145850_b.func_175685_c(this.field_174879_c, (Block)EngineersWorkshop.blockTable, true);
            this.sendToAllPlayers(PacketHandler.getPacket(this, PacketId.UPGRADE_CHANGE), this.players);
        } else {
            this.getUpgradePage().onUpgradeChange();
        }
    }

    public void onUpgradeChange() {
        this.reloadTransferSides();
        this.getUpgradePage().onUpgradeChange();
        this.getMainPage().getCraftingList().forEach(UnitCraft::onUpgradeChange);
    }

    public void onSideChange() {
        this.reloadTransferSides();
    }

    private void reloadTransferSides() {
        for (int i = 0; i < this.sideSlots.length; ++i) {
            for (SlotBase slot : this.slots) {
                slot.resetValidity(i);
            }
            ArrayList<SlotBase> slotsForSide = new ArrayList<SlotBase>();
            for (Setting setting : this.getTransferPage().getSettings()) {
                List<SlotBase> unitSlots;
                Transfer input = setting.getSides().get(i).getInput();
                Transfer output = setting.getSides().get(i).getOutput();
                if (!input.isEnabled() && !output.isEnabled() || (unitSlots = setting.getSlots()) == null) continue;
                slotsForSide.addAll(unitSlots);
                for (SlotBase unitSlot : unitSlots) {
                    boolean isSlotInput = input.isEnabled() && unitSlot.canAcceptItems();
                    boolean isSlotOutput = output.isEnabled() && unitSlot.canSupplyItems();
                    unitSlot.setValidity(i, isSlotInput ? input : null, isSlotOutput ? output : null);
                }
            }
            this.sideSlots[i] = this.getSlotIndexArray(slotsForSide);
        }
    }

    private int[] getSlotIndexArray(List<SlotBase> slots) {
        int[] result = new int[slots.size()];
        for (int j = 0; j < slots.size(); ++j) {
            result[j] = slots.get(j).getSlotIndex();
        }
        return result;
    }

    public boolean func_94041_b(int id, ItemStack item) {
        return this.slots.get(id).func_75214_a(item);
    }

    public boolean func_180462_a(int slot, ItemStack item, EnumFacing side) {
        return this.func_94041_b(slot, item) && this.slots.get(slot).canAcceptItem(item) && this.slots.get(slot).isInputValid(side.ordinal(), item);
    }

    public boolean func_180461_b(int slot, ItemStack item, EnumFacing side) {
        return this.slots.get(slot).isOutputValid(side.ordinal(), item);
    }

    public GuiMenu getMenu() {
        return this.menu;
    }

    public void setMenu(GuiMenuItem menu) {
        this.menu = menu;
    }

    public boolean isLit() {
        return this.lit;
    }

    public void setLit(boolean lit) {
        this.lit = lit;
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_189515_b(nbt);
        return new SPacketUpdateTileEntity(this.func_174877_v(), 1, nbt);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74768_a(NBT_POWER, this.fuel);
        compound.func_74768_a(NBT_MAX_POWER, this.maxFuel);
        NBTTagList itemList = new NBTTagList();
        for (int i = 0; i < this.items.size(); ++i) {
            if (((ItemStack)this.items.get(i)).func_190926_b()) continue;
            NBTTagCompound slotTag = ((ItemStack)this.items.get(i)).func_77955_b(new NBTTagCompound());
            slotTag.func_74768_a(NBT_SLOT, i);
            itemList.func_74742_a((NBTBase)slotTag);
        }
        compound.func_74782_a(NBT_ITEMS, (NBTBase)itemList);
        NBTTagList unitList = new NBTTagList();
        for (Unit unit : this.getMainPage().getUnits()) {
            unitList.func_74742_a((NBTBase)unit.writeToNBT(new NBTTagCompound()));
        }
        compound.func_74782_a(NBT_UNITS, (NBTBase)unitList);
        NBTTagList settingList = new NBTTagList();
        for (Setting setting : this.getTransferPage().getSettings()) {
            NBTTagCompound settingCompound = new NBTTagCompound();
            NBTTagList sideList = new NBTTagList();
            for (Side side : setting.getSides()) {
                NBTTagCompound sideCompound = new NBTTagCompound();
                NBTTagCompound inputCompound = new NBTTagCompound();
                NBTTagCompound outputCompound = new NBTTagCompound();
                side.getInput().writeToNBT(inputCompound);
                side.getOutput().writeToNBT(outputCompound);
                sideCompound.func_74782_a(NBT_INPUT, (NBTBase)inputCompound);
                sideCompound.func_74782_a(NBT_OUTPUT, (NBTBase)outputCompound);
                sideList.func_74742_a((NBTBase)sideCompound);
            }
            settingCompound.func_74782_a(NBT_SIDES, (NBTBase)sideList);
            settingList.func_74742_a((NBTBase)settingCompound);
        }
        compound.func_74782_a(NBT_SETTINGS, (NBTBase)settingList);
        return super.func_189515_b(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.fuel = compound.func_74762_e(NBT_POWER);
        this.maxFuel = compound.func_74762_e(NBT_MAX_POWER);
        this.items = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        NBTTagList itemList = compound.func_150295_c(NBT_ITEMS, 10);
        for (int i = 0; i < itemList.func_74745_c(); ++i) {
            NBTTagCompound slotCompound = itemList.func_150305_b(i);
            int id = slotCompound.func_74762_e(NBT_SLOT);
            if (id < 0) {
                id += 256;
            }
            if (id < 0 || id >= this.items.size()) continue;
            this.items.set(id, (Object)new ItemStack(slotCompound));
        }
        NBTTagList unitList = compound.func_150295_c(NBT_UNITS, 10);
        List<Unit> units = this.getMainPage().getUnits();
        for (int i = 0; i < units.size(); ++i) {
            Unit unit = units.get(i);
            NBTTagCompound unitCompound = unitList.func_150305_b(i);
            unit.readFromNBT(unitCompound);
        }
        NBTTagList settingList = compound.func_150295_c(NBT_SETTINGS, 10);
        List<Setting> settings = this.getTransferPage().getSettings();
        for (int i = 0; i < settings.size(); ++i) {
            Setting setting = settings.get(i);
            NBTTagCompound settingCompound = settingList.func_150305_b(i);
            NBTTagList sideList = settingCompound.func_150295_c(NBT_SIDES, 10);
            List<Side> sides = setting.getSides();
            for (int j = 0; j < sides.size(); ++j) {
                Side side = sides.get(j);
                NBTTagCompound sideCompound = sideList.func_150305_b(j);
                NBTTagCompound inputCompound = sideCompound.func_74775_l(NBT_INPUT);
                NBTTagCompound outputCompound = sideCompound.func_74775_l(NBT_OUTPUT);
                side.getInput().readFromNBT(inputCompound);
                side.getOutput().readFromNBT(outputCompound);
            }
        }
    }

    public void spitOutItem(ItemStack item) {
        float offsetZ;
        float offsetY = offsetZ = this.field_145850_b.field_73012_v.nextFloat() * 0.8f + 1.0f;
        float offsetX = offsetZ;
        EntityItem entityItem = new EntityItem(this.field_145850_b, (double)((float)this.field_174879_c.func_177958_n() + offsetX), (double)((float)this.field_174879_c.func_177956_o() + offsetY), (double)((float)this.field_174879_c.func_177952_p() + offsetZ), item.func_77946_l());
        entityItem.field_70159_w = this.field_145850_b.field_73012_v.nextGaussian() * (double)0.05f;
        entityItem.field_70181_x = this.field_145850_b.field_73012_v.nextGaussian() * (double)0.05f + (double)0.2f;
        entityItem.field_70179_y = this.field_145850_b.field_73012_v.nextGaussian() * (double)0.05f;
        this.field_145850_b.func_72838_d((Entity)entityItem);
    }

    public void clearGridSend(int id) {
        DataPacket dw = PacketHandler.getPacket(this, PacketId.CLEAR);
        dw.createCompound().func_74768_a("clear", id);
        PacketHandler.sendToServer(dw);
    }

    private void clearGrid(EntityPlayer player, int id) {
        UnitCraft crafting = this.getMainPage().getCraftingList().get(id);
        if (crafting.isEnabled()) {
            int i;
            int[] from = new int[9];
            for (int i2 = 0; i2 < from.length; ++i2) {
                from[i2] = crafting.getGridId() + i2;
            }
            int[] to = new int[player.field_71071_by.field_70462_a.size()];
            for (i = 0; i < to.length; ++i) {
                to[i] = i;
            }
            for (i = 0; i < 9; ++i) {
                ItemStack fromCrafting = crafting.getSlots().get(i).func_75211_c();
                if (fromCrafting.func_190926_b()) continue;
                player.field_71071_by.func_70441_a(fromCrafting);
            }
        }
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return false;
    }

    public String func_70005_c_() {
        return "Production Table";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int[] func_180463_a(EnumFacing side) {
        return this.sideSlots[side.ordinal()];
    }

    @Nonnull
    public ItemStack func_70304_b(int index) {
        return this.slots.get(index).func_75211_c().func_77946_l();
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }
}

