/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.gui.tree;

import com.feed_the_beast.ftblib.lib.gui.BlankPanel;
import com.feed_the_beast.ftblib.lib.gui.Button;
import com.feed_the_beast.ftblib.lib.gui.ColorWidget;
import com.feed_the_beast.ftblib.lib.gui.ContextMenuItem;
import com.feed_the_beast.ftblib.lib.gui.Panel;
import com.feed_the_beast.ftblib.lib.gui.SimpleButton;
import com.feed_the_beast.ftblib.lib.gui.TextField;
import com.feed_the_beast.ftblib.lib.gui.Theme;
import com.feed_the_beast.ftblib.lib.gui.Widget;
import com.feed_the_beast.ftblib.lib.gui.WidgetLayout;
import com.feed_the_beast.ftblib.lib.gui.WidgetVerticalSpace;
import com.feed_the_beast.ftblib.lib.gui.misc.CompactGridLayout;
import com.feed_the_beast.ftblib.lib.icon.Color4I;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftblib.lib.util.StringJoiner;
import com.feed_the_beast.ftblib.lib.util.StringUtils;
import com.feed_the_beast.ftblib.lib.util.misc.MouseButton;
import com.feed_the_beast.ftbquests.gui.tree.ButtonAddReward;
import com.feed_the_beast.ftbquests.gui.tree.ButtonAddTask;
import com.feed_the_beast.ftbquests.gui.tree.ButtonCloseViewQuest;
import com.feed_the_beast.ftbquests.gui.tree.ButtonOpenInGuide;
import com.feed_the_beast.ftbquests.gui.tree.ButtonPinViewQuest;
import com.feed_the_beast.ftbquests.gui.tree.ButtonReward;
import com.feed_the_beast.ftbquests.gui.tree.ButtonTask;
import com.feed_the_beast.ftbquests.gui.tree.GuiQuestTree;
import com.feed_the_beast.ftbquests.gui.tree.TextFieldDisabledButton;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.QuestObject;
import com.feed_the_beast.ftbquests.quest.QuestObjectBase;
import com.feed_the_beast.ftbquests.quest.reward.Reward;
import com.feed_the_beast.ftbquests.quest.reward.RewardAutoClaim;
import com.feed_the_beast.ftbquests.quest.task.Task;
import com.feed_the_beast.ftbquests.quest.theme.QuestTheme;
import com.feed_the_beast.ftbquests.quest.theme.property.ThemeProperties;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;

public class PanelViewQuest
extends Panel {
    public final GuiQuestTree gui;
    public Quest quest = null;
    public boolean hidePanel = false;
    private String title = "";
    private Icon icon = Icon.EMPTY;
    public Button buttonClose;
    public Button buttonOnScreen;
    public Button buttonOpenDependencies;
    public Button buttonOpenDependants;
    public BlankPanel panelContent;
    public BlankPanel panelTasks;
    public BlankPanel panelRewards;
    public BlankPanel panelText;

    public PanelViewQuest(GuiQuestTree g) {
        super((Panel)g);
        this.gui = g;
        this.setPosAndSize(-1, -1, 0, 0);
        this.setOnlyRenderWidgetsInside(true);
        this.setOnlyInteractWithWidgetsInside(true);
    }

    public void addWidgets() {
        boolean showText;
        Object b;
        this.setPosAndSize(-1, -1, 1, 1);
        if (this.quest == null || this.hidePanel) {
            return;
        }
        QuestObjectBase prev = QuestTheme.currentObject;
        QuestTheme.currentObject = this.quest;
        this.setScrollX(0.0);
        this.setScrollY(0.0);
        this.title = this.quest.getTitle();
        this.icon = this.quest.getIcon();
        int w = Math.max(200, this.gui.getTheme().getStringWidth(this.title) + 50);
        this.panelContent = new BlankPanel((Panel)this, "ContentPanel");
        this.add((Widget)this.panelContent);
        this.panelTasks = new BlankPanel((Panel)this.panelContent, "TasksPanel");
        this.panelContent.add((Widget)this.panelTasks);
        this.panelRewards = new BlankPanel((Panel)this.panelContent, "RewardsPanel");
        this.panelContent.add((Widget)this.panelRewards);
        this.panelText = new BlankPanel((Panel)this.panelContent, "TextPanel");
        this.panelContent.add((Widget)this.panelText);
        boolean canEdit = this.gui.file.canEdit();
        int bsize = 18;
        for (Task task : this.quest.tasks) {
            b = new ButtonTask((Panel)this.panelTasks, task);
            this.panelTasks.add((Widget)b);
            b.setSize(bsize, bsize);
        }
        if (!canEdit && this.panelTasks.widgets.isEmpty()) {
            Object noTasks = new TextFieldDisabledButton((Panel)this.panelTasks, I18n.func_135052_a((String)"ftbquests.gui.no_tasks", (Object[])new Object[0]));
            noTasks.setSize(((TextFieldDisabledButton)((Object)noTasks)).width + 8, bsize);
            noTasks.setColor((Color4I)ThemeProperties.DISABLED_TEXT_COLOR.get(this.quest));
            this.panelTasks.add(noTasks);
        }
        for (Reward reward : this.quest.rewards) {
            if (!canEdit && reward.getAutoClaimType() == RewardAutoClaim.INVISIBLE) continue;
            b = new ButtonReward((Panel)this.panelRewards, reward);
            this.panelRewards.add((Widget)b);
            b.setSize(bsize, bsize);
        }
        if (!canEdit && this.panelRewards.widgets.isEmpty()) {
            TextFieldDisabledButton noRewards = new TextFieldDisabledButton((Panel)this.panelRewards, I18n.func_135052_a((String)"ftbquests.gui.no_rewards", (Object[])new Object[0]));
            noRewards.setSize(noRewards.width + 8, bsize);
            noRewards.setColor((Color4I)ThemeProperties.DISABLED_TEXT_COLOR.get(this.quest));
            this.panelRewards.add((Widget)noRewards);
        }
        if (this.gui.file.canEdit()) {
            this.panelTasks.add((Widget)new ButtonAddTask((Panel)this.panelTasks, this.quest));
            this.panelRewards.add((Widget)new ButtonAddReward((Panel)this.panelRewards, this.quest));
        }
        Color4I borderColor = (Color4I)ThemeProperties.WIDGET_BORDER.get(this.gui.selectedChapter);
        int ww = 0;
        for (Widget widget2 : this.panelTasks.widgets) {
            ww = Math.max(ww, widget2.width);
        }
        for (Widget widget2 : this.panelRewards.widgets) {
            ww = Math.max(ww, widget2.width);
        }
        ww = MathHelper.func_76125_a((int)ww, (int)70, (int)140);
        w = Math.max(w, ww * 2 + 10);
        w = Math.max(w, this.quest.minWidth);
        if ((Integer)ThemeProperties.FULL_SCREEN_QUEST.get(this.quest) == 1) {
            w = this.gui.width - 1;
        }
        if (w % 2 == 0) {
            ++w;
        }
        this.setWidth(w);
        this.panelContent.setPosAndSize(0, 16, w, 0);
        int w2 = this.panelContent.width / 2;
        this.buttonClose = new ButtonCloseViewQuest(this);
        this.add((Widget)this.buttonClose);
        this.buttonClose.setPosAndSize(w - 14, 2, 12, 12);
        this.buttonOnScreen = new ButtonPinViewQuest(this);
        this.add((Widget)this.buttonOnScreen);
        this.buttonOnScreen.setPosAndSize(w - 26, 2, 12, 12);
        if (this.quest.dependencies.isEmpty()) {
            this.buttonOpenDependencies = new SimpleButton((Panel)this, I18n.func_135052_a((String)"ftbquests.gui.no_dependencies", (Object[])new Object[0]), Icon.getIcon((String)"ftbquests:textures/gui/arrow_left.png").withTint(borderColor), (widget, button) -> {});
            this.add((Widget)this.buttonOpenDependencies);
        } else {
            this.buttonOpenDependencies = new SimpleButton((Panel)this, I18n.func_135052_a((String)"ftbquests.gui.view_dependencies", (Object[])new Object[0]), Icon.getIcon((String)"ftbquests:textures/gui/arrow_left.png").withTint(borderColor), (widget, button) -> this.showList(this.quest.dependencies));
            this.add((Widget)this.buttonOpenDependencies);
        }
        if (this.quest.getDependants().isEmpty()) {
            this.buttonOpenDependants = new SimpleButton((Panel)this, I18n.func_135052_a((String)"ftbquests.gui.no_dependants", (Object[])new Object[0]), Icon.getIcon((String)"ftbquests:textures/gui/arrow_right.png").withTint(borderColor), (widget, button) -> {});
            this.add((Widget)this.buttonOpenDependants);
        } else {
            this.buttonOpenDependants = new SimpleButton((Panel)this, I18n.func_135052_a((String)"ftbquests.gui.view_dependants", (Object[])new Object[0]), Icon.getIcon((String)"ftbquests:textures/gui/arrow_right.png").withTint(borderColor), (widget, button) -> this.showList(this.quest.getDependants()));
            this.add((Widget)this.buttonOpenDependants);
        }
        this.buttonOpenDependencies.setPosAndSize(0, 17, 13, 13);
        this.buttonOpenDependants.setPosAndSize(w - 13, 17, 13, 13);
        TextField textFieldTasks = new TextField((Panel)this.panelContent){

            public TextField resize(Theme theme) {
                return this;
            }
        };
        textFieldTasks.setPosAndSize(2, 2, w2 - 3, 13);
        textFieldTasks.addFlags(36);
        textFieldTasks.setText(I18n.func_135052_a((String)"ftbquests.tasks", (Object[])new Object[0]));
        textFieldTasks.setColor((Color4I)ThemeProperties.TASKS_TEXT_COLOR.get(this.quest));
        this.panelContent.add((Widget)textFieldTasks);
        TextField textFieldRewards = new TextField((Panel)this.panelContent){

            public TextField resize(Theme theme) {
                return this;
            }
        };
        textFieldRewards.setPosAndSize(w2 + 2, 2, w2 - 3, 13);
        textFieldRewards.addFlags(36);
        textFieldRewards.setText(I18n.func_135052_a((String)"ftbquests.rewards", (Object[])new Object[0]));
        textFieldRewards.setColor((Color4I)ThemeProperties.REWARDS_TEXT_COLOR.get(this.quest));
        this.panelContent.add((Widget)textFieldRewards);
        this.panelTasks.setPosAndSize(2, 16, w2 - 3, 0);
        this.panelRewards.setPosAndSize(w2 + 2, 16, w2 - 3, 0);
        int at = this.panelTasks.align((WidgetLayout)new CompactGridLayout(bsize + 2));
        int ar = this.panelRewards.align((WidgetLayout)new CompactGridLayout(bsize + 2));
        int h = Math.max(at, ar);
        this.panelTasks.setHeight(h);
        this.panelRewards.setHeight(h);
        int tox = (this.panelTasks.width - this.panelTasks.getContentWidth()) / 2;
        int rox = (this.panelRewards.width - this.panelRewards.getContentWidth()) / 2;
        int toy = (this.panelTasks.height - this.panelTasks.getContentHeight()) / 2;
        int roy = (this.panelRewards.height - this.panelRewards.getContentHeight()) / 2;
        for (Widget widget3 : this.panelTasks.widgets) {
            widget3.setX(widget3.posX + tox);
            widget3.setY(widget3.posY + toy);
        }
        for (Widget widget3 : this.panelRewards.widgets) {
            widget3.setX(widget3.posX + rox);
            widget3.setY(widget3.posY + roy);
        }
        this.panelText.setPosAndSize(3, 16 + h + 12, this.panelContent.width - 6, 0);
        String desc = this.quest.getSubtitle();
        if (!desc.isEmpty()) {
            this.panelText.add((Widget)new TextField((Panel)this.panelText).addFlags(4).setMaxWidth(this.panelText.width).setSpacing(9).setText(TextFormatting.ITALIC + TextFormatting.GRAY.toString() + desc));
        }
        boolean bl = showText = !this.quest.hideTextUntilComplete || this.gui.file.self != null && this.quest.isComplete(this.gui.file.self);
        if (showText && this.quest.getDescription().length > 0) {
            if (!desc.isEmpty()) {
                this.panelText.add((Widget)new WidgetVerticalSpace((Panel)this.panelText, 7));
            }
            this.panelText.add((Widget)new TextField((Panel)this.panelText).setMaxWidth(this.panelText.width).setSpacing(9).setText(StringUtils.addFormatting((String)StringJoiner.with((char)'\n').joinStrings(this.quest.getDescription()))));
        }
        if (showText && !this.quest.guidePage.isEmpty()) {
            if (!desc.isEmpty()) {
                this.panelText.add((Widget)new WidgetVerticalSpace((Panel)this.panelText, 7));
            }
            this.panelText.add((Widget)new ButtonOpenInGuide((Panel)this.panelText, this.quest));
        }
        if (this.panelText.widgets.isEmpty()) {
            this.panelContent.add(new ColorWidget((Panel)this.panelContent, borderColor, null).setPosAndSize(w2, 0, 1, h + 40));
            this.panelText.setHeight(0);
            this.setHeight(Math.min(this.panelContent.getContentHeight(), this.parent.height - 10));
        } else {
            this.panelContent.add(new ColorWidget((Panel)this.panelContent, borderColor, null).setPosAndSize(w2, 0, 1, 16 + h + 6));
            this.panelContent.add(new ColorWidget((Panel)this.panelContent, borderColor, null).setPosAndSize(1, 16 + h + 6, this.panelContent.width - 2, 1));
            this.panelText.setHeight(this.panelText.align((WidgetLayout)new WidgetLayout.Vertical(0, 0, 1)));
            this.setHeight(Math.min(this.panelContent.getContentHeight() + 20, this.parent.height - 10));
        }
        if ((Integer)ThemeProperties.FULL_SCREEN_QUEST.get(this.quest) == 1) {
            this.height = this.gui.height;
        }
        this.setPos((this.parent.width - this.width) / 2, (this.parent.height - this.height) / 2);
        this.panelContent.setHeight(this.height - 17);
        QuestTheme.currentObject = prev;
    }

    private void showList(Collection<QuestObject> c) {
        int hidden = 0;
        ArrayList<ContextMenuItem> contextMenu = new ArrayList<ContextMenuItem>();
        for (QuestObject object : c) {
            if (this.gui.file.canEdit() || object.isVisible(this.gui.file.self)) {
                contextMenu.add(new ContextMenuItem(object.getTitle(), (Icon)Icon.EMPTY, () -> this.gui.open(object, true)));
                continue;
            }
            ++hidden;
        }
        if (hidden > 0) {
            if (hidden == c.size()) {
                contextMenu.add(new ContextMenuItem(hidden + " hidden quests", (Icon)Icon.EMPTY, () -> {}).setEnabled(false));
            } else {
                contextMenu.add(new ContextMenuItem("+ " + hidden + " hidden quests", (Icon)Icon.EMPTY, () -> {}).setEnabled(false));
            }
        }
        this.getGui().openContextMenu(contextMenu);
    }

    public void alignWidgets() {
    }

    public void draw(Theme theme, int x, int y, int w, int h) {
        if (this.quest != null && !this.hidePanel) {
            QuestObjectBase prev = QuestTheme.currentObject;
            QuestTheme.currentObject = this.quest;
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)500.0f);
            super.draw(theme, x, y, w, h);
            GlStateManager.func_179121_F();
            QuestTheme.currentObject = prev;
        }
    }

    public void drawBackground(Theme theme, int x, int y, int w, int h) {
        Color4I borderColor = (Color4I)ThemeProperties.QUEST_VIEW_BORDER.get();
        Color4I.DARK_GRAY.withAlpha(120).draw(this.gui.getX(), this.gui.getY(), this.gui.width, this.gui.height);
        Icon background = (Icon)ThemeProperties.QUEST_VIEW_BACKGROUND.get();
        background.draw(x, y, w, h);
        theme.drawString(this.title, x + w / 2, y + 4, (Color4I)ThemeProperties.QUEST_VIEW_TITLE.get(), 4);
        this.icon.draw(x + 2, y + 2, 12, 12);
        borderColor.draw(x + 1, y + 15, w - 2, 1);
    }

    public boolean mousePressed(MouseButton button) {
        return super.mousePressed(button) || this.isMouseOver();
    }
}

