/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.quest;

import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.config.ConfigString;
import com.feed_the_beast.ftblib.lib.config.ConfigValue;
import com.feed_the_beast.ftblib.lib.icon.Color4I;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftblib.lib.io.DataIn;
import com.feed_the_beast.ftblib.lib.io.DataOut;
import com.feed_the_beast.ftbquests.net.edit.MessageEditObject;
import com.feed_the_beast.ftbquests.quest.Chapter;
import com.feed_the_beast.ftbquests.quest.Movable;
import com.feed_the_beast.ftbquests.quest.QuestShape;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class ChapterImage
implements Movable {
    public Chapter chapter;
    public double x;
    public double y;
    public double width;
    public double height;
    public double rotation;
    public Icon image;
    public List<String> hover;
    public String click;
    public boolean dev;

    public ChapterImage(Chapter c) {
        this.chapter = c;
        this.y = 0.0;
        this.x = 0.0;
        this.width = 1.0;
        this.height = 1.0;
        this.rotation = 0.0;
        this.image = Icon.getIcon((String)"minecraft:textures/gui/presets/isles.png");
        this.hover = new ArrayList<String>();
        this.click = "";
        this.dev = false;
    }

    public void writeData(NBTTagCompound nbt) {
        nbt.func_74780_a("x", this.x);
        nbt.func_74780_a("y", this.y);
        nbt.func_74780_a("width", this.width);
        nbt.func_74780_a("height", this.height);
        nbt.func_74780_a("rotation", this.rotation);
        nbt.func_74778_a("image", this.image.toString());
        NBTTagList hoverTag = new NBTTagList();
        for (String s : this.hover) {
            hoverTag.func_74742_a((NBTBase)new NBTTagString(s));
        }
        nbt.func_74782_a("hover", (NBTBase)hoverTag);
        nbt.func_74778_a("click", this.click);
        nbt.func_74757_a("dev", this.dev);
    }

    public void readData(NBTTagCompound nbt) {
        this.x = nbt.func_74769_h("x");
        this.y = nbt.func_74769_h("y");
        this.width = nbt.func_74769_h("width");
        this.height = nbt.func_74769_h("height");
        this.rotation = nbt.func_74769_h("rotation");
        this.image = Icon.getIcon((String)nbt.func_74779_i("image"));
        this.hover.clear();
        NBTTagList hoverTag = nbt.func_150295_c("hover", 8);
        for (int i = 0; i < hoverTag.func_74745_c(); ++i) {
            this.hover.add(hoverTag.func_150307_f(i));
        }
        this.click = nbt.func_74779_i("click");
        this.dev = nbt.func_74767_n("dev");
    }

    public void writeNetData(DataOut data) {
        data.writeDouble(this.x);
        data.writeDouble(this.y);
        data.writeDouble(this.width);
        data.writeDouble(this.height);
        data.writeDouble(this.rotation);
        data.writeIcon(this.image);
        data.writeCollection(this.hover, DataOut.STRING);
        data.writeString(this.click);
        data.writeBoolean(this.dev);
    }

    public void readNetData(DataIn data) {
        this.x = data.readDouble();
        this.y = data.readDouble();
        this.width = data.readDouble();
        this.height = data.readDouble();
        this.rotation = data.readDouble();
        this.image = data.readIcon();
        data.readCollection(this.hover, DataIn.STRING);
        this.click = data.readString();
        this.dev = data.readBoolean();
    }

    @SideOnly(value=Side.CLIENT)
    public void getConfig(ConfigGroup config) {
        config.addDouble("x", () -> this.x, v -> {
            this.x = v;
        }, 0.0, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        config.addDouble("y", () -> this.y, v -> {
            this.y = v;
        }, 0.0, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        config.addDouble("width", () -> this.width, v -> {
            this.width = v;
        }, 1.0, 0.0, Double.POSITIVE_INFINITY);
        config.addDouble("height", () -> this.height, v -> {
            this.height = v;
        }, 1.0, 0.0, Double.POSITIVE_INFINITY);
        config.addDouble("rotation", () -> this.rotation, v -> {
            this.rotation = v;
        }, 0.0, -180.0, 180.0);
        config.addString("image", () -> this.image.toString(), v -> {
            this.image = Icon.getIcon((String)v);
        }, "minecraft:textures/gui/presets/isles.png");
        config.addList("hover", this.hover, (ConfigValue)new ConfigString(""), ConfigString::new, ConfigString::getString);
        config.addString("click", () -> this.click, v -> {
            this.click = v;
        }, "");
        config.addBool("dev", () -> this.dev, v -> {
            this.dev = v;
        }, false);
    }

    @Override
    public Chapter getChapter() {
        return this.chapter;
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public double getY() {
        return this.y;
    }

    @Override
    public double getWidth() {
        return this.width;
    }

    @Override
    public double getHeight() {
        return this.height;
    }

    @Override
    public String getShape() {
        return "square";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void move(Chapter to, double _x, double _y) {
        this.x = _x;
        this.y = _y;
        if (to != this.chapter) {
            this.chapter.images.remove(this);
            new MessageEditObject(this.chapter).sendToServer();
            this.chapter = to;
            this.chapter.images.add(this);
        }
        new MessageEditObject(this.chapter).sendToServer();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawMoved() {
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)0.5, (double)0.5, (double)0.0);
        GlStateManager.func_179114_b((float)((float)this.rotation), (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179139_a((double)0.5, (double)0.5, (double)1.0);
        this.image.withColor(Color4I.WHITE.withAlpha(50)).draw(-1, -1, 2, 2);
        GlStateManager.func_179121_F();
        QuestShape.get((String)this.getShape()).outline.withColor(Color4I.WHITE.withAlpha(30)).draw(0, 0, 1, 1);
    }
}

