/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.quest.task;

import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.io.DataIn;
import com.feed_the_beast.ftblib.lib.io.DataOut;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.QuestData;
import com.feed_the_beast.ftbquests.quest.task.BooleanTaskData;
import com.feed_the_beast.ftbquests.quest.task.FTBQuestsTasks;
import com.feed_the_beast.ftbquests.quest.task.Task;
import com.feed_the_beast.ftbquests.quest.task.TaskData;
import com.feed_the_beast.ftbquests.quest.task.TaskType;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BiomeTask
extends Task {
    public Biome biome = null;

    public BiomeTask(Quest quest) {
        super(quest);
    }

    @Override
    public TaskType getType() {
        return FTBQuestsTasks.BIOME;
    }

    @Override
    public void writeData(NBTTagCompound nbt) {
        super.writeData(nbt);
        if (this.biome != null) {
            nbt.func_74778_a("biome", this.biome.getRegistryName().toString());
        }
    }

    @Override
    public void readData(NBTTagCompound nbt) {
        super.readData(nbt);
        this.biome = nbt.func_74764_b("biome") ? (Biome)Biome.field_185377_q.func_82594_a((Object)new ResourceLocation(nbt.func_74779_i("biome"))) : null;
    }

    @Override
    public void writeNetData(DataOut data) {
        super.writeNetData(data);
        data.writeResourceLocation(this.biome.getRegistryName());
    }

    @Override
    public void readNetData(DataIn data) {
        super.readNetData(data);
        this.biome = (Biome)Biome.field_185377_q.func_82594_a((Object)data.readResourceLocation());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addString("biome", () -> this.biome == null ? "" : this.biome.getRegistryName().toString(), v -> {
            this.biome = v.isEmpty() ? null : (Biome)Biome.field_185377_q.func_82594_a((Object)new ResourceLocation(v));
        }, "").setDisplayName((ITextComponent)new TextComponentTranslation("ftbquests.task.ftbquests.biome", new Object[0]));
    }

    @Override
    public String getAltTitle() {
        return I18n.func_135052_a((String)"ftbquests.task.ftbquests.biome", (Object[])new Object[0]) + ": " + TextFormatting.DARK_GREEN + (this.biome == null ? "null" : this.biome.getRegistryName());
    }

    @Override
    public int autoSubmitOnPlayerTick() {
        return 20;
    }

    @Override
    public TaskData createData(QuestData data) {
        return new Data(this, data);
    }

    public static class Data
    extends BooleanTaskData<BiomeTask> {
        private Data(BiomeTask task, QuestData data) {
            super(task, data);
        }

        @Override
        public boolean canSubmit(EntityPlayerMP player) {
            return player.field_70170_p.func_180494_b(player.func_180425_c()) == ((BiomeTask)this.task).biome && !player.func_175149_v();
        }
    }
}

