/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.quest.task;

import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.io.DataIn;
import com.feed_the_beast.ftblib.lib.io.DataOut;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.QuestData;
import com.feed_the_beast.ftbquests.quest.task.BooleanTaskData;
import com.feed_the_beast.ftbquests.quest.task.FTBQuestsTasks;
import com.feed_the_beast.ftbquests.quest.task.Task;
import com.feed_the_beast.ftbquests.quest.task.TaskData;
import com.feed_the_beast.ftbquests.quest.task.TaskType;
import com.feed_the_beast.ftbquests.util.RayMatcher;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class InteractionTask
extends Task {
    public final RayMatcher matcher = new RayMatcher();

    public InteractionTask(Quest quest) {
        super(quest);
    }

    @Override
    public TaskType getType() {
        return FTBQuestsTasks.INTERACTION;
    }

    @Override
    public void writeData(NBTTagCompound nbt) {
        super.writeData(nbt);
        this.matcher.writeData(nbt);
    }

    @Override
    public void readData(NBTTagCompound nbt) {
        super.readData(nbt);
        this.matcher.readData(nbt);
    }

    @Override
    public void writeNetData(DataOut data) {
        super.writeNetData(data);
        this.matcher.writeNetData(data);
    }

    @Override
    public void readNetData(DataIn data) {
        super.readNetData(data);
        this.matcher.readNetData(data);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addEnum("type", () -> this.matcher.type, v -> {
            this.matcher.type = v;
        }, RayMatcher.Type.NAME_MAP);
        config.addString("match", () -> this.matcher.match, v -> {
            this.matcher.match = v;
        }, "");
        config.addString("properties", this.matcher::getPropertyString, this.matcher::setPropertyString, "");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onButtonClicked(boolean canClick) {
    }

    @Override
    public TaskData createData(QuestData data) {
        return new BooleanTaskData<InteractionTask>(this, data);
    }
}

