/*
 * Decompiled with CFR 0.152.
 */
package com.fredtargaryen.floocraft.entity;

import com.fredtargaryen.floocraft.network.ChunkManager;
import com.fredtargaryen.floocraft.network.PacketHandler;
import com.fredtargaryen.floocraft.network.messages.MessageEndPeek;
import com.fredtargaryen.floocraft.network.messages.MessagePlayerIDRequest;
import java.util.UUID;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class EntityPeeker
extends Entity {
    private UUID playerUUID;
    private ResourceLocation texture;
    private boolean sentRequest;

    public EntityPeeker(World w) {
        super(w);
        this.func_70105_a(0.5f, 0.5f);
        this.field_70178_ae = true;
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.texture = null;
        this.sentRequest = false;
    }

    public UUID getPlayerUUID() {
        return this.playerUUID;
    }

    public void setPeekerData(EntityPlayerMP player, BlockPos spawnPos, EnumFacing direction) {
        BlockPos landPos = spawnPos.func_177972_a(direction);
        float x = (float)landPos.func_177958_n() + 0.5f;
        float y = landPos.func_177956_o();
        float z = (float)landPos.func_177952_p() + 0.5f;
        switch (direction) {
            case NORTH: {
                z += 0.5f;
                break;
            }
            case SOUTH: {
                z -= 0.5f;
                break;
            }
            case EAST: {
                x -= 0.5f;
                break;
            }
            default: {
                x = (float)((double)x + 0.5);
            }
        }
        this.playerUUID = player.getPersistentID();
        this.func_70012_b(x, y, z, this.getYawFromDirection(direction), 0.0f);
    }

    public void setPlayerUUID(UUID uuid) {
        this.playerUUID = uuid;
    }

    private float getYawFromDirection(EnumFacing ef) {
        switch (ef) {
            case NORTH: {
                return 180.0f;
            }
            case EAST: {
                return -90.0f;
            }
            case SOUTH: {
                return 0.0f;
            }
        }
        return 90.0f;
    }

    public void func_70106_y() {
        super.func_70106_y();
        ChunkManager.releaseTicket(this);
        MinecraftForge.EVENT_BUS.unregister((Object)this);
    }

    protected void func_70088_a() {
    }

    public void func_70030_z() {
        EntityPlayer player;
        if (!this.field_70170_p.field_72995_K && ((player = this.field_70170_p.func_152378_a(this.playerUUID)) == null || player.field_70128_L)) {
            this.func_70106_y();
        }
    }

    public ResourceLocation getTexture() {
        if (this.playerUUID == null) {
            if (this.field_70170_p.field_72995_K && !this.sentRequest) {
                MessagePlayerIDRequest mpidr = new MessagePlayerIDRequest();
                mpidr.peekerUUID = this.func_110124_au();
                PacketHandler.INSTANCE.sendToServer((IMessage)mpidr);
            }
            return null;
        }
        if (this.texture == null && this.field_70170_p.field_72995_K) {
            this.texture = ((AbstractClientPlayer)this.field_70170_p.func_152378_a(this.playerUUID)).func_110306_p();
        }
        return this.texture;
    }

    protected void func_70037_a(NBTTagCompound compound) {
        this.playerUUID = new UUID(compound.func_74763_f("msb"), compound.func_74763_f("lsb"));
        this.func_70101_b(compound.func_74760_g("yaw"), 0.0f);
    }

    protected void func_70014_b(NBTTagCompound compound) {
        compound.func_74772_a("msb", this.playerUUID.getMostSignificantBits());
        compound.func_74772_a("lsb", this.playerUUID.getLeastSignificantBits());
        compound.func_74776_a("yaw", this.field_70177_z);
    }

    @SubscribeEvent
    public void onHurt(LivingHurtEvent lhe) {
        UUID hurtEntityUUID;
        if (this.field_70170_p != null && this.field_70170_p.field_72995_K && this.playerUUID != null && (hurtEntityUUID = lhe.getEntity().func_110124_au()).equals(this.playerUUID)) {
            MessageEndPeek mep = new MessageEndPeek();
            mep.peekerUUID = this.func_110124_au();
            PacketHandler.INSTANCE.sendToServer((IMessage)mep);
        }
    }

    @SubscribeEvent
    public void onDeath(LivingDeathEvent lde) {
        if (this.field_70170_p != null && this.field_70170_p.field_72995_K && this.playerUUID != null && lde.getEntity().func_110124_au().equals(this.playerUUID)) {
            MessageEndPeek mep = new MessageEndPeek();
            mep.peekerUUID = this.func_110124_au();
            PacketHandler.INSTANCE.sendToServer((IMessage)mep);
        }
    }
}

