/*
 * Decompiled with CFR 0.152.
 */
package com.fredtargaryen.floocraft.network;

import com.fredtargaryen.floocraft.FloocraftBase;
import com.fredtargaryen.floocraft.entity.EntityPeeker;
import java.util.HashMap;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;

public class ChunkManager {
    private static HashMap<EntityPeeker, ForgeChunkManager.Ticket> tickets = new HashMap();

    public static boolean loadChunks(World world, BlockPos dest, EntityPeeker ep, EnumFacing direction) {
        int maxZ;
        int maxX;
        ChunkPos cp = new ChunkPos(dest);
        switch (direction) {
            case NORTH: {
                int minX = cp.field_77276_a - 1;
                int minZ = cp.field_77275_b;
                maxX = cp.field_77276_a + 1;
                maxZ = cp.field_77275_b + 1;
                break;
            }
            case SOUTH: {
                int minX = cp.field_77276_a - 1;
                int minZ = cp.field_77275_b - 1;
                maxX = cp.field_77276_a + 1;
                maxZ = cp.field_77275_b;
                break;
            }
            case EAST: {
                int minX = cp.field_77276_a;
                int minZ = cp.field_77275_b - 1;
                maxX = cp.field_77276_a + 1;
                maxZ = cp.field_77275_b + 1;
                break;
            }
            default: {
                int minX = cp.field_77276_a - 1;
                int minZ = cp.field_77275_b - 1;
                maxX = cp.field_77276_a;
                maxZ = cp.field_77275_b + 1;
            }
        }
        ChunkPos[] chunks = new ChunkPos[6];
        int index = 0;
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                chunks[index++] = new ChunkPos(x, z);
            }
        }
        ForgeChunkManager.Ticket t = ForgeChunkManager.requestTicket((Object)FloocraftBase.instance, (World)world, (ForgeChunkManager.Type)ForgeChunkManager.Type.ENTITY);
        if (t == null) {
            return false;
        }
        t.bindEntity((Entity)ep);
        tickets.put(ep, t);
        for (ChunkPos chunkPos : chunks) {
            ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)t, (ChunkPos)chunkPos);
        }
        return true;
    }

    public static void releaseTicket(EntityPeeker ep) {
        ForgeChunkManager.Ticket t = tickets.get((Object)ep);
        tickets.remove((Object)ep);
        ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)t);
    }

    public static void setCallback() {
        ForgeChunkManager.setForcedChunkLoadingCallback((Object)FloocraftBase.instance, (ForgeChunkManager.LoadingCallback)new ForgeChunkManager.LoadingCallback(){

            public void ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world) {
            }
        });
    }
}

