/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.api.network;

import net.minecraft.util.text.TextFormatting;
import sonar.fluxnetworks.api.translate.FluxTranslate;
import sonar.fluxnetworks.api.translate.Translation;

public enum AccessLevel {
    OWNER(FluxTranslate.OWNER, 0xFFAA00, TextFormatting.GOLD),
    ADMIN(FluxTranslate.ADMIN, 0x66CC00, TextFormatting.GREEN),
    USER(FluxTranslate.USER, 0x6699FF, TextFormatting.BLUE),
    NONE(FluxTranslate.BLOCKED, 0xA9A9A9, TextFormatting.GRAY),
    SUPER_ADMIN(FluxTranslate.SUPER_ADMIN, 4915330, TextFormatting.DARK_PURPLE);

    public Translation localization;
    public int color;
    public TextFormatting formatting;

    private AccessLevel(Translation localization, int color, TextFormatting formatting) {
        this.localization = localization;
        this.color = color;
        this.formatting = formatting;
    }

    public String getName() {
        return this.formatting + this.localization.t();
    }

    public int getColor() {
        return this.color;
    }

    public boolean canAccess() {
        return this != NONE;
    }

    public boolean canEdit() {
        return this.canAccess() && this != USER;
    }

    public boolean canDelete() {
        return this == OWNER || this == SUPER_ADMIN;
    }
}

