/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.api.network;

import java.util.EnumSet;
import java.util.Set;
import javax.annotation.Nonnull;
import sonar.fluxnetworks.api.tiles.IFluxConnector;
import sonar.fluxnetworks.api.tiles.IFluxController;
import sonar.fluxnetworks.api.tiles.IFluxPlug;
import sonar.fluxnetworks.api.tiles.IFluxPoint;
import sonar.fluxnetworks.api.tiles.IFluxStorage;

public enum FluxLogicType {
    ANY(IFluxConnector.class),
    PLUG(IFluxPlug.class),
    POINT(IFluxPoint.class),
    STORAGE(IFluxStorage.class),
    CONTROLLER(IFluxController.class);

    private final Class<? extends IFluxConnector> clazz;

    private FluxLogicType(Class<? extends IFluxConnector> clazz) {
        this.clazz = clazz;
    }

    @Nonnull
    public static Set<FluxLogicType> getValidTypes(IFluxConnector tile) {
        EnumSet<FluxLogicType> valid = EnumSet.noneOf(FluxLogicType.class);
        for (FluxLogicType type : FluxLogicType.values()) {
            if (!type.clazz.isInstance(tile)) continue;
            valid.add(type);
        }
        return valid;
    }
}

