/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.client.gui;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import sonar.fluxnetworks.FluxNetworks;
import sonar.fluxnetworks.api.gui.EnumNavigationTabs;
import sonar.fluxnetworks.api.network.NetworkSettings;
import sonar.fluxnetworks.api.translate.FluxTranslate;
import sonar.fluxnetworks.api.utils.NBTType;
import sonar.fluxnetworks.client.gui.basic.GuiButtonCore;
import sonar.fluxnetworks.client.gui.basic.GuiTabCore;
import sonar.fluxnetworks.client.gui.button.SlidedSwitchButton;
import sonar.fluxnetworks.client.gui.button.TextboxButton;
import sonar.fluxnetworks.common.handler.PacketHandler;
import sonar.fluxnetworks.common.network.PacketByteBuf;
import sonar.fluxnetworks.common.network.PacketNetworkUpdateRequest;
import sonar.fluxnetworks.common.network.PacketTile;
import sonar.fluxnetworks.common.network.PacketTileHandler;
import sonar.fluxnetworks.common.network.PacketTileType;
import sonar.fluxnetworks.common.tileentity.TileFluxCore;

public class GuiFluxConnectorHome
extends GuiTabCore {
    public TextboxButton fluxName;
    public TextboxButton priority;
    public TextboxButton limit;
    public SlidedSwitchButton surge;
    public SlidedSwitchButton disableLimit;
    public SlidedSwitchButton chunkLoad;
    private TileFluxCore tileEntity;
    private int timer;

    public GuiFluxConnectorHome(EntityPlayer player, TileFluxCore tileEntity) {
        super(player, tileEntity);
        this.tileEntity = tileEntity;
    }

    @Override
    public EnumNavigationTabs getNavigationTab() {
        return EnumNavigationTabs.TAB_HOME;
    }

    @Override
    protected void drawForegroundLayer(int mouseX, int mouseY) {
        super.drawForegroundLayer(mouseX, mouseY);
        this.renderNetwork(this.network.getSetting(NetworkSettings.NETWORK_NAME), this.network.getSetting(NetworkSettings.NETWORK_COLOR), 20, 8);
        this.renderTransfer(this.tileEntity, 0xFFFFFF, 30, 90);
        this.func_73732_a(this.field_146289_q, TextFormatting.RED + FluxNetworks.proxy.getFeedback(false).getInfo(), 89, 150, 0xFFFFFF);
        this.field_146289_q.func_78276_b(FluxTranslate.SURGE_MODE.t(), 20, 120, this.network.getSetting(NetworkSettings.NETWORK_COLOR).intValue());
        this.field_146289_q.func_78276_b(FluxTranslate.DISABLE_LIMIT.t(), 20, 132, this.network.getSetting(NetworkSettings.NETWORK_COLOR).intValue());
        if (!this.tileEntity.getConnectionType().isStorage()) {
            this.field_146289_q.func_78276_b(FluxTranslate.CHUNK_LOADING.t(), 20, 144, this.network.getSetting(NetworkSettings.NETWORK_COLOR).intValue());
        }
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.configureNavigationButtons(EnumNavigationTabs.TAB_HOME, this.navigationTabs);
        int color = this.network.getSetting(NetworkSettings.NETWORK_COLOR) | 0xFF000000;
        this.fluxName = TextboxButton.create(this, FluxTranslate.NAME.t() + ": ", 0, this.field_146289_q, 16, 28, 144, 12).setOutlineColor(color);
        this.fluxName.setMaxStringLength(24);
        this.fluxName.setText(this.tileEntity.getCustomName());
        this.priority = TextboxButton.create(this, FluxTranslate.PRIORITY.t() + ": ", 1, this.field_146289_q, 16, 45, 144, 12).setOutlineColor(color).setDigitsOnly();
        this.priority.setMaxStringLength(5);
        this.priority.setText(String.valueOf(this.tileEntity.priority));
        this.limit = TextboxButton.create(this, FluxTranslate.TRANSFER_LIMIT.t() + ": ", 2, this.field_146289_q, 16, 62, 144, 12).setOutlineColor(color).setDigitsOnly();
        this.limit.setMaxStringLength(9);
        this.limit.setText(String.valueOf(this.tileEntity.limit));
        this.surge = new SlidedSwitchButton(140, 120, 1, this.field_147003_i, this.field_147009_r, this.tileEntity.surgeMode);
        this.disableLimit = new SlidedSwitchButton(140, 132, 2, this.field_147003_i, this.field_147009_r, this.tileEntity.disableLimit);
        this.switches.add(this.surge);
        this.switches.add(this.disableLimit);
        if (!this.tileEntity.getConnectionType().isStorage()) {
            this.chunkLoad = new SlidedSwitchButton(140, 144, 3, this.field_147003_i, this.field_147009_r, this.tileEntity.chunkLoading);
            this.switches.add(this.chunkLoad);
        }
        this.textBoxes.add(this.fluxName);
        this.textBoxes.add(this.priority);
        this.textBoxes.add(this.limit);
    }

    @Override
    public void onTextBoxChanged(TextboxButton text) {
        if (text == this.fluxName) {
            this.tileEntity.customName = this.fluxName.getText();
            PacketHandler.network.sendToServer((IMessage)new PacketByteBuf.ByteBufMessage(this.tileEntity, this.tileEntity.func_174877_v(), 1));
        } else if (text == this.priority) {
            this.tileEntity.priority = this.priority.getIntegerFromText(false);
            PacketHandler.network.sendToServer((IMessage)new PacketByteBuf.ByteBufMessage(this.tileEntity, this.tileEntity.func_174877_v(), 2));
        } else if (text == this.limit) {
            this.tileEntity.limit = Math.min(this.limit.getLongFromText(true), this.tileEntity.getMaxTransferLimit());
            this.limit.setText(String.valueOf(this.tileEntity.limit));
            PacketHandler.network.sendToServer((IMessage)new PacketByteBuf.ByteBufMessage(this.tileEntity, this.tileEntity.func_174877_v(), 3));
        }
    }

    @Override
    public void onButtonClicked(GuiButtonCore button, int mouseX, int mouseY, int mouseButton) {
        super.onButtonClicked(button, mouseX, mouseY, mouseButton);
        if (mouseButton == 0 && button instanceof SlidedSwitchButton) {
            SlidedSwitchButton switchButton = (SlidedSwitchButton)button;
            switchButton.switchButton();
            switch (switchButton.id) {
                case 1: {
                    this.tileEntity.surgeMode = switchButton.slideControl;
                    PacketHandler.network.sendToServer((IMessage)new PacketByteBuf.ByteBufMessage(this.tileEntity, this.tileEntity.func_174877_v(), 4));
                    break;
                }
                case 2: {
                    this.tileEntity.disableLimit = switchButton.slideControl;
                    PacketHandler.network.sendToServer((IMessage)new PacketByteBuf.ByteBufMessage(this.tileEntity, this.tileEntity.func_174877_v(), 5));
                    break;
                }
                case 3: {
                    PacketHandler.network.sendToServer((IMessage)new PacketTile.TileMessage(PacketTileType.CHUNK_LOADING, PacketTileHandler.getChunkLoadPacket(switchButton.slideControl), this.tileEntity.func_174877_v(), this.tileEntity.func_145831_w().field_73011_w.getDimension()));
                }
            }
        }
    }

    @Override
    public void func_73876_c() {
        super.func_73876_c();
        if (this.timer == 0) {
            PacketHandler.network.sendToServer((IMessage)new PacketNetworkUpdateRequest.UpdateRequestMessage(this.network.getNetworkID(), NBTType.NETWORK_GENERAL));
        }
        if (this.timer % 4 == 0 && this.chunkLoad != null) {
            this.chunkLoad.slideControl = this.tileEntity.chunkLoading;
        }
        ++this.timer;
        this.timer %= 100;
    }
}

