/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.globe.client.render;

import com.google.common.collect.Iterables;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Random;
import java.util.UUID;
import me.ichun.mods.globe.client.core.EventHandlerClient;
import me.ichun.mods.globe.client.model.ModelGlobeStand;
import me.ichun.mods.globe.client.model.ModelStand;
import me.ichun.mods.globe.common.tileentity.TileEntityGlobeStand;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityOtherPlayerMP;
import net.minecraft.client.network.NetworkPlayerInfo;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.ReportedException;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class TileRendererGlobeStand
extends TileEntitySpecialRenderer<TileEntityGlobeStand> {
    public static final ResourceLocation txGlobeStand = new ResourceLocation("globe", "textures/model/stand.png");
    public static final ResourceLocation txStand = new ResourceLocation("globe", "textures/model/stand_actual.png");
    public static final ResourceLocation txSnow = new ResourceLocation("textures/environment/snow.png");
    public static MinecraftSessionService sessionService;
    public static int renderLevel;
    public static HashSet<Class<? extends TileEntity>> classesNotToRender;
    public static ModelGlobeStand modelGlobeStand;
    public static ModelStand modelStand;

    public void render(TileEntityGlobeStand gs, double px, double py, double pz, float partialTicks, int destroyStage, float alpha) {
        float f1;
        float f;
        int i;
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(px + 0.5), (double)(py + 0.5), (double)(pz + 0.5));
        if (gs != null) {
            i = gs.func_145831_w().func_175626_b(gs.func_174877_v(), 0);
            f = i & 0xFFFF;
            f1 = i >> 16;
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)f, (float)f1);
        }
        if (gs == null || gs.isStand) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)0.0, (double)-0.375, (double)0.0);
            GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)-1.0f);
            this.func_147499_a(txStand);
            modelStand.render(0.0625f);
            if (gs != null) {
                OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
            }
            TileRendererGlobeStand.modelStand.base1.func_78785_a(0.0625f);
            if (gs != null) {
                i = gs.func_145831_w().func_175626_b(gs.func_174877_v(), 0);
                f = i & 0xFFFF;
                f1 = i >> 16;
                OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)f, (float)f1);
            }
            GlStateManager.func_179121_F();
        }
        if (gs != null && gs.itemTag != null) {
            if (gs.isStand) {
                GlStateManager.func_179137_b((double)gs.disX, (double)(Math.sin(Math.toRadians(gs.prevBobProg + (gs.bobProg - gs.prevBobProg) * partialTicks)) * 0.05 + 0.05), (double)gs.disZ);
            } else {
                GlStateManager.func_179137_b((double)0.0, (double)-0.25, (double)0.0);
            }
            float rot = gs.prevRotation + (gs.rotation - gs.prevRotation) * partialTicks;
            GlStateManager.func_179114_b((float)rot, (float)0.0f, (float)1.0f, (float)0.0f);
            TileRendererGlobeStand.drawGlobe(gs.func_145831_w(), true, true, true, gs.itemTag, gs.renderingTiles, gs.renderingEnts, gs.func_174877_v(), gs.snowTime, gs.ticks, rot, partialTicks);
        }
        GlStateManager.func_179121_F();
    }

    public static void drawGlobe(World world, boolean drawBase, boolean drawGlass, boolean drawInternal, NBTTagCompound gsTag, HashMap<String, TileEntity> tileEntityMap, HashSet<Entity> entities, BlockPos gsPos, int snowTime, int ticks, float rotation, float partialTicks) {
        if (drawInternal && gsTag != null && gsTag.func_74762_e("radius") > 0 && renderLevel < 2) {
            ++renderLevel;
            GlStateManager.func_179094_E();
            int radius = gsTag.func_74762_e("radius");
            float scale = 0.05f * (3.0f / (float)radius);
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
            Minecraft mc = Minecraft.func_71410_x();
            float f = MathHelper.func_76131_a((float)(((float)snowTime - partialTicks) / 40.0f), (float)0.0f, (float)1.0f);
            if (f > 0.0f) {
                int i = 0;
                int j = 0;
                int k = 0;
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder bufferbuilder = tessellator.func_178180_c();
                GlStateManager.func_179129_p();
                GlStateManager.func_187432_a((float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179147_l();
                GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                GlStateManager.func_179092_a((int)516, (float)0.1f);
                int i1 = radius - 1;
                int i4 = (world.func_175626_b(gsPos, 0) * 3 + 0xF000F0) / 4;
                int j4 = i4 >> 16 & 0xFFFF;
                int k4 = i4 & 0xFFFF;
                for (int ll = 0; ll < 2; ++ll) {
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179114_b((float)(90.0f * (float)ll), (float)0.0f, (float)1.0f, (float)0.0f);
                    GlStateManager.func_179137_b((double)-0.5, (double)0.0, (double)-0.5);
                    int j1 = -1;
                    float f1 = (float)ticks + partialTicks;
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    for (int k1 = k - i1; k1 <= k + i1; ++k1) {
                        for (int l1 = i - i1; l1 <= i + i1; ++l1) {
                            double d3 = (double)radius * 0.5;
                            double d4 = (double)radius * 0.5;
                            int k2 = j - i1 - 1;
                            int l2 = j + i1 + 3;
                            Random rand = new Random(l1 * l1 * 3121 + l1 * 45238971 ^ k1 * k1 * 418711 + k1 * 13761);
                            if (j1 != 1) {
                                j1 = 1;
                                mc.func_110434_K().func_110577_a(txSnow);
                                bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181704_d);
                            }
                            double d8 = -((float)(mc.field_71441_e.func_72820_D() & 0x1FFL) + partialTicks) / 512.0f;
                            double d9 = rand.nextDouble() + (double)f1 * 0.01 * (double)((float)rand.nextGaussian());
                            double d10 = rand.nextDouble() + (double)(f1 * (float)rand.nextGaussian()) * 0.001;
                            double d11 = (float)l1 + 0.5f;
                            double d12 = (float)k1 + 0.5f;
                            float f6 = MathHelper.func_76133_a((double)(d11 * d11 + d12 * d12)) / (float)i1;
                            float f5 = ((1.0f - f6 * f6) * 0.3f + 0.5f) * f;
                            bufferbuilder.func_181662_b((double)l1 - d3 + 0.5, (double)l2, (double)k1 - d4 + 0.5).func_187315_a(0.0 + d9, (double)k2 * 0.25 + d8 + d10).func_181666_a(1.0f, 1.0f, 1.0f, f5).func_187314_a(j4, k4).func_181675_d();
                            bufferbuilder.func_181662_b((double)l1 + d3 + 0.5, (double)l2, (double)k1 + d4 + 0.5).func_187315_a(1.0 + d9, (double)k2 * 0.25 + d8 + d10).func_181666_a(1.0f, 1.0f, 1.0f, f5).func_187314_a(j4, k4).func_181675_d();
                            bufferbuilder.func_181662_b((double)l1 + d3 + 0.5, (double)k2, (double)k1 + d4 + 0.5).func_187315_a(1.0 + d9, (double)l2 * 0.25 + d8 + d10).func_181666_a(1.0f, 1.0f, 1.0f, f5).func_187314_a(j4, k4).func_181675_d();
                            bufferbuilder.func_181662_b((double)l1 - d3 + 0.5, (double)k2, (double)k1 - d4 + 0.5).func_187315_a(0.0 + d9, (double)l2 * 0.25 + d8 + d10).func_181666_a(1.0f, 1.0f, 1.0f, f5).func_187314_a(j4, k4).func_181675_d();
                        }
                    }
                    if (j1 >= 0) {
                        tessellator.func_78381_a();
                    }
                    GlStateManager.func_179121_F();
                }
                GlStateManager.func_179089_o();
                GlStateManager.func_179084_k();
                GlStateManager.func_179092_a((int)516, (float)0.1f);
            }
            for (int x = -radius; x <= radius; ++x) {
                for (int y = -radius; y <= radius; ++y) {
                    for (int z = -radius; z <= radius; ++z) {
                        StringBuilder sb = new StringBuilder().append("x").append(x).append("y").append(y).append("z").append(z);
                        String coord = sb.toString();
                        if (!gsTag.func_74764_b(coord)) continue;
                        NBTTagCompound tag = gsTag.func_74775_l(coord);
                        IBlockState state = Block.func_149684_b((String)tag.func_74779_i("Block")).func_176203_a(tag.func_74771_c("Data") & 0xFF);
                        NBTTagCompound teTag = null;
                        if (tag.func_74764_b("TileEntityData")) {
                            teTag = tag.func_74775_l("TileEntityData");
                        }
                        GlStateManager.func_179094_E();
                        if (state.func_185901_i() != EnumBlockRenderType.INVISIBLE) {
                            Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
                            GlStateManager.func_179140_f();
                            Tessellator tessellator = Tessellator.func_178181_a();
                            BufferBuilder bufferbuilder = tessellator.func_178180_c();
                            BlockRendererDispatcher blockrendererdispatcher = Minecraft.func_71410_x().func_175602_ab();
                            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_176600_a);
                            if (state.func_185901_i() == EnumBlockRenderType.MODEL) {
                                GlStateManager.func_179109_b((float)((float)((double)x - (double)gsPos.func_177958_n() - 0.5)), (float)((float)((double)y - (double)gsPos.func_177956_o())), (float)((float)((double)z - (double)gsPos.func_177952_p() - 0.5)));
                                blockrendererdispatcher.func_175019_b().func_187493_a((IBlockAccess)world, blockrendererdispatcher.func_184389_a(state), state, gsPos, bufferbuilder, false, MathHelper.func_180186_a((Vec3i)BlockPos.func_177969_a((long)gsTag.func_74763_f("source"))));
                            } else if (state.func_185901_i() == EnumBlockRenderType.LIQUID) {
                                GlStateManager.func_179109_b((float)((float)((double)x - (double)gsPos.func_177958_n() - 0.5)), (float)((float)((double)y - (double)gsPos.func_177956_o()) + 0.8125f), (float)((float)((double)z - (double)gsPos.func_177952_p() - 0.5)));
                                blockrendererdispatcher.func_175018_a(state, gsPos, (IBlockAccess)world, bufferbuilder);
                            }
                            tessellator.func_78381_a();
                            GlStateManager.func_179145_e();
                        }
                        if (teTag != null) {
                            TileEntity te;
                            TileEntity renderTe = tileEntityMap.get(coord);
                            if (renderTe == null && (te = state.func_177230_c().createTileEntity(world, state)) != null) {
                                te.func_174878_a(gsPos.func_177982_a(0, 1, 0));
                                te.func_145834_a(world);
                                te.func_145839_a(teTag);
                                tileEntityMap.put(coord, te);
                                renderTe = te;
                            }
                            if (renderTe != null && !classesNotToRender.contains(renderTe.getClass())) {
                                try {
                                    TileEntityRendererDispatcher.field_147556_a.func_147549_a(renderTe, (double)x - 0.5, (double)y, (double)z - 0.5, partialTicks);
                                }
                                catch (ReportedException e) {
                                    classesNotToRender.add(renderTe.getClass());
                                }
                            }
                        }
                        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        GlStateManager.func_179121_F();
                    }
                }
            }
            int entityCount = gsTag.func_74762_e("entityCount");
            boolean create = entities.isEmpty();
            if (create && entityCount > 0) {
                for (int i = 0; i < entityCount; ++i) {
                    Entity ent = EntityList.func_75615_a((NBTTagCompound)gsTag.func_74775_l("ent" + i), (World)world);
                    if (ent == null) continue;
                    entities.add(ent);
                    if (ent instanceof EntityLivingBase) {
                        ent.field_70163_u += 500.0;
                    }
                    ent.field_70145_X = true;
                    ent.func_70071_h_();
                    if (!(ent instanceof EntityLivingBase)) continue;
                    ent.field_70163_u -= 500.0;
                }
                if (entities.isEmpty()) {
                    gsTag.func_74768_a("entityCount", 0);
                }
            }
            int playerCount = gsTag.func_74762_e("playerCount");
            if (create && playerCount > 0) {
                for (int i = 0; i < playerCount; ++i) {
                    GameProfile gp = NBTUtil.func_152459_a((NBTTagCompound)gsTag.func_74775_l("player" + i).func_74775_l("Globe_GamePlofile"));
                    if (gp == null) continue;
                    Property property = (Property)Iterables.getFirst((Iterable)gp.getProperties().get((Object)"textures"), null);
                    if (property == null) {
                        if (sessionService == null) {
                            YggdrasilAuthenticationService yggdrasilauthenticationservice = new YggdrasilAuthenticationService(Minecraft.func_71410_x().func_110437_J(), UUID.randomUUID().toString());
                            sessionService = yggdrasilauthenticationservice.createMinecraftSessionService();
                        }
                        gp = sessionService.fillProfileProperties(gp, true);
                    }
                    if (Minecraft.func_71410_x().func_147114_u().func_175102_a(gp.getId()) == null) {
                        NetworkPlayerInfo info = new NetworkPlayerInfo(gp);
                        try {
                            Method method = NetworkPlayerInfo.class.getDeclaredMethod("func_178838_a", Integer.TYPE);
                            method.setAccessible(true);
                            method.invoke((Object)info, -100);
                        }
                        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ignored) {
                            try {
                                Method method = NetworkPlayerInfo.class.getDeclaredMethod("setResponseTime", Integer.TYPE);
                                method.setAccessible(true);
                                method.invoke((Object)info, -100);
                            }
                            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                                // empty catch block
                            }
                        }
                        EventHandlerClient.getMcPlayerInfoMap().put(gp.getId(), info);
                    }
                    EntityOtherPlayerMP mp = new EntityOtherPlayerMP(world, gp);
                    mp.func_70020_e(gsTag.func_74775_l("player" + i));
                    mp.field_70163_u += 500.0;
                    mp.func_70071_h_();
                    mp.field_70163_u -= 500.0;
                    entities.add((Entity)mp);
                }
            }
            for (Entity ent : entities) {
                GlStateManager.func_179094_E();
                BlockPos source = BlockPos.func_177969_a((long)gsTag.func_74763_f("source")).equals((Object)BlockPos.field_177992_a) ? gsPos : BlockPos.func_177969_a((long)gsTag.func_74763_f("source"));
                GlStateManager.func_179137_b((double)(ent.field_70165_t - (double)source.func_177958_n() - 0.5), (double)(ent.field_70163_u - (double)source.func_177956_o()), (double)(ent.field_70161_v - (double)source.func_177952_p() - 0.5));
                Render render = Minecraft.func_71410_x().func_175598_ae().func_78713_a(ent);
                try {
                    float oriY = Minecraft.func_71410_x().func_175598_ae().field_78735_i;
                    Minecraft.func_71410_x().func_175598_ae().field_78735_i += rotation;
                    render.func_76986_a(ent, 0.0, 0.0, 0.0, ent.field_70177_z, partialTicks);
                    Minecraft.func_71410_x().func_175598_ae().field_78735_i = oriY;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                GlStateManager.func_179121_F();
            }
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179121_F();
            --renderLevel;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)-0.275f, (float)0.0f);
        float scale = 0.4f;
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
        if (drawBase) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(txGlobeStand);
            modelGlobeStand.render(0.0625f);
        }
        if (drawGlass) {
            GlStateManager.func_179147_l();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
            GlStateManager.func_179140_f();
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_176600_a);
            GlStateManager.func_179137_b((double)((float)(-((double)gsPos.func_177958_n()) - 0.5)), (double)((double)((float)(-((double)gsPos.func_177956_o()))) + 0.3), (double)((float)(-((double)gsPos.func_177952_p()) - 0.5)));
            IBlockState glass = gsTag != null && gsTag.func_74764_b("glassType") ? Blocks.field_150399_cn.func_176203_a(gsTag.func_74762_e("glassType")) : Blocks.field_150359_w.func_176223_P();
            BlockRendererDispatcher blockrendererdispatcher = Minecraft.func_71410_x().func_175602_ab();
            blockrendererdispatcher.func_175019_b().func_187493_a((IBlockAccess)world, blockrendererdispatcher.func_184389_a(glass), glass, gsPos, bufferbuilder, false, MathHelper.func_180186_a((Vec3i)BlockPos.field_177992_a));
            tessellator.func_78381_a();
            GlStateManager.func_179145_e();
        }
        GlStateManager.func_179121_F();
    }

    static {
        renderLevel = 0;
        classesNotToRender = new HashSet();
        modelGlobeStand = new ModelGlobeStand();
        modelStand = new ModelStand();
    }
}

