/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.globe.common.block;

import javax.annotation.Nullable;
import me.ichun.mods.globe.common.Globe;
import me.ichun.mods.globe.common.tileentity.TileEntityGlobeCreator;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockGlobeCreator
extends Block
implements ITileEntityProvider {
    public BlockGlobeCreator() {
        super(Material.field_151573_f);
        this.func_149711_c(5.0f);
        this.func_149752_b(10.0f);
        this.setRegistryName(new ResourceLocation("globe", "globe_creator"));
        this.func_149663_c("globe.block.globeCreator");
        this.func_149647_a(CreativeTabs.field_78031_c);
    }

    @Nullable
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityGlobeCreator();
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityGlobeCreator) {
            TileEntityGlobeCreator gc = (TileEntityGlobeCreator)te;
            if (!gc.hasGlobe) {
                ItemStack is = playerIn.func_184586_b(hand);
                if (is.func_77973_b() == Globe.itemGlobe && is.func_77952_i() == 0) {
                    gc.hasGlobe = true;
                    if (!playerIn.field_71075_bZ.field_75098_d) {
                        playerIn.func_184611_a(hand, ItemStack.field_190927_a);
                    }
                    SoundType soundtype = this.func_185467_w();
                    world.func_184133_a(playerIn, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
                    world.func_184138_a(pos, state, state, 3);
                    return true;
                }
            } else if (gc.timeToGlobe < 0 && !gc.globed) {
                if (!world.field_72995_K) {
                    gc.totalGlobeTime = 200;
                    gc.timeToGlobe = 200;
                    gc.radius = 3;
                    world.func_184138_a(pos, state, state, 3);
                    world.func_184148_a(null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, Globe.soundChargeup, SoundCategory.BLOCKS, 0.3f, 1.0f);
                }
                return true;
            }
        }
        return false;
    }

    public float func_176195_g(IBlockState blockState, World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityGlobeCreator) {
            TileEntityGlobeCreator gc = (TileEntityGlobeCreator)te;
            if (gc.globed || gc.timeToGlobe >= 0) {
                return -1.0f;
            }
        }
        return this.field_149782_v;
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer player) {
        if (player.field_71075_bZ.field_75098_d) {
            return;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityGlobeCreator) {
            TileEntityGlobeCreator gc = (TileEntityGlobeCreator)te;
            if (!gc.globed && gc.timeToGlobe < 0 && gc.hasGlobe && player.field_71071_by.func_70441_a(new ItemStack(Globe.itemGlobe, 1, 0))) {
                gc.hasGlobe = false;
                IBlockState state = world.func_180495_p(pos);
                world.func_184138_a(pos, state, state, 3);
            }
        }
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityGlobeCreator) {
            TileEntityGlobeCreator gc = (TileEntityGlobeCreator)te;
            if (gc.timeToGlobe >= 12) {
                return (int)(MathHelper.func_76131_a((float)(1.0f - (float)(gc.timeToGlobe - 10) / ((float)gc.totalGlobeTime - 10.0f)), (float)0.0f, (float)1.0f) * 15.0f * MathHelper.func_76131_a((float)((float)(gc.radius * 2 + 4) / 15.0f), (float)0.0f, (float)1.0f));
            }
        }
        return state.func_185906_d();
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityGlobeCreator) {
            TileEntityGlobeCreator gs = (TileEntityGlobeCreator)te;
            if (gs.hasGlobe) {
                drops.add((Object)new ItemStack(Globe.itemGlobe, 1, 0));
            }
            drops.add((Object)new ItemStack(Globe.blockGlobeCreator, 1));
        }
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        this.func_176208_a(world, pos, state, player);
        boolean flag = world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), world.field_72995_K ? 11 : 3);
        world.func_175664_x(pos);
        return flag;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        super.func_180663_b(worldIn, pos, state);
        worldIn.func_175713_t(pos);
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }
}

