/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.client.gui.impl.container;

import com.zeitheron.hammercore.lib.zlib.tuple.TwoTuple;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class ItemTransferHelper {
    public final TransferableContainer container;
    private TwoTuple<Integer, Integer> inventory = new TwoTuple<Integer, Integer>(0, 0);
    private Map<Integer, Predicate<Integer>> outHandlers = new HashMap<Integer, Predicate<Integer>>();
    private Map<Integer, Predicate<ItemStack>> inHandlers = new HashMap<Integer, Predicate<ItemStack>>();
    private List<Integer> toInventory = new ArrayList<Integer>();

    public ItemTransferHelper(TransferableContainer container) {
        this.container = container;
    }

    public ItemTransferHelper addInTransferRule(int targetSlot, Predicate<ItemStack> valid) {
        this.inHandlers.put(targetSlot, valid);
        return this;
    }

    public ItemTransferHelper addOutTransferRule(int targetSlot, Predicate<Integer> slots) {
        this.outHandlers.put(targetSlot, slots);
        return this;
    }

    public ItemTransferHelper setInventorySlots(int start, int end) {
        this.inventory = new TwoTuple<Integer, Integer>(start, end);
        return this;
    }

    public ItemTransferHelper toInventory(int slot) {
        if (!this.toInventory.contains(slot)) {
            this.toInventory.add(slot);
        }
        return this;
    }

    public boolean isInventorySlot(int slot) {
        return slot >= this.inventory.get1() && slot < this.inventory.get2();
    }

    public ItemStack handleTransfer(EntityPlayer playerIn, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.container.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            Predicate<Integer> slots = this.outHandlers.get(index);
            if (slots != null) {
                for (int i = 0; i < this.container.field_75151_b.size(); ++i) {
                    Predicate<ItemStack> stacks;
                    if (i == index || !slots.test(i) || (stacks = this.inHandlers.get(i)) != null && stacks.test(itemstack)) continue;
                    if (!this.container.func_75135_a(itemstack1, i, i + 1, true)) {
                        return ItemStack.field_190927_a;
                    }
                    slot.func_75220_a(itemstack1, itemstack);
                }
            } else if (this.toInventory.contains(index)) {
                if (!this.container.func_75135_a(itemstack1, this.inventory.get1(), this.inventory.get2(), false)) {
                    return ItemStack.field_190927_a;
                }
                slot.func_75220_a(itemstack1, itemstack);
            } else if (index != 0) {
                boolean functioned = false;
                for (Integer i : this.inHandlers.keySet()) {
                    Predicate<ItemStack> stacks = this.inHandlers.get(i);
                    if (!stacks.test(itemstack)) continue;
                    functioned = true;
                    if (this.container.func_75135_a(itemstack1, i, i + 1, false)) break;
                    return ItemStack.field_190927_a;
                }
                if (!functioned) {
                    int start = this.inventory.get1();
                    int end = this.inventory.get2();
                    if (index >= start + 9 && index < end && !this.container.func_75135_a(itemstack1, start, start + 9, false)) {
                        return ItemStack.field_190927_a;
                    }
                    if (index >= start && index < start + 9 && !this.container.func_75135_a(itemstack1, start + 9, end, false)) {
                        return ItemStack.field_190927_a;
                    }
                }
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (itemstack1.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(playerIn, itemstack1);
        }
        return itemstack;
    }

    public static abstract class TransferableContainer<T>
    extends Container {
        public final ItemTransferHelper transfer = new ItemTransferHelper(this);
        public final T t;
        public final EntityPlayer player;

        public TransferableContainer(EntityPlayer player, T t, int invX, int invY) {
            this.t = t;
            this.player = player;
            this.addCustomSlots();
            this.addInventorySlots(player, invX, invY);
            this.addTransfer();
        }

        protected void addCustomSlots() {
        }

        protected void addTransfer() {
        }

        protected void addInventorySlots(EntityPlayer player, int x, int y) {
            int i;
            int start = this.field_75151_b.size();
            for (i = 0; i < 9; ++i) {
                this.func_75146_a(new Slot((IInventory)player.field_71071_by, i, x + i * 18, 58 + y));
            }
            for (i = 0; i < 3; ++i) {
                for (int j = 0; j < 9; ++j) {
                    this.func_75146_a(new Slot((IInventory)player.field_71071_by, 9 + j + i * 9, x + 18 * j, y + i * 18));
                }
            }
            this.transfer.setInventorySlots(start, this.field_75151_b.size());
        }

        public ItemStack func_82846_b(EntityPlayer playerIn, int index) {
            return this.transfer.handleTransfer(playerIn, index);
        }

        public boolean func_75145_c(EntityPlayer playerIn) {
            return true;
        }

        protected boolean func_75135_a(ItemStack stack, int startIndex, int endIndex, boolean reverseDirection) {
            try {
                return super.func_75135_a(stack, startIndex, endIndex, reverseDirection);
            }
            catch (Throwable throwable) {
                return false;
            }
        }
    }
}

