/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.client.render.item.img;

import com.zeitheron.hammercore.lib.zlib.tuple.ThreeTuple;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class Stack2ImageRenderer {
    public static final Stack2ImageRenderer INSTANCE = new Stack2ImageRenderer();
    private List<ThreeTuple<ItemStack, Integer, Consumer<BufferedImage>>> queue = new ArrayList<ThreeTuple<ItemStack, Integer, Consumer<BufferedImage>>>();
    private int size;
    private float oldZLevel;

    public static void queueRenderer(ItemStack stack, int size, Consumer<BufferedImage> done) {
        Stack2ImageRenderer.INSTANCE.queue.add(new ThreeTuple<ItemStack, Integer, Consumer<BufferedImage>>(stack, size, done));
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onFrameStart(TickEvent.RenderTickEvent e) {
        ThreeTuple<ItemStack, Integer, Consumer<BufferedImage>> data;
        if (e.phase == TickEvent.Phase.START && !this.queue.isEmpty() && !(data = this.queue.remove(0)).get1().func_190926_b() && data.get2() > 0) {
            BufferedImage i = this.bulkRender(data.get1(), data.get2());
            Consumer<BufferedImage> callback = data.get3();
            if (callback != null) {
                callback.accept(i);
            }
        }
    }

    public BufferedImage bulkRender(ItemStack is, int size) {
        long lastUpdate = 0L;
        this.setUpRenderState(size);
        BufferedImage img = this.render(is);
        this.tearDownRenderState();
        return img;
    }

    private BufferedImage render(ItemStack is) {
        Minecraft mc = Minecraft.func_71410_x();
        GlStateManager.func_179094_E();
        GlStateManager.func_179082_a((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179086_m((int)16640);
        mc.func_175599_af().func_180450_b(is, 0, 0);
        GlStateManager.func_179121_F();
        try {
            return Stack2ImageRenderer.createFlipped(this.readPixels(this.size, this.size));
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    private void setUpRenderState(int desiredSize) {
        Minecraft mc = Minecraft.func_71410_x();
        ScaledResolution res = new ScaledResolution(mc);
        this.size = Math.min(Math.min(mc.field_71440_d, mc.field_71443_c), desiredSize);
        mc.field_71460_t.func_78478_c();
        RenderHelper.func_74520_c();
        float scale = (float)this.size / (16.0f * (float)res.func_78325_e());
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)(-(scale * 100.0f)));
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
        this.oldZLevel = mc.func_175599_af().field_77023_b;
        mc.func_175599_af().field_77023_b = -50.0f;
        GlStateManager.func_179091_B();
        GlStateManager.func_179142_g();
        GlStateManager.func_179126_j();
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)770, (int)1);
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179118_c();
    }

    private void tearDownRenderState() {
        GlStateManager.func_179140_f();
        GlStateManager.func_179119_h();
        GlStateManager.func_179097_i();
        GlStateManager.func_179084_k();
        Minecraft.func_71410_x().func_175599_af().field_77023_b = this.oldZLevel;
    }

    public BufferedImage readPixels(int width, int height) throws InterruptedException {
        ByteBuffer buf = BufferUtils.createByteBuffer((int)(width * height * 4));
        GL11.glReadPixels((int)0, (int)(Minecraft.func_71410_x().field_71440_d - height), (int)width, (int)height, (int)32993, (int)5121, (ByteBuffer)buf);
        BufferedImage img = new BufferedImage(width, height, 2);
        int[] pixels = new int[width * height];
        buf.asIntBuffer().get(pixels);
        img.setRGB(0, 0, width, height, pixels, 0, width);
        return img;
    }

    private static BufferedImage createFlipped(BufferedImage image) {
        AffineTransform at = new AffineTransform();
        at.concatenate(AffineTransform.getScaleInstance(1.0, -1.0));
        at.concatenate(AffineTransform.getTranslateInstance(0.0, -image.getHeight()));
        return Stack2ImageRenderer.createTransformed(image, at);
    }

    private static BufferedImage createTransformed(BufferedImage image, AffineTransform at) {
        BufferedImage newImage = new BufferedImage(image.getWidth(), image.getHeight(), 2);
        Graphics2D g = newImage.createGraphics();
        g.transform(at);
        g.drawImage((Image)image, 0, 0, null);
        g.dispose();
        return newImage;
    }
}

