/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.client.utils;

import com.zeitheron.hammercore.utils.color.ColorHelper;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class TexturePixelGetter {
    private static final Map<String, int[]> colors = new HashMap<String, int[]>();

    @SubscribeEvent
    public void reloadTexture(TextureStitchEvent e) {
        colors.clear();
    }

    public static int[] getAllColors(ItemStack stack) {
        IBakedModel model = Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178089_a(stack);
        TextureAtlasSprite spr = model.func_177554_e();
        if (spr == null) {
            spr = Minecraft.func_71410_x().func_147117_R().func_174944_f();
        }
        ResourceLocation resourcelocation = new ResourceLocation(spr.func_94215_i());
        return TexturePixelGetter.getAllColors(resourcelocation.func_110624_b() + ":" + String.format("%s/%s%s", "textures", resourcelocation.func_110623_a(), ".png"));
    }

    public static int[] getAllColors(String texture) {
        if (colors.containsKey(texture)) {
            return colors.get(texture);
        }
        if (texture.equals("minecraft:textures/missingno.png") || texture.equals("textures/missingno.png")) {
            colors.put(texture, new int[]{0xFF00FF, 0});
        } else {
            try {
                HashSet<Integer> ints = new HashSet<Integer>();
                BufferedImage img = TextureUtil.func_177053_a((InputStream)Minecraft.func_71410_x().func_110442_L().func_110536_a(new ResourceLocation(texture)).func_110527_b());
                for (int x = 0; x < img.getWidth(); ++x) {
                    for (int y = 0; y < img.getHeight(); ++y) {
                        int rgb = img.getRGB(x, y);
                        if (ColorHelper.getAlpha(rgb) <= 0.0f) continue;
                        ints.add(rgb);
                    }
                }
                int[] buf = new int[ints.size()];
                int pointer = 0;
                for (Integer i : ints) {
                    buf[pointer] = i;
                    ++pointer;
                }
                colors.put(texture, buf);
            }
            catch (IOException e) {
                e.printStackTrace();
                colors.put(texture, new int[0]);
            }
        }
        return colors.get(texture);
    }
}

