/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.client.utils;

import com.zeitheron.hammercore.HammerCore;
import com.zeitheron.hammercore.client.utils.RenderUtil;
import com.zeitheron.hammercore.client.utils.texture.TexLocUploader;
import com.zeitheron.hammercore.lib.zlib.io.IOUtils;
import com.zeitheron.hammercore.lib.zlib.utils.MD5;
import com.zeitheron.hammercore.utils.QuadHelper;
import com.zeitheron.hammercore.utils.color.ColorHelper;
import com.zeitheron.hammercore.utils.math.vec.Vector3;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import org.lwjgl.opengl.GL11;

public class UtilsFX {
    private static final ResourceLocation PARTICLE_TEXTURES = new ResourceLocation("textures/particle/particles.png");
    private static Map<String, ResourceLocation> textures = new HashMap<String, ResourceLocation>();

    public static boolean bindTextureURL(String url) {
        boolean b;
        String withoutHTTP = url.substring(url.indexOf("://") + 3);
        String protocol = url.substring(0, url.indexOf("://"));
        ResourceLocation loca = new ResourceLocation("hammercore", protocol + "/" + MD5.encrypt(withoutHTTP));
        if (!TexLocUploader.cleanup.contains(loca)) {
            String lpa = loca.toString();
            new Thread(() -> {
                try (InputStream input = IOUtils.getInput(url).get1();){
                    BufferedImage bufferedimage = TextureUtil.func_177053_a((InputStream)input);
                    Minecraft.func_71410_x().func_152343_a(() -> TexLocUploader.upload(loca, bufferedimage));
                }
                catch (Throwable ioe) {
                    HammerCore.LOG.error("Failed to load texture from url \"" + url + "\"", ioe);
                }
            }).start();
            TexLocUploader.cleanupAfterLogoff(loca, () -> textures.remove(lpa));
            textures.put(lpa, loca);
        }
        if (b = Minecraft.func_71410_x().func_110434_K().field_110585_a.containsKey(loca)) {
            UtilsFX.bindTexture(loca);
        }
        return b;
    }

    public static void bindTexture(String tex) {
        if (tex.startsWith("http")) {
            UtilsFX.bindTextureURL(tex);
        } else {
            UtilsFX.bindTexture("hammercore", tex);
        }
    }

    public static void bindTexture(ResourceLocation loca) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(loca);
    }

    public static void bindTexture(String dom, String tex) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(new ResourceLocation(dom, tex));
    }

    public static void drawTexturedQuadFull(int par1, int par2, double zLevel) {
        Tessellator var9 = Tessellator.func_178181_a();
        BufferBuilder b = var9.func_178180_c();
        b.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        b.func_181662_b((double)(par1 + 0), (double)(par2 + 16), zLevel).func_187315_a(0.0, 1.0).func_181675_d();
        b.func_181662_b((double)(par1 + 16), (double)(par2 + 16), zLevel).func_187315_a(1.0, 1.0).func_181675_d();
        b.func_181662_b((double)(par1 + 16), (double)(par2 + 0), zLevel).func_187315_a(1.0, 0.0).func_181675_d();
        b.func_181662_b((double)(par1 + 0), (double)(par2 + 0), zLevel).func_187315_a(0.0, 0.0).func_181675_d();
        var9.func_78381_a();
    }

    public static void drawCustomTooltip(GuiScreen gui, RenderItem itemRenderer, FontRenderer fr, List<String> var4, int par2, int par3, int subTipColor) {
        GL11.glDisable((int)32826);
        GL11.glDisable((int)2929);
        GlStateManager.func_179147_l();
        if (!var4.isEmpty()) {
            int var5 = 0;
            for (String var7 : var4) {
                var5 = Math.max(var5, fr.func_78256_a(var7));
            }
            int var15 = par2 + 12;
            int var16 = par3 - 12;
            int var9 = 8;
            if (var4.size() > 1) {
                var9 += 2 + (var4.size() - 1) * 10;
            }
            itemRenderer.field_77023_b = 300.0f;
            int var10 = -267386864;
            RenderUtil.drawGradientRect(var15 - 3, var16 - 4, var5 + 3, 1.0, var10, var10);
            RenderUtil.drawGradientRect(var15 - 3, var16 + var9 + 3, var5 + 3, 1.0, var10, var10);
            RenderUtil.drawGradientRect(var15 - 3, var16 - 3, var5 + 3, var9 + 6, var10, var10);
            RenderUtil.drawGradientRect(var15 - 4, var16 - 3, 1.0, var9 + 6, var10, var10);
            RenderUtil.drawGradientRect(var15 + var5, var16 - 3, 1.0, var9 + 6, var10, var10);
            int var11 = 0x505000FF;
            int var12 = (var11 & 0xFEFEFE) >> 1 | var11 & 0xFF000000;
            RenderUtil.drawGradientRect(var15 - 3, var16 - 2, 1.0, var9 + 5, var11, var12);
            RenderUtil.drawGradientRect(var15 + var5 - 1, var16 - 3 + 1, 1.0, var9 + 5, var11, var12);
            RenderUtil.drawGradientRect(var15 - 3, var16 - 3, var5 + 3, 1.0, var11, var11);
            RenderUtil.drawGradientRect(var15 - 2, var16 + var9 + 2, var5 + 1, 1.0, var12, var12);
            for (int var13 = 0; var13 < var4.size(); ++var13) {
                String var14 = var4.get(var13);
                var14 = var13 == 0 ? "\u00a7" + Integer.toHexString(subTipColor) + var14 : "\u00a77" + var14;
                fr.func_175063_a(var14, (float)var15, (float)var16, -1);
                if (var13 == 0) {
                    var16 += 2;
                }
                var16 += 10;
            }
        }
        itemRenderer.field_77023_b = 0.0f;
        GL11.glEnable((int)2929);
        GlStateManager.func_179147_l();
    }

    public static ResourceLocation getMCParticleTexture() {
        return PARTICLE_TEXTURES;
    }

    public static void drawBeam(Vec3d S, Vec3d E, Vec3d P, float width, int bright) {
        UtilsFX.drawBeam(S, E, P, width, bright, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public static void drawBeam(Vec3d S, Vec3d E, Vec3d P, float width, int bright, float r, float g, float b, float a) {
        Vec3d PS = UtilsFX.Sub(S, P);
        Vec3d SE = UtilsFX.Sub(E, S);
        Vec3d normal = UtilsFX.Cross(PS, SE);
        normal = normal.func_72432_b();
        Vec3d half = UtilsFX.Mul(normal, width);
        Vec3d p1 = UtilsFX.Add(S, half);
        Vec3d p2 = UtilsFX.Sub(S, half);
        Vec3d p3 = UtilsFX.Add(E, half);
        Vec3d p4 = UtilsFX.Sub(E, half);
        UtilsFX.drawQuad(Tessellator.func_178181_a().func_178180_c(), p1, p3, p4, p2, bright, r, g, b, a);
    }

    public static void drawQuad(BufferBuilder buf, Vec3d p1, Vec3d p2, Vec3d p3, Vec3d p4, int bright, float r, float g, float b, float a) {
        int j = bright >> 16 & 0xFFFF;
        int k = bright & 0xFFFF;
        buf.func_181662_b(p1.field_72450_a, p1.field_72448_b, p1.field_72449_c).func_187315_a(0.0, 0.0).func_187314_a(j, k).func_181666_a(r, g, b, a).func_181675_d();
        buf.func_181662_b(p2.field_72450_a, p2.field_72448_b, p2.field_72449_c).func_187315_a(1.0, 0.0).func_187314_a(j, k).func_181666_a(r, g, b, a).func_181675_d();
        buf.func_181662_b(p3.field_72450_a, p3.field_72448_b, p3.field_72449_c).func_187315_a(1.0, 1.0).func_187314_a(j, k).func_181666_a(r, g, b, a).func_181675_d();
        buf.func_181662_b(p4.field_72450_a, p4.field_72448_b, p4.field_72449_c).func_187315_a(0.0, 1.0).func_187314_a(j, k).func_181666_a(r, g, b, a).func_181675_d();
    }

    private static Vec3d Cross(Vec3d a, Vec3d b) {
        double xCoord = a.field_72448_b * b.field_72449_c - a.field_72449_c * b.field_72448_b;
        double yCoord = a.field_72449_c * b.field_72450_a - a.field_72450_a * b.field_72449_c;
        double zCoord = a.field_72450_a * b.field_72448_b - a.field_72448_b * b.field_72450_a;
        return new Vec3d(xCoord, yCoord, zCoord);
    }

    public static Vec3d Sub(Vec3d a, Vec3d b) {
        return new Vec3d(a.field_72450_a - b.field_72450_a, a.field_72448_b - b.field_72448_b, a.field_72449_c - b.field_72449_c);
    }

    private static Vec3d Add(Vec3d a, Vec3d b) {
        return new Vec3d(a.field_72450_a + b.field_72450_a, a.field_72448_b + b.field_72448_b, a.field_72449_c + b.field_72449_c);
    }

    private static Vec3d Mul(Vec3d a, float f) {
        return new Vec3d(a.field_72450_a * (double)f, a.field_72448_b * (double)f, a.field_72449_c * (double)f);
    }

    public static void renderFacingStrip(double px, double py, double pz, float angle, float scale, float alpha, int frames, int strip, int frame, float partialTicks, int color) {
        if (Minecraft.func_71410_x().func_175606_aa() instanceof EntityPlayer) {
            Tessellator tessellator = Tessellator.func_178181_a();
            float arX = ActiveRenderInfo.func_178808_b();
            float arZ = ActiveRenderInfo.func_178803_d();
            float arYZ = ActiveRenderInfo.func_178805_e();
            float arXY = ActiveRenderInfo.func_178807_f();
            float arXZ = ActiveRenderInfo.func_178809_c();
            EntityPlayer player = (EntityPlayer)Minecraft.func_71410_x().func_175606_aa();
            double iPX = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)partialTicks;
            double iPY = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)partialTicks;
            double iPZ = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)partialTicks;
            BufferBuilder buf = tessellator.func_178180_c();
            buf.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            Vector3 v1 = new Vector3(-arX * scale - arYZ * scale, -arXZ * scale, -arZ * scale - arXY * scale);
            Vector3 v2 = new Vector3(-arX * scale + arYZ * scale, arXZ * scale, -arZ * scale + arXY * scale);
            Vector3 v3 = new Vector3(arX * scale + arYZ * scale, arXZ * scale, arZ * scale + arXY * scale);
            Vector3 v4 = new Vector3(arX * scale - arYZ * scale, -arXZ * scale, arZ * scale - arXY * scale);
            if (angle != 0.0f) {
                Vector3 f2 = new Vector3(iPX, iPY, iPZ);
                Vector3 f3 = new Vector3(px, py, pz);
                Vector3 f4 = f2.subtract(f3).normalize();
                QuadHelper.setAxis(f4, angle).rotate(v1);
                QuadHelper.setAxis(f4, angle).rotate(v2);
                QuadHelper.setAxis(f4, angle).rotate(v3);
                QuadHelper.setAxis(f4, angle).rotate(v4);
            }
            float f21 = (float)frame / (float)frames;
            float f31 = (float)(frame + 1) / (float)frames;
            float f41 = (float)strip / (float)frames;
            float f5 = ((float)strip + 1.0f) / (float)frames;
            buf.func_181662_b(px + v1.x, py + v1.y, pz + v1.z).func_187315_a((double)f31, (double)f5).func_181666_a(ColorHelper.getRed(color), ColorHelper.getGreen(color), ColorHelper.getBlue(color), alpha).func_181675_d();
            buf.func_181662_b(px + v2.x, py + v2.y, pz + v2.z).func_187315_a((double)f31, (double)f41).func_181666_a(ColorHelper.getRed(color), ColorHelper.getGreen(color), ColorHelper.getBlue(color), alpha).func_181675_d();
            buf.func_181662_b(px + v3.x, py + v3.y, pz + v3.z).func_187315_a((double)f21, (double)f41).func_181666_a(ColorHelper.getRed(color), ColorHelper.getGreen(color), ColorHelper.getBlue(color), alpha).func_181675_d();
            buf.func_181662_b(px + v4.x, py + v4.y, pz + v4.z).func_187315_a((double)f21, (double)f5).func_181666_a(ColorHelper.getRed(color), ColorHelper.getGreen(color), ColorHelper.getBlue(color), alpha).func_181675_d();
            tessellator.func_78381_a();
        }
    }
}

