/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.internal;

import com.google.common.collect.Maps;
import com.zeitheron.hammercore.HammerCore;
import com.zeitheron.hammercore.annotations.PreRegisterHook;
import com.zeitheron.hammercore.annotations.RecipeRegister;
import com.zeitheron.hammercore.annotations.RegisterIf;
import com.zeitheron.hammercore.annotations.RegistryName;
import com.zeitheron.hammercore.annotations.SimplyRegister;
import com.zeitheron.hammercore.api.IDontWantToRegisterTileEntity;
import com.zeitheron.hammercore.api.INoItemBlock;
import com.zeitheron.hammercore.api.ITileBlock;
import com.zeitheron.hammercore.api.blocks.IBlockItemRegisterListener;
import com.zeitheron.hammercore.api.blocks.INoBlockstate;
import com.zeitheron.hammercore.api.multipart.BlockMultipartProvider;
import com.zeitheron.hammercore.internal.blocks.IItemBlock;
import com.zeitheron.hammercore.internal.init.ItemsHC;
import com.zeitheron.hammercore.utils.IRegisterListener;
import com.zeitheron.hammercore.utils.ReflectionUtil;
import com.zeitheron.hammercore.utils.SoundObject;
import com.zeitheron.hammercore.utils.forge.RegisterHook;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.OreIngredient;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class SimpleRegistration {
    private static final List<Supplier<List<IRecipe>>> RECIPE_GENERATORS = new ArrayList<Supplier<List<IRecipe>>>();

    public static ShapedRecipes parseShapedRecipe(ItemStack stack, Object ... recipeComponents) {
        ModContainer mc = Loader.instance().activeModContainer();
        String name = (mc != null ? mc.getModId() : "hammercore") + ":" + stack.func_77977_a();
        String s = "";
        int i = 0;
        int j = 0;
        int k = 0;
        if (recipeComponents[i] instanceof String[]) {
            String[] astring;
            for (String s2 : astring = (String[])recipeComponents[i++]) {
                ++k;
                j = s2.length();
                s = s + s2;
            }
        } else {
            while (recipeComponents[i] instanceof String) {
                String s1 = (String)recipeComponents[i++];
                ++k;
                j = s1.length();
                s = s + s1;
            }
        }
        HashMap map = Maps.newHashMap();
        while (i < recipeComponents.length) {
            Character character = (Character)recipeComponents[i];
            Ingredient ingr = null;
            if (recipeComponents[i + 1] instanceof Item) {
                ingr = Ingredient.func_193367_a((Item)((Item)recipeComponents[i + 1]));
            } else if (recipeComponents[i + 1] instanceof Block) {
                ingr = Ingredient.func_193367_a((Item)Item.func_150898_a((Block)((Block)recipeComponents[i + 1])));
            } else if (recipeComponents[i + 1] instanceof ItemStack) {
                ingr = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{((ItemStack)recipeComponents[i + 1]).func_77946_l()});
            } else if (recipeComponents[i + 1] instanceof ItemStack[]) {
                ItemStack[] items = (ItemStack[])((ItemStack[])recipeComponents[i + 1]).clone();
                for (int l = 0; l < items.length; ++l) {
                    items[l] = items[l].func_77946_l();
                }
                ingr = Ingredient.func_193369_a((ItemStack[])items);
            } else if (recipeComponents[i + 1] instanceof String) {
                ingr = new OreIngredient(recipeComponents[i + 1] + "");
            } else if (recipeComponents[i + 1] instanceof Ingredient) {
                ingr = (Ingredient)recipeComponents[i + 1];
            }
            map.put(character, ingr);
            i += 2;
        }
        NonNullList aitemstack = NonNullList.func_191197_a((int)(j * k), (Object)Ingredient.field_193370_a);
        for (int l = 0; l < j * k; ++l) {
            char c0 = s.charAt(l);
            if (!map.containsKey(Character.valueOf(c0))) continue;
            aitemstack.set(l, map.get(Character.valueOf(c0)));
        }
        return new ShapedRecipes(name, j, k, aitemstack, stack);
    }

    public static ShapelessRecipes parseShapelessRecipe(ItemStack stack, Object ... recipeComponents) {
        ModContainer mc = Loader.instance().activeModContainer();
        String name = (mc != null ? mc.getModId() : "hammercore") + ":" + stack.func_77977_a();
        NonNullList list = NonNullList.func_191196_a();
        for (Object object : recipeComponents) {
            Ingredient ingr = null;
            if (object instanceof Item) {
                ingr = Ingredient.func_193367_a((Item)((Item)object));
            } else if (object instanceof Block) {
                ingr = Ingredient.func_193367_a((Item)Item.func_150898_a((Block)((Block)object)));
            } else if (object instanceof ItemStack) {
                ingr = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{((ItemStack)object).func_77946_l()});
            } else if (object instanceof ItemStack[]) {
                ItemStack[] items = (ItemStack[])((ItemStack[])object).clone();
                for (int l = 0; l < items.length; ++l) {
                    items[l] = items[l].func_77946_l();
                }
                ingr = Ingredient.func_193369_a((ItemStack[])items);
            } else if (object instanceof String) {
                ingr = new OreIngredient(object + "");
            } else if (object instanceof Ingredient) {
                ingr = (Ingredient)object;
            }
            if (ingr == null) {
                throw new IllegalArgumentException("Invalid shapeless recipe: unknown type " + object.getClass().getName() + "!");
            }
            list.add((Object)ingr);
        }
        return new ShapelessRecipes(name, stack, list);
    }

    public static void registerFieldItemsFrom(Class<?> owner, String modid, CreativeTabs tab) {
        Field[] fs;
        for (Method m : owner.getDeclaredMethods()) {
            if (m.getAnnotation(PreRegisterHook.class) == null || m.getParameterCount() != 0 || !Modifier.isStatic(m.getModifiers())) continue;
            m.setAccessible(true);
            try {
                m.invoke(null, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        boolean simplyRegister = owner.isAnnotationPresent(SimplyRegister.class);
        for (Field f : fs = owner.getDeclaredFields()) {
            if (!Item.class.isAssignableFrom(f.getType()) || !SimpleRegistration.doRegister(f)) continue;
            try {
                if (simplyRegister && f.isAnnotationPresent(RegistryName.class)) {
                    HammerCore.LOG.info("Skipped {} as it has @RegistryName.", (Object)f);
                    continue;
                }
                f.setAccessible(true);
                SimpleRegistration.registerItem((Item)f.get(null), modid, tab);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void disableIf(boolean statement, Object instance) {
        if (statement) {
            for (Field f : ReflectionUtil.getCaller().getDeclaredFields()) {
                if (!Modifier.isStatic(f.getModifiers())) continue;
                ReflectionUtil.setStaticFinalField(f, null);
            }
        }
    }

    public static void registerFieldBlocksFrom(Class<?> owner, String modid, CreativeTabs tab) {
        Field[] fs;
        for (Method m : owner.getDeclaredMethods()) {
            if (m.getAnnotation(PreRegisterHook.class) == null || m.getParameterCount() != 0 || !Modifier.isStatic(m.getModifiers())) continue;
            m.setAccessible(true);
            try {
                m.invoke(null, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        boolean simplyRegister = owner.isAnnotationPresent(SimplyRegister.class);
        for (Field f : fs = owner.getDeclaredFields()) {
            if (!Block.class.isAssignableFrom(f.getType()) || !SimpleRegistration.doRegister(f)) continue;
            try {
                if (simplyRegister && f.isAnnotationPresent(RegistryName.class)) {
                    HammerCore.LOG.info("Skipped {} as it has @RegistryName.", (Object)f);
                    continue;
                }
                f.setAccessible(true);
                SimpleRegistration.registerBlock((Block)f.get(null), modid, tab);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void registerFieldSoundsFrom(Class<?> owner) {
        Field[] fs;
        for (Method m : owner.getDeclaredMethods()) {
            if (m.getAnnotation(PreRegisterHook.class) == null || m.getParameterCount() != 0 || !Modifier.isStatic(m.getModifiers())) continue;
            m.setAccessible(true);
            try {
                m.invoke(null, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        for (Field f : fs = owner.getDeclaredFields()) {
            if (!SoundObject.class.isAssignableFrom(f.getType()) || !SimpleRegistration.doRegister(f)) continue;
            try {
                f.setAccessible(true);
                SimpleRegistration.registerSound((SoundObject)f.get(null));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static boolean doRegister(Field f) {
        RegisterIf statement = f.getAnnotation(RegisterIf.class);
        if (statement != null) {
            String parse = statement.value();
            int i = parse.lastIndexOf(46);
            String cls = parse.substring(0, i);
            String fld = parse.substring(i + 1);
            try {
                boolean value = ReflectionUtil.getField(Class.forName(cls), fld).getBoolean(null);
                return statement.invert() ? !value : value;
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    public static void registerSound(SoundObject sound) {
        sound.sound = (SoundEvent)new SoundEvent(sound.name).setRegistryName(sound.name);
        ForgeRegistries.SOUND_EVENTS.register((IForgeRegistryEntry)sound.sound);
    }

    public static void registerItem(Item item, String modid, CreativeTabs tab) {
        if (item == null) {
            return;
        }
        String name = item.func_77658_a().substring("item.".length());
        item.setRegistryName(modid, name);
        item.func_77655_b(modid + ":" + name);
        if (tab != null) {
            item.func_77637_a(tab);
        }
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)item);
        if (item instanceof IRegisterListener) {
            IRegisterListener rl = (IRegisterListener)item;
            rl.onRegistered();
            RegisterHook.HookCollector.propagate(rl);
        }
        ItemsHC.items.add(item);
    }

    public static void registerBlock(Block block, String modid, CreativeTabs tab) {
        IRegisterListener rl;
        if (block == null) {
            return;
        }
        String name = block.func_149739_a().substring("tile.".length());
        block.func_149663_c(modid + ":" + name);
        block.func_149647_a(tab);
        Object ib = block instanceof BlockMultipartProvider ? ((BlockMultipartProvider)block).createItem() : (block instanceof IItemBlock ? ((IItemBlock)block).getItemBlock() : new ItemBlock(block));
        block.setRegistryName(modid, name);
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)block);
        if (!(block instanceof INoItemBlock)) {
            ForgeRegistries.ITEMS.register(ib.setRegistryName(block.getRegistryName()));
            if (ib instanceof IRegisterListener) {
                rl = (IRegisterListener)ib;
                rl.onRegistered();
                RegisterHook.HookCollector.propagate(rl);
            }
            if (block instanceof IBlockItemRegisterListener) {
                ((IBlockItemRegisterListener)block).onItemBlockRegistered((Item)ib);
            }
        }
        if (block instanceof IRegisterListener) {
            rl = (IRegisterListener)block;
            rl.onRegistered();
            RegisterHook.HookCollector.propagate(rl);
        }
        if (block instanceof INoBlockstate) {
            HammerCore.renderProxy.noModel(block);
        }
        if (!(block instanceof IDontWantToRegisterTileEntity)) {
            Class<?> c;
            ITileEntityProvider te;
            TileEntity t;
            if (block instanceof ITileBlock) {
                Class c2 = ((ITileBlock)block).getTileClass();
                if (TileEntity.func_190559_a(c2) == null) {
                    TileEntity.func_190560_a((String)(modid + ":" + c2.getName().substring(c2.getName().lastIndexOf(".") + 1).toLowerCase()), c2);
                }
            } else if (block instanceof ITileEntityProvider && (t = (te = (ITileEntityProvider)block).func_149915_a(null, 0)) != null && TileEntity.func_190559_a(c = t.getClass()) == null) {
                TileEntity.func_190560_a((String)(modid + ":" + c.getName().substring(c.getName().lastIndexOf(".") + 1).toLowerCase()), c);
            }
        }
        if (!(block instanceof INoItemBlock)) {
            Item i = Item.func_150898_a((Block)block);
            if (i instanceof IRegisterListener) {
                IRegisterListener rl2 = (IRegisterListener)i;
                rl2.onRegistered();
                RegisterHook.HookCollector.propagate(rl2);
            }
            if (i != null) {
                ItemsHC.items.add(i);
            }
        }
    }

    public static void registerConstantRecipes(Class<?> base) {
        for (Method m : base.getDeclaredMethods()) {
            Type type;
            int mod = m.getModifiers();
            if (!Modifier.isStatic(mod) || m.getAnnotation(RecipeRegister.class) == null || m.getParameterTypes().length != 1 || !List.class.isAssignableFrom(m.getParameterTypes()[0]) || !((type = m.getParameters()[0].getParameterizedType()) instanceof ParameterizedType) || !Class.class.isAssignableFrom((type = ((ParameterizedType)type).getActualTypeArguments()[0]).getClass()) || !IRecipe.class.getName().equals(type.getTypeName())) continue;
            m.setAccessible(true);
            Method $ = m;
            RECIPE_GENERATORS.add(() -> {
                ArrayList recipes = new ArrayList();
                try {
                    $.invoke(null, recipes);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    e.printStackTrace();
                }
                return recipes;
            });
        }
    }

    public static void $addRegisterRecipes(Consumer<IRecipe> registry) {
        for (Supplier<List<IRecipe>> recipes : RECIPE_GENERATORS) {
            recipes.get().forEach(registry);
        }
    }
}

